/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBExtension;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureUpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBMetricsDAO
extends AbstractBanyanDBDAO
implements IMetricsDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBMetricsDAO.class);
    private final StorageBuilder<Metrics> storageBuilder;

    public BanyanDBMetricsDAO(BanyanDBStorageClient client, StorageBuilder<Metrics> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) throws IOException {
        log.info("multiGet {} from BanyanDB", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        String tc = model.getBanyanDBModelExtension().getTimestampColumn();
        String tsCol = Strings.isBlank((String)tc) ? "time_bucket" : tc;
        long begin = 0L;
        long end = 0L;
        final HashMap<String, List<String>> seriesIDColumns = new HashMap<String, List<String>>();
        model.getColumns().forEach(c -> {
            BanyanDBExtension ext = c.getBanyanDBExtension();
            if (ext == null) {
                return;
            }
            if (ext.isShardingKey()) {
                seriesIDColumns.put(c.getColumnName().getName(), new ArrayList());
            }
        });
        if (seriesIDColumns.isEmpty()) {
            seriesIDColumns.put("entity_id", new ArrayList());
        }
        StringBuilder idStr = new StringBuilder();
        for (Metrics m : metrics) {
            AnalyticalResult result = this.analyze(m, tsCol, seriesIDColumns);
            idStr.append(result.cols()).append("=").append(m.id().build()).append(",");
            if (!result.success) continue;
            if (begin == 0L || result.begin < begin) {
                begin = result.begin;
            }
            if (end != 0L && result.end <= end) continue;
            end = result.end;
        }
        TimestampRange timestampRange = null;
        if (begin != 0L || end != 0L) {
            timestampRange = new TimestampRange(begin, end);
        } else {
            log.info("{}[{}] will scan all blocks", (Object)model.getName(), (Object)idStr);
        }
        ArrayList<Metrics> metricsInStorage = new ArrayList<Metrics>(metrics.size());
        MeasureQueryResponse resp = this.query(model.getName(), schema.getTags(), schema.getFields(), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                seriesIDColumns.entrySet().forEach(entry -> {
                    if (!((List)entry.getValue()).isEmpty()) {
                        query.or(this.in((String)entry.getKey(), (List)entry.getValue()));
                    }
                });
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        for (DataPoint dataPoint : resp.getDataPoints()) {
            metricsInStorage.add((Metrics)this.storageBuilder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint)));
        }
        return metricsInStorage;
    }

    public InsertRequest prepareBatchInsert(Model model, Metrics metrics, SessionCacheCallback callback) throws IOException {
        log.info("prepare to insert {}", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        MeasureWrite measureWrite = new MeasureWrite(schema.getMetadata().getGroup(), schema.getMetadata().name(), TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.MeasureToStorage toStorage = new BanyanDBConverter.MeasureToStorage(schema, measureWrite);
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        if (model.getBanyanDBModelExtension().isStoreIDTag()) {
            toStorage.acceptID(metrics.id().build());
        }
        return new BanyanDBMeasureInsertRequest(toStorage.obtain(), callback);
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics, SessionCacheCallback callback) throws IOException {
        log.info("prepare to update {}", (Object)model.getName());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        MeasureWrite measureWrite = new MeasureWrite(schema.getMetadata().getGroup(), schema.getMetadata().name(), TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling()));
        BanyanDBConverter.MeasureToStorage toStorage = new BanyanDBConverter.MeasureToStorage(schema, measureWrite);
        this.storageBuilder.entity2Storage((StorageData)metrics, (Convert2Storage)toStorage);
        if (model.getBanyanDBModelExtension().isStoreIDTag()) {
            toStorage.acceptID(metrics.id().build());
        }
        return new BanyanDBMeasureUpdateRequest(toStorage.obtain());
    }

    private AnalyticalResult analyze(Metrics m, String tsCol, Map<String, List<String>> seriesIDColumns) {
        StorageID id = m.id();
        List fragments = id.read();
        AnalyticalResult result = new AnalyticalResult();
        for (StorageID.Fragment f : fragments) {
            Optional cols = f.getName();
            if (cols.isPresent()) {
                result.cols.add((String[])cols.get());
                for (String col : (String[])cols.get()) {
                    if (tsCol.equals(col)) {
                        long timeBucket = (Long)f.getValue();
                        long epoch = TimeBucket.getTimestamp((long)timeBucket);
                        if (result.begin == 0L || epoch < result.begin) {
                            result.begin = epoch;
                        }
                        if (result.end != 0L && epoch <= result.end) continue;
                        result.end = epoch;
                        continue;
                    }
                    if (seriesIDColumns.containsKey(col)) {
                        Preconditions.checkState((boolean)f.getType().equals(String.class));
                        seriesIDColumns.get(col).add((String)f.getValue());
                        continue;
                    }
                    log.error("col [{}] in fragment [{}] in id [{}] is not ts or seriesID", new Object[]{col, f, id.build()});
                    return result;
                }
                continue;
            }
            log.error("fragment [{}] in id [{}] doesn't contains cols", (Object)f, (Object)id.build());
            return result;
        }
        result.success = true;
        return result;
    }

    private static class AnalyticalResult {
        private boolean success;
        private List<String[]> cols = new ArrayList<String[]>();
        private long begin;
        private long end;

        private AnalyticalResult() {
        }

        private String cols() {
            StringBuilder b = new StringBuilder();
            for (String[] col : this.cols) {
                for (String c : col) {
                    b.append(c).append(",");
                }
                b.append(" ");
            }
            return b.toString();
        }
    }
}

