/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListenerFactory;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.CommonAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EndpointDependencyBuilder;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.ExitAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.LocalAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.RPCTrafficSourceBuilder;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EndpointDepFromCrossThreadAnalysisListener
extends CommonAnalysisListener
implements ExitAnalysisListener,
LocalAnalysisListener {
    private final SourceReceiver sourceReceiver;
    private final AnalyzerModuleConfig config;
    private final NamingControl namingControl;
    private final List<EndpointDependencyBuilder> depBuilders = new ArrayList<EndpointDependencyBuilder>(10);

    @Override
    public boolean containsPoint(AnalysisListener.Point point) {
        return AnalysisListener.Point.Exit.equals((Object)point) || AnalysisListener.Point.Local.equals((Object)point);
    }

    @Override
    public void parseExit(SpanObject span, SegmentObject segmentObject) {
        this.parseRefForEndpointDependency(span, segmentObject);
    }

    @Override
    public void parseLocal(SpanObject span, SegmentObject segmentObject) {
        this.parseRefForEndpointDependency(span, segmentObject);
    }

    private void parseRefForEndpointDependency(SpanObject span, SegmentObject segmentObject) {
        if (span.getSkipAnalysis()) {
            return;
        }
        if (span.getRefsCount() > 0) {
            for (int i = 0; i < span.getRefsCount(); ++i) {
                SegmentReference reference = span.getRefs(i);
                RPCTrafficSourceBuilder sourceBuilder = new RPCTrafficSourceBuilder(this.namingControl);
                if (StringUtil.isEmpty((String)reference.getParentEndpoint())) {
                    sourceBuilder.setSourceEndpointName("User");
                } else {
                    sourceBuilder.setSourceEndpointName(reference.getParentEndpoint());
                }
                String networkAddressUsedAtPeer = reference.getNetworkAddressUsedAtPeer();
                boolean isMQ = span.getSpanLayer().equals((Object)SpanLayer.MQ);
                if (isMQ || this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(networkAddressUsedAtPeer)) {
                    sourceBuilder.setSourceServiceName(networkAddressUsedAtPeer);
                    sourceBuilder.setSourceEndpointOwnerServiceName(reference.getParentService());
                    sourceBuilder.setSourceServiceInstanceName(networkAddressUsedAtPeer);
                    if (isMQ) {
                        sourceBuilder.setSourceLayer(Layer.VIRTUAL_MQ);
                    } else {
                        sourceBuilder.setSourceLayer(Layer.VIRTUAL_GATEWAY);
                    }
                    sourceBuilder.setSourceEndpointOwnerServiceLayer(Layer.GENERAL);
                } else {
                    sourceBuilder.setSourceServiceName(reference.getParentService());
                    sourceBuilder.setSourceServiceInstanceName(reference.getParentServiceInstance());
                    sourceBuilder.setSourceLayer(Layer.GENERAL);
                }
                sourceBuilder.setDestEndpointName(span.getOperationName());
                sourceBuilder.setDestServiceInstanceName(segmentObject.getServiceInstance());
                sourceBuilder.setDestServiceName(segmentObject.getService());
                sourceBuilder.setDestLayer(this.identifyServiceLayer(span.getSpanLayer()));
                sourceBuilder.setDetectPoint(DetectPoint.SERVER);
                sourceBuilder.setComponentId(span.getComponentId());
                this.setPublicAttrs(sourceBuilder, span);
                this.depBuilders.add(new EndpointDependencyBuilder(sourceBuilder));
            }
        }
    }

    private void setPublicAttrs(RPCTrafficSourceBuilder sourceBuilder, SpanObject span) {
        long latency = span.getEndTime() - span.getStartTime();
        sourceBuilder.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)span.getStartTime()));
        sourceBuilder.setLatency((int)latency);
        sourceBuilder.setHttpResponseStatusCode(0);
        span.getTagsList().forEach(sourceBuilder::setTag);
        sourceBuilder.setStatus(!span.getIsError());
    }

    @Override
    public void build() {
        this.depBuilders.forEach(endpointDep -> {
            this.sourceReceiver.receive((ISource)endpointDep.toSourceEndpoint());
            this.sourceReceiver.receive((ISource)endpointDep.toEndpoint());
            this.sourceReceiver.receive((ISource)endpointDep.toEndpointRelation());
        });
    }

    @Generated
    public EndpointDepFromCrossThreadAnalysisListener(SourceReceiver sourceReceiver, AnalyzerModuleConfig config, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.config = config;
        this.namingControl = namingControl;
    }

    public static class Factory
    implements AnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public AnalysisListener create(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            return new EndpointDepFromCrossThreadAnalysisListener(this.sourceReceiver, config, this.namingControl);
        }
    }
}

