/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.webapp;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import java.util.Collections;
import org.apache.skywalking.oap.server.webapp.Configuration;
import org.apache.skywalking.oap.server.webapp.OapProxyService;
import org.apache.skywalking.oap.server.webapp.ZipkinProxyService;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.env.EnvScalarConstructor;

public class ApplicationStartUp {
    public static void main(String[] args) throws Exception {
        Yaml yaml = new Yaml(new EnvScalarConstructor(new TypeDescription(Configuration.class), Collections.emptyList(), new LoaderOptions()));
        yaml.addImplicitResolver(EnvScalarConstructor.ENV_TAG, EnvScalarConstructor.ENV_FORMAT, "$");
        Configuration configuration = yaml.loadAs(ApplicationStartUp.class.getResourceAsStream("/application.yml"), Configuration.class);
        int port = configuration.port();
        String[] oapServices = configuration.oapServices();
        HttpService indexPage = HttpFile.of(ApplicationStartUp.class.getClassLoader(), "/public/index.html").asService();
        HttpService zipkinIndexPage = HttpFile.of(ApplicationStartUp.class.getClassLoader(), "/zipkin-lens/index.html").asService();
        ZipkinProxyService zipkin = new ZipkinProxyService(configuration.zipkinServices());
        Server.builder().port(port, SessionProtocol.HTTP).service("/graphql", (HttpService)new OapProxyService(oapServices)).service("/internal/l7check", (HttpService)HealthCheckService.of(new HealthChecker[0])).service("/zipkin/config.json", (HttpService)zipkin).serviceUnder("/zipkin/api", zipkin).serviceUnder("/zipkin", FileService.of(ApplicationStartUp.class.getClassLoader(), "/zipkin-lens").orElse(zipkinIndexPage)).serviceUnder("/", FileService.of(ApplicationStartUp.class.getClassLoader(), "/public").orElse(indexPage)).build().start().join();
    }
}

