/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.contextpropagation;

import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;

public class ObservationThreadLocalAccessor
implements ThreadLocalAccessor<Observation> {
    public static final String KEY = "micrometer.observation";
    private static final String SCOPE_KEY = "micrometer.observation.scope";
    private static final ObservationRegistry observationRegistry = ObservationRegistry.create();

    public Object key() {
        return KEY;
    }

    public Observation getValue() {
        Observation.Scope scope = observationRegistry.getCurrentObservationScope();
        if (scope != null) {
            Observation observation = scope.getCurrentObservation();
            observation.getContext().put(SCOPE_KEY, scope);
            return observation;
        }
        return null;
    }

    public void setValue(Observation value) {
        value.openScope();
    }

    public void reset() {
        Observation.Scope scope = observationRegistry.getCurrentObservationScope();
        if (scope != null) {
            scope.reset();
        }
    }

    public void restore(Observation value) {
        this.reset();
        Observation.Scope observationScope = (Observation.Scope)value.getContext().get(SCOPE_KEY);
        if (observationScope != null) {
            observationScope.close();
        }
        this.setValue(value);
    }
}

