/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.common.logging.LoggingDecorators;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.logging.LoggingServiceBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingService
extends SimpleDecoratingHttpService {
    private static final Logger defaultLogger = LoggerFactory.getLogger(LoggingService.class);
    private final RequestLogger requestLogger = new RequestLogger();
    private final ResponseLogger responseLogger = new ResponseLogger();
    private final Logger logger;
    private final RequestLogLevelMapper requestLogLevelMapper;
    private final ResponseLogLevelMapper responseLogLevelMapper;
    private final BiFunction<? super RequestContext, ? super RequestHeaders, ? extends @Nullable Object> requestHeadersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super ResponseHeaders, ? extends @Nullable Object> responseHeadersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer;
    private final Sampler<? super RequestLog> sampler;

    public static Function<? super HttpService, LoggingService> newDecorator() {
        return LoggingService.builder().newDecorator();
    }

    public static LoggingServiceBuilder builder() {
        return new LoggingServiceBuilder();
    }

    LoggingService(HttpService delegate, @Nullable Logger logger, RequestLogLevelMapper requestLogLevelMapper, ResponseLogLevelMapper responseLogLevelMapper, BiFunction<? super RequestContext, ? super RequestHeaders, ? extends @Nullable Object> requestHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super ResponseHeaders, ? extends @Nullable Object> responseHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer, BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer, Sampler<? super ServiceRequestContext> successSampler, Sampler<? super ServiceRequestContext> failureSampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.logger = MoreObjects.firstNonNull(logger, defaultLogger);
        this.requestLogLevelMapper = Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        this.responseLogLevelMapper = Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        this.requestTrailersSanitizer = Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        this.responseTrailersSanitizer = Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        this.responseCauseSanitizer = Objects.requireNonNull(responseCauseSanitizer, "responseCauseSanitizer");
        Objects.requireNonNull(successSampler, "successSampler");
        Objects.requireNonNull(failureSampler, "failureSampler");
        this.sampler = requestLog -> {
            ServiceRequestContext ctx = (ServiceRequestContext)requestLog.context();
            if (ctx.config().successFunction().isSuccess(ctx, (RequestLog)requestLog)) {
                return successSampler.isSampled(ctx);
            }
            return failureSampler.isSampled(ctx);
        };
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        ctx.setShouldReportUnhandledExceptions(false);
        ctx.log().whenComplete().thenAccept(requestLog -> {
            if (this.sampler.isSampled((RequestLog)requestLog)) {
                LoggingDecorators.log(this.logger, ctx, requestLog, this.requestLogger, this.responseLogger);
            }
        });
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }

    private class RequestLogger
    implements Consumer<RequestOnlyLog> {
        private RequestLogger() {
        }

        @Override
        public void accept(RequestOnlyLog log) {
            LoggingDecorators.logRequest(LoggingService.this.logger, log, LoggingService.this.requestLogLevelMapper, LoggingService.this.requestHeadersSanitizer, LoggingService.this.requestContentSanitizer, LoggingService.this.requestTrailersSanitizer);
        }
    }

    private class ResponseLogger
    implements Consumer<RequestLog> {
        private ResponseLogger() {
        }

        @Override
        public void accept(RequestLog log) {
            LoggingDecorators.logResponse(LoggingService.this.logger, log, LoggingService.this.requestLogLevelMapper, LoggingService.this.responseLogLevelMapper, LoggingService.this.requestHeadersSanitizer, LoggingService.this.requestContentSanitizer, LoggingService.this.requestTrailersSanitizer, LoggingService.this.responseHeadersSanitizer, LoggingService.this.responseContentSanitizer, LoggingService.this.responseTrailersSanitizer, LoggingService.this.responseCauseSanitizer);
        }
    }
}

