/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.file.DefaultMediaTypeResolver;
import java.util.Objects;

@FunctionalInterface
public interface MediaTypeResolver {
    public static MediaTypeResolver ofDefault() {
        return DefaultMediaTypeResolver.INSTANCE;
    }

    @Nullable
    public MediaType guessFromPath(String var1, @Nullable String var2);

    default public MediaTypeResolver orElse(MediaTypeResolver other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return (path, contentEncoding) -> {
            MediaType mediaType = this.guessFromPath(path, contentEncoding);
            if (mediaType != null) {
                return mediaType;
            }
            return other.guessFromPath(path, contentEncoding);
        };
    }
}

