/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.file.AggregatedHttpFile;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import io.netty.buffer.ByteBufAllocator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeferredHttpFile
implements HttpFile {
    private static final Logger logger = LoggerFactory.getLogger(DeferredHttpFile.class);
    private static boolean warnedNullDelegate;
    private final CompletableFuture<? extends HttpFile> stage;
    @Nullable
    private volatile HttpFile delegate;

    DeferredHttpFile(CompletionStage<? extends HttpFile> stage) {
        this.stage = Objects.requireNonNull(stage, "stage").toCompletableFuture();
        if (this.stage.isDone() && !this.stage.isCompletedExceptionally()) {
            this.setDelegate(this.stage.getNow(null));
        }
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.readAttributes(fileReadExecutor);
        }
        return this.stage.thenCompose(file -> {
            this.setDelegate((HttpFile)file);
            return file.readAttributes(fileReadExecutor);
        });
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.readHeaders(fileReadExecutor);
        }
        return this.stage.thenCompose(file -> {
            this.setDelegate((HttpFile)file);
            return file.readHeaders(fileReadExecutor);
        });
    }

    @Override
    public CompletableFuture<HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(alloc, "alloc");
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.read(fileReadExecutor, alloc);
        }
        return this.stage.thenCompose(file -> {
            this.setDelegate((HttpFile)file);
            return file.read(fileReadExecutor, alloc);
        });
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.aggregate(fileReadExecutor);
        }
        return this.stage.thenCompose(file -> {
            this.setDelegate((HttpFile)file);
            return file.aggregate(fileReadExecutor);
        });
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(alloc, "alloc");
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.aggregateWithPooledObjects(fileReadExecutor, alloc);
        }
        return this.stage.thenCompose(file -> {
            this.setDelegate((HttpFile)file);
            return file.aggregateWithPooledObjects(fileReadExecutor, alloc);
        });
    }

    @Override
    public HttpService asService() {
        HttpFile delegate = this.delegate;
        if (delegate != null) {
            return delegate.asService();
        }
        return (ctx, req) -> HttpResponse.from(this.stage.thenApply(file -> {
            this.setDelegate((HttpFile)file);
            try {
                return file.asService().serve(ctx, req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely(e);
            }
        }));
    }

    private void setDelegate(@Nullable HttpFile delegate) {
        if (delegate == null) {
            if (!warnedNullDelegate) {
                warnedNullDelegate = true;
                logger.warn("The delegate stage produced a null file; treating as a non-existent file.");
            }
            delegate = HttpFile.nonExistent();
        }
        this.delegate = delegate;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("delegate", this.delegate).toString();
    }
}

