/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import com.aayushatharva.brotli4j.encoder.Encoder;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import io.netty.handler.codec.compression.Brotli;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

final class HttpEncoders {
    private static final Encoder.Parameters BROTLI_PARAMETERS = new Encoder.Parameters().setQuality(4);

    @Nullable
    static HttpEncodingType getWrapperForRequest(HttpRequest request) {
        String acceptEncoding = request.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
        if (acceptEncoding == null) {
            return null;
        }
        return HttpEncoders.determineEncoding(acceptEncoding);
    }

    static OutputStream getEncodingOutputStream(HttpEncodingType encodingType, OutputStream out) {
        switch (encodingType) {
            case GZIP: {
                try {
                    return new GZIPOutputStream(out, true);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error writing gzip header. This should not happen with byte arrays.", e);
                }
            }
            case DEFLATE: {
                return new DeflaterOutputStream(out, true);
            }
            case BROTLI: {
                try {
                    return new BrotliOutputStream(out, BROTLI_PARAMETERS);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error writing brotli header. This should not happen with byte arrays.", e);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected zlib type, this is a programming bug.");
    }

    @Nullable
    private static HttpEncodingType determineEncoding(String acceptEncoding) {
        Map.Entry entry;
        float starQ = -1.0f;
        LinkedHashMap<HttpEncodingType, Float> encodings = new LinkedHashMap<HttpEncodingType, Float>();
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("br") && Brotli.isAvailable()) {
                encodings.put(HttpEncodingType.BROTLI, Float.valueOf(q));
                continue;
            }
            if (encoding.contains("gzip")) {
                encodings.put(HttpEncodingType.GZIP, Float.valueOf(q));
                continue;
            }
            if (!encoding.contains("deflate")) continue;
            encodings.put(HttpEncodingType.DEFLATE, Float.valueOf(q));
        }
        if (!encodings.isEmpty() && ((Float)(entry = Collections.max(encodings.entrySet(), Map.Entry.comparingByValue())).getValue()).floatValue() > 0.0f) {
            return (HttpEncodingType)((Object)entry.getKey());
        }
        if (starQ > 0.0f) {
            if (!encodings.containsKey((Object)HttpEncodingType.BROTLI) && Brotli.isAvailable()) {
                return HttpEncodingType.BROTLI;
            }
            if (!encodings.containsKey((Object)HttpEncodingType.GZIP)) {
                return HttpEncodingType.GZIP;
            }
            if (!encodings.containsKey((Object)HttpEncodingType.DEFLATE)) {
                return HttpEncodingType.DEFLATE;
            }
        }
        return null;
    }

    private HttpEncoders() {
    }

    static {
        Brotli.isAvailable();
    }
}

