/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class StructInfo
implements DescriptiveTypeInfo {
    private final String name;
    @Nullable
    private final String alias;
    private final List<FieldInfo> fields;
    private final DescriptionInfo descriptionInfo;

    public StructInfo(String name, Iterable<FieldInfo> fields) {
        this(name, null, fields, DescriptionInfo.empty());
    }

    public StructInfo(String name, Iterable<FieldInfo> fields, DescriptionInfo descriptionInfo) {
        this(name, null, fields, descriptionInfo);
    }

    public StructInfo(String name, @Nullable String alias, Iterable<FieldInfo> fields, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.alias = alias;
        this.fields = ImmutableList.copyOf(Objects.requireNonNull(fields, "fields"));
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public String alias() {
        return this.alias;
    }

    public StructInfo withAlias(String alias) {
        Objects.requireNonNull(alias, "alias");
        if (alias.equals(this.alias)) {
            return this;
        }
        return new StructInfo(this.name, alias, this.fields, this.descriptionInfo);
    }

    @JsonProperty
    public List<FieldInfo> fields() {
        return this.fields;
    }

    public StructInfo withFields(Iterable<FieldInfo> fields) {
        Objects.requireNonNull(fields, "fields");
        if (fields.equals(this.fields)) {
            return this;
        }
        return new StructInfo(this.name, this.alias, fields, this.descriptionInfo);
    }

    @Override
    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public StructInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new StructInfo(this.name, this.alias, this.fields, descriptionInfo);
    }

    @Override
    public Set<DescriptiveTypeSignature> findDescriptiveTypes() {
        HashSet collectedDescriptiveTypes = new HashSet();
        this.fields().forEach(f -> ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, f.typeSignature()));
        return ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::name), collectedDescriptiveTypes);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructInfo)) {
            return false;
        }
        StructInfo that = (StructInfo)o;
        return this.name.equals(that.name) && Objects.equals(this.alias, that.alias) && this.fields.equals(that.fields) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.alias, this.fields, this.descriptionInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("alias", this.alias).add("fields", this.fields).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

