/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.FieldInfoBuilder;
import com.linecorp.armeria.server.docs.FieldLocation;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Objects;

public final class FieldInfo {
    private final String name;
    private final FieldLocation location;
    private final FieldRequirement requirement;
    private final TypeSignature typeSignature;
    private final DescriptionInfo descriptionInfo;

    public static FieldInfo of(String name, TypeSignature typeSignature) {
        return new FieldInfo(name, FieldLocation.UNSPECIFIED, FieldRequirement.UNSPECIFIED, typeSignature, DescriptionInfo.empty());
    }

    public static FieldInfo of(String name, TypeSignature typeSignature, DescriptionInfo descriptionInfo) {
        return new FieldInfo(name, FieldLocation.UNSPECIFIED, FieldRequirement.UNSPECIFIED, typeSignature, descriptionInfo);
    }

    public static FieldInfoBuilder builder(String name, TypeSignature typeSignature) {
        return new FieldInfoBuilder(name, typeSignature);
    }

    FieldInfo(String name, FieldLocation location, FieldRequirement requirement, TypeSignature typeSignature, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.location = Objects.requireNonNull(location, "name");
        this.requirement = Objects.requireNonNull(requirement, "requirement");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature");
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public FieldLocation location() {
        return this.location;
    }

    @JsonProperty
    public FieldRequirement requirement() {
        return this.requirement;
    }

    @JsonProperty
    public TypeSignature typeSignature() {
        return this.typeSignature;
    }

    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public FieldInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new FieldInfo(this.name, this.location, this.requirement, this.typeSignature, descriptionInfo);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return this.name.equals(that.name) && this.location == that.location && this.requirement == that.requirement && this.typeSignature.equals(that.typeSignature) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.location, this.requirement, this.typeSignature, this.descriptionInfo});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("location", (Object)this.location).add("requirement", (Object)this.requirement).add("typeSignature", this.typeSignature).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

