/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import java.util.List;
import java.util.Map;

final class DocStringSupport {
    private final Map<String, DescriptionInfo> descriptionInfos = DocService.plugins.stream().flatMap(plugin -> plugin.loadDocStrings(DocService.findSupportedServices(plugin, services)).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));

    DocStringSupport(List<ServiceConfig> services) {
    }

    ServiceSpecification addDocStrings(ServiceSpecification spec) {
        return new ServiceSpecification(spec.services().stream().map(this::addServiceDocStrings).collect(ImmutableList.toImmutableList()), spec.enums().stream().map(this::addEnumDocStrings).collect(ImmutableList.toImmutableList()), spec.structs().stream().map(this::addStructDocStrings).collect(ImmutableList.toImmutableList()), spec.exceptions().stream().map(this::addExceptionDocStrings).collect(ImmutableList.toImmutableList()), spec.exampleHeaders());
    }

    private ServiceInfo addServiceDocStrings(ServiceInfo service) {
        DescriptionInfo descriptionInfo = this.findDescription(service.name(), service.descriptionInfo());
        List methodsWithDescription = service.methods().stream().map(method -> this.addMethodDocStrings(service, (MethodInfo)method)).collect(ImmutableList.toImmutableList());
        return service.withMethods(methodsWithDescription).withDescriptionInfo(descriptionInfo);
    }

    private MethodInfo addMethodDocStrings(ServiceInfo service, MethodInfo method) {
        DescriptionInfo descriptionInfo = this.findDescription(service.name() + '/' + method.name(), method.descriptionInfo());
        List paramsWithDescription = method.parameters().stream().map(field -> this.addParameterDocString(service, method, (FieldInfo)field)).collect(ImmutableList.toImmutableList());
        return method.withParameters(paramsWithDescription).withDescriptionInfo(descriptionInfo);
    }

    private FieldInfo addParameterDocString(ServiceInfo service, MethodInfo method, FieldInfo field) {
        DescriptionInfo descriptionInfo = this.findDescription(service.name() + '/' + method.name() + '/' + field.name(), field.descriptionInfo());
        return field.withDescriptionInfo(descriptionInfo);
    }

    private EnumInfo addEnumDocStrings(EnumInfo e) {
        DescriptionInfo descriptionInfo = this.findDescription(e.name(), e.descriptionInfo());
        List valuesWithDescription = e.values().stream().map(v -> this.addEnumValueDocString(e, (EnumValueInfo)v)).collect(ImmutableList.toImmutableList());
        return e.withValues(valuesWithDescription).withDescriptionInfo(descriptionInfo);
    }

    private EnumValueInfo addEnumValueDocString(EnumInfo e, EnumValueInfo v) {
        DescriptionInfo descriptionInfo = this.findDescription(e.name() + '/' + v.name(), v.descriptionInfo());
        return v.withDescriptionInfo(descriptionInfo);
    }

    private StructInfo addStructDocStrings(StructInfo struct) {
        DescriptionInfo descriptionInfo = this.findDescription(struct.name(), struct.descriptionInfo());
        List fieldsWithDescription = struct.fields().stream().map(field -> this.addFieldDocString(struct, (FieldInfo)field)).collect(ImmutableList.toImmutableList());
        return struct.withFields(fieldsWithDescription).withDescriptionInfo(descriptionInfo);
    }

    private ExceptionInfo addExceptionDocStrings(ExceptionInfo e) {
        DescriptionInfo descriptionInfo = this.findDescription(e.name(), e.descriptionInfo());
        List fieldsWithDescription = e.fields().stream().map(field -> this.addFieldDocString(e, (FieldInfo)field)).collect(ImmutableList.toImmutableList());
        return e.withFields(fieldsWithDescription).withDescriptionInfo(descriptionInfo);
    }

    private FieldInfo addFieldDocString(DescriptiveTypeInfo parent, FieldInfo field) {
        DescriptionInfo descriptionInfo = this.findDescription(parent.name() + '/' + field.name(), field.descriptionInfo());
        return field.withDescriptionInfo(descriptionInfo);
    }

    private DescriptionInfo findDescription(String key, DescriptionInfo currentDescriptionInfo) {
        if (currentDescriptionInfo != DescriptionInfo.empty()) {
            return currentDescriptionInfo;
        }
        return this.descriptionInfos.getOrDefault(key, DescriptionInfo.empty());
    }
}

