/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.TlsSetters;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.util.SelfSignedCertificate;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import com.linecorp.armeria.internal.shaded.guava.net.HostAndPort;
import com.linecorp.armeria.server.AnnotatedServiceBindingBuilder;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.FallbackService;
import com.linecorp.armeria.server.FunctionalDecoratingHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.RejectedRouteHandler;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.RouteDecoratingService;
import com.linecorp.armeria.server.Routers;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerSslContextUtil;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.UnhandledExceptionsReporter;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.VirtualHostAnnotatedServiceBindingBuilder;
import com.linecorp.armeria.server.VirtualHostDecoratingServiceBindingBuilder;
import com.linecorp.armeria.server.VirtualHostServiceBindingBuilder;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualHostBuilder
implements TlsSetters {
    private final ServerBuilder serverBuilder;
    private final boolean defaultVirtualHost;
    private final boolean portBased;
    private final List<ServiceConfigSetters> serviceConfigSetters = new ArrayList<ServiceConfigSetters>();
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();
    private final HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
    @Nullable
    private String defaultHostname;
    @Nullable
    private String hostnamePattern;
    private int port = -1;
    @Nullable
    private Supplier<SslContextBuilder> sslContextBuilderSupplier;
    @Nullable
    private Boolean tlsSelfSigned;
    @Nullable
    private SelfSignedCertificate selfSignedCertificate;
    private final List<Consumer<? super SslContextBuilder>> tlsCustomizers = new ArrayList<Consumer<? super SslContextBuilder>>();
    @Nullable
    private Boolean tlsAllowUnsafeCiphers;
    private final LinkedList<RouteDecoratingService> routeDecoratingServices = new LinkedList();
    @Nullable
    private Function<? super VirtualHost, ? extends Logger> accessLoggerMapper;
    @Nullable
    private RejectedRouteHandler rejectedRouteHandler;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private AnnotatedServiceExtensions annotatedServiceExtensions;
    @Nullable
    private BlockingTaskExecutor blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Path multipartUploadsLocation;
    @Nullable
    private Function<? super RoutingContext, ? extends RequestId> requestIdGenerator;
    @Nullable
    private ServiceErrorHandler errorHandler;

    VirtualHostBuilder(ServerBuilder serverBuilder, boolean defaultVirtualHost) {
        this.serverBuilder = Objects.requireNonNull(serverBuilder, "serverBuilder");
        this.defaultVirtualHost = defaultVirtualHost;
        this.portBased = false;
    }

    VirtualHostBuilder(ServerBuilder serverBuilder, int port) {
        this.serverBuilder = Objects.requireNonNull(serverBuilder, "serverBuilder");
        this.port = port;
        this.portBased = true;
        this.defaultVirtualHost = true;
    }

    public ServerBuilder and() {
        return this.serverBuilder;
    }

    public VirtualHostBuilder defaultHostname(String defaultHostname) {
        this.defaultHostname = VirtualHost.normalizeDefaultHostname(defaultHostname);
        return this;
    }

    public VirtualHostBuilder hostnamePattern(String hostnamePattern) {
        if (this.defaultVirtualHost) {
            throw new UnsupportedOperationException("Cannot set hostnamePattern for the default virtual host builder");
        }
        Preconditions.checkArgument(!hostnamePattern.isEmpty(), "hostnamePattern is empty.");
        HostAndPort hostAndPort = HostAndPort.fromString(hostnamePattern);
        if (hostAndPort.hasPort()) {
            this.port = hostAndPort.getPort();
            Preconditions.checkArgument(this.port >= 1 && this.port <= 65535, "port: %s (expected: 1-65535)", this.port);
            hostnamePattern = hostAndPort.getHost();
        }
        boolean validHostnamePattern = hostnamePattern.charAt(0) == '*' ? hostnamePattern.length() >= 3 && hostnamePattern.charAt(1) == '.' && VirtualHost.HOSTNAME_WITH_NO_PORT_PATTERN.matcher(hostnamePattern.substring(2)).matches() : VirtualHost.HOSTNAME_WITH_NO_PORT_PATTERN.matcher(hostnamePattern).matches();
        Preconditions.checkArgument(validHostnamePattern, "hostnamePattern: %s (expected: *.<hostname> or <hostname>)", (Object)hostnamePattern);
        this.hostnamePattern = VirtualHost.normalizeHostnamePattern(hostnamePattern);
        return this;
    }

    @Override
    public VirtualHostBuilder tls(File keyCertChainFile, File keyFile) {
        return (VirtualHostBuilder)TlsSetters.super.tls(keyCertChainFile, keyFile);
    }

    @Override
    public VirtualHostBuilder tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        Objects.requireNonNull(keyFile, "keyFile");
        return this.tls(() -> SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
    }

    @Override
    public VirtualHostBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return (VirtualHostBuilder)TlsSetters.super.tls(keyCertChainInputStream, keyInputStream);
    }

    @Override
    public VirtualHostBuilder tls(InputStream keyCertChainInputStream, InputStream keyInputStream, @Nullable String keyPassword) {
        byte[] key;
        byte[] keyCertChain;
        Objects.requireNonNull(keyCertChainInputStream, "keyCertChainInputStream");
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        try {
            keyCertChain = ByteStreams.toByteArray(keyCertChainInputStream);
            key = ByteStreams.toByteArray(keyInputStream);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.tls(() -> SslContextBuilder.forServer(new ByteArrayInputStream(keyCertChain), new ByteArrayInputStream(key), keyPassword));
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, X509Certificate ... keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, @Nullable String keyPassword, X509Certificate ... keyCertChain) {
        return (VirtualHostBuilder)TlsSetters.super.tls(key, keyPassword, keyCertChain);
    }

    @Override
    public VirtualHostBuilder tls(PrivateKey key, @Nullable String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(keyCertChain, "keyCertChain");
        for (X509Certificate x509Certificate : keyCertChain) {
            Objects.requireNonNull(x509Certificate, "keyCertChain contains null.");
        }
        return this.tls(() -> SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    @Override
    public VirtualHostBuilder tls(KeyManagerFactory keyManagerFactory) {
        Objects.requireNonNull(keyManagerFactory, "keyManagerFactory");
        return this.tls(() -> SslContextBuilder.forServer(keyManagerFactory));
    }

    private VirtualHostBuilder tls(Supplier<SslContextBuilder> sslContextBuilderSupplier) {
        Objects.requireNonNull(sslContextBuilderSupplier, "sslContextBuilderSupplier");
        Preconditions.checkState(this.sslContextBuilderSupplier == null, "TLS has been configured already.");
        Preconditions.checkState(!this.portBased, "Cannot configure TLS to a port-based virtual host. Please configure to %s.tls()", ServerBuilder.class.getSimpleName());
        this.sslContextBuilderSupplier = sslContextBuilderSupplier;
        return this;
    }

    public VirtualHostBuilder tlsSelfSigned() {
        return this.tlsSelfSigned(true);
    }

    public VirtualHostBuilder tlsSelfSigned(boolean tlsSelfSigned) {
        Preconditions.checkState(!this.portBased, "Cannot configure self-signed to a port-based virtual host. Please configure to %s.tlsSelfSigned()", ServerBuilder.class.getSimpleName());
        this.tlsSelfSigned = tlsSelfSigned;
        return this;
    }

    @Override
    public VirtualHostBuilder tlsCustomizer(Consumer<? super SslContextBuilder> tlsCustomizer) {
        Objects.requireNonNull(tlsCustomizer, "tlsCustomizer");
        Preconditions.checkState(!this.portBased, "Cannot configure TLS to a port-based virtual host. Please configure to %s.tlsCustomizer()", ServerBuilder.class.getSimpleName());
        this.tlsCustomizers.add(tlsCustomizer);
        return this;
    }

    @Deprecated
    public VirtualHostBuilder tlsAllowUnsafeCiphers() {
        return this.tlsAllowUnsafeCiphers(true);
    }

    @Deprecated
    public VirtualHostBuilder tlsAllowUnsafeCiphers(boolean tlsAllowUnsafeCiphers) {
        this.tlsAllowUnsafeCiphers = tlsAllowUnsafeCiphers;
        return this;
    }

    public VirtualHostBuilder withRoute(Consumer<? super VirtualHostServiceBindingBuilder> customizer) {
        VirtualHostServiceBindingBuilder builder = new VirtualHostServiceBindingBuilder(this);
        customizer.accept(builder);
        return this;
    }

    public VirtualHostServiceBindingBuilder route() {
        return new VirtualHostServiceBindingBuilder(this);
    }

    public VirtualHostDecoratingServiceBindingBuilder routeDecorator() {
        return new VirtualHostDecoratingServiceBindingBuilder(this);
    }

    public VirtualHostBuilder serviceUnder(String pathPrefix, HttpService service) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        HttpServiceWithRoutes serviceWithRoutes = service.as(HttpServiceWithRoutes.class);
        if (serviceWithRoutes != null) {
            serviceWithRoutes.routes().forEach(route -> {
                ServiceConfigBuilder serviceConfigBuilder = new ServiceConfigBuilder(route.withPrefix(pathPrefix), service);
                serviceConfigBuilder.addMappedRoute((Route)route);
                this.addServiceConfigSetters(serviceConfigBuilder);
            });
        } else {
            this.service(Route.builder().pathPrefix(pathPrefix).build(), service);
        }
        return this;
    }

    public VirtualHostBuilder service(String pathPattern, HttpService service) {
        this.service(Route.builder().path(pathPattern).build(), service);
        return this;
    }

    public VirtualHostBuilder service(Route route, HttpService service) {
        return this.addServiceConfigSetters(new ServiceConfigBuilder(route, service));
    }

    public VirtualHostBuilder service(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(serviceWithRoutes, "serviceWithRoutes");
        Objects.requireNonNull(serviceWithRoutes.routes(), "serviceWithRoutes.routes()");
        Objects.requireNonNull(decorators, "decorators");
        HttpService decorated = ServerBuilder.decorate(serviceWithRoutes, decorators);
        serviceWithRoutes.routes().forEach(route -> this.service((Route)route, decorated));
        return this;
    }

    @SafeVarargs
    public final VirtualHostBuilder service(HttpServiceWithRoutes serviceWithRoutes, Function<? super HttpService, ? extends HttpService> ... decorators) {
        return this.service(serviceWithRoutes, ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    public VirtualHostBuilder annotatedService(Object service) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.of());
    }

    public VirtualHostBuilder annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public VirtualHostBuilder annotatedService(Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.of());
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Iterable<?> exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<?> exceptionHandlersAndConverters) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters");
        AnnotatedServiceExtensions configurator = AnnotatedServiceExtensions.ofExceptionHandlersAndConverters(exceptionHandlersAndConverters);
        return this.annotatedService(pathPrefix, service, decorator, configurator.exceptionHandlers(), configurator.requestConverters(), configurator.responseConverters());
    }

    public VirtualHostBuilder annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions, Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        return ((VirtualHostAnnotatedServiceBindingBuilder)((VirtualHostAnnotatedServiceBindingBuilder)((VirtualHostAnnotatedServiceBindingBuilder)((VirtualHostAnnotatedServiceBindingBuilder)this.annotatedService().pathPrefix(pathPrefix).decorator((Function)decorator)).exceptionHandlers((Iterable)exceptionHandlerFunctions)).requestConverters((Iterable)requestConverterFunctions)).responseConverters((Iterable)responseConverterFunctions)).build(service);
    }

    public VirtualHostAnnotatedServiceBindingBuilder annotatedService() {
        return new VirtualHostAnnotatedServiceBindingBuilder(this);
    }

    VirtualHostBuilder addServiceConfigSetters(ServiceConfigSetters serviceConfigSetters) {
        this.serviceConfigSetters.add(serviceConfigSetters);
        return this;
    }

    private List<ServiceConfigSetters> getServiceConfigSetters(@Nullable VirtualHostBuilder defaultVirtualHostBuilder) {
        ImmutableCollection serviceConfigSetters = defaultVirtualHostBuilder != null ? ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.serviceConfigSetters)).addAll(defaultVirtualHostBuilder.serviceConfigSetters)).build() : ImmutableList.copyOf(this.serviceConfigSetters);
        return serviceConfigSetters;
    }

    VirtualHostBuilder addRouteDecoratingService(RouteDecoratingService routeDecoratingService) {
        if (Flags.useLegacyRouteDecoratorOrdering()) {
            this.routeDecoratingServices.addLast(routeDecoratingService);
        } else {
            this.routeDecoratingServices.addFirst(routeDecoratingService);
        }
        return this;
    }

    @Nullable
    private Function<? super HttpService, ? extends HttpService> getRouteDecoratingService(@Nullable VirtualHostBuilder defaultVirtualHostBuilder) {
        ImmutableCollection routeDecoratingServices = defaultVirtualHostBuilder != null ? ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.routeDecoratingServices)).addAll(defaultVirtualHostBuilder.routeDecoratingServices)).build() : ImmutableList.copyOf(this.routeDecoratingServices);
        if (!routeDecoratingServices.isEmpty()) {
            return RouteDecoratingService.newDecorator(Routers.ofRouteDecoratingService(routeDecoratingServices));
        }
        return null;
    }

    public VirtualHostBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.ofCatchAll(), decorator);
    }

    public VirtualHostBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.ofCatchAll(), decoratingHttpServiceFunction);
    }

    public VirtualHostBuilder decorator(String pathPattern, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().path(pathPattern).build(), decoratingHttpServiceFunction);
    }

    public VirtualHostBuilder decorator(String pathPattern, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().path(pathPattern).build(), decorator);
    }

    public VirtualHostBuilder decorator(Route route, Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(decorator, "decorator");
        return this.addRouteDecoratingService(new RouteDecoratingService(route, decorator));
    }

    public VirtualHostBuilder decorator(Route route, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        Objects.requireNonNull(decoratingHttpServiceFunction, "decoratingHttpServiceFunction");
        return this.decorator(route, (? super HttpService delegate) -> new FunctionalDecoratingHttpService((HttpService)delegate, decoratingHttpServiceFunction));
    }

    public VirtualHostBuilder decoratorUnder(String prefix, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), decorator);
    }

    public VirtualHostBuilder decoratorUnder(String prefix, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), decoratingHttpServiceFunction);
    }

    public VirtualHostBuilder accessLogger(Function<? super VirtualHost, ? extends Logger> mapper) {
        this.accessLoggerMapper = Objects.requireNonNull(mapper, "mapper");
        return this;
    }

    public VirtualHostBuilder accessLogger(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        return this.accessLogger((? super VirtualHost host) -> logger);
    }

    public VirtualHostBuilder accessLogger(String loggerName) {
        Objects.requireNonNull(loggerName, "loggerName");
        return this.accessLogger((? super VirtualHost host) -> LoggerFactory.getLogger(loggerName));
    }

    public VirtualHostBuilder errorHandler(ServiceErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        return this;
    }

    public VirtualHostBuilder rejectedRouteHandler(RejectedRouteHandler handler) {
        this.rejectedRouteHandler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    public VirtualHostBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.addObject(name, value);
        return this;
    }

    public VirtualHostBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "headers");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.addObject(defaultHeaders);
        return this;
    }

    public VirtualHostBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.setObject(name, value);
        return this;
    }

    public VirtualHostBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "headers");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.setObject(defaultHeaders);
        return this;
    }

    static void ensureNoPseudoHeader(CharSequence name) {
        Preconditions.checkArgument(!Http2Headers.PseudoHeaderName.isPseudoHeader(name), "Can't set a pseudo-header: %s", (Object)name);
    }

    static void ensureNoPseudoHeader(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        for (Map.Entry<CharSequence, ?> header : headers) {
            VirtualHostBuilder.ensureNoPseudoHeader(header.getKey());
        }
    }

    public VirtualHostBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    public VirtualHostBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming);
        return this;
    }

    public VirtualHostBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    public VirtualHostBuilder maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        return this;
    }

    public VirtualHostBuilder verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    public VirtualHostBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter.andThen(accessLogWriter) : accessLogWriter;
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(accessLogWriter));
        }
        return this;
    }

    public VirtualHostBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this.blockingTaskExecutor(BlockingTaskExecutor.of(blockingTaskExecutor), shutdownOnStop);
    }

    public VirtualHostBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(blockingTaskExecutor));
        }
        return this;
    }

    public VirtualHostBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    public VirtualHostBuilder successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    public VirtualHostBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        return this;
    }

    Path multipartUploadsLocation() {
        return this.multipartUploadsLocation;
    }

    public VirtualHostBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.requestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        return this;
    }

    public VirtualHostBuilder annotatedServiceExtensions(Iterable<? extends RequestConverterFunction> requestConverterFunctions, Iterable<? extends ResponseConverterFunction> responseConverterFunctions, Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.annotatedServiceExtensions = new AnnotatedServiceExtensions(ImmutableList.copyOf(requestConverterFunctions), ImmutableList.copyOf(responseConverterFunctions), ImmutableList.copyOf(exceptionHandlerFunctions));
        return this;
    }

    @Nullable
    AnnotatedServiceExtensions annotatedServiceExtensions() {
        return this.annotatedServiceExtensions;
    }

    VirtualHost build(VirtualHostBuilder template, DependencyInjector dependencyInjector, @Nullable UnhandledExceptionsReporter unhandledExceptionsReporter) {
        ServiceErrorHandler defaultErrorHandler;
        RejectedRouteHandler rejectedRouteHandler;
        Objects.requireNonNull(template, "template");
        if (this.defaultHostname == null) {
            this.defaultHostname = this.hostnamePattern != null ? (this.hostnamePattern.startsWith("*.") ? this.hostnamePattern.substring(2) : this.hostnamePattern) : SystemInfo.hostname();
        }
        if (this.hostnamePattern == null) {
            this.hostnamePattern = this.defaultVirtualHost ? "*" : "*." + this.defaultHostname;
        }
        VirtualHost.ensureHostnamePatternMatchesDefaultHostname(this.hostnamePattern, this.defaultHostname);
        ServiceNaming defaultServiceNaming = this.defaultServiceNaming != null ? this.defaultServiceNaming : template.defaultServiceNaming;
        long requestTimeoutMillis = this.requestTimeoutMillis != null ? this.requestTimeoutMillis : template.requestTimeoutMillis;
        long maxRequestLength = this.maxRequestLength != null ? this.maxRequestLength : template.maxRequestLength;
        boolean verboseResponses = this.verboseResponses != null ? this.verboseResponses : template.verboseResponses;
        RejectedRouteHandler rejectedRouteHandler2 = rejectedRouteHandler = this.rejectedRouteHandler != null ? this.rejectedRouteHandler : template.rejectedRouteHandler;
        AccessLogWriter accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter : (template.accessLogWriter != null ? template.accessLogWriter : AccessLogWriter.disabled());
        Function<? super VirtualHost, ? extends Logger> accessLoggerMapper = this.accessLoggerMapper != null ? this.accessLoggerMapper : template.accessLoggerMapper;
        AnnotatedServiceExtensions extensions = this.annotatedServiceExtensions != null ? this.annotatedServiceExtensions : template.annotatedServiceExtensions;
        BlockingTaskExecutor blockingTaskExecutor = this.blockingTaskExecutor != null ? this.blockingTaskExecutor : template.blockingTaskExecutor;
        SuccessFunction successFunction = this.successFunction != null ? this.successFunction : template.successFunction;
        Path multipartUploadsLocation = this.multipartUploadsLocation != null ? this.multipartUploadsLocation : template.multipartUploadsLocation;
        HttpHeaders defaultHeaders = VirtualHostBuilder.mergeDefaultHeaders(template.defaultHeaders, this.defaultHeaders.build());
        Function<? super RoutingContext, ? extends RequestId> requestIdGenerator = this.requestIdGenerator != null ? this.requestIdGenerator : template.requestIdGenerator;
        ServiceErrorHandler serverErrorHandler = this.serverBuilder.errorHandler().asServiceErrorHandler();
        ServiceErrorHandler serviceErrorHandler = defaultErrorHandler = this.errorHandler != null ? this.errorHandler.orElse(serverErrorHandler) : serverErrorHandler;
        assert (defaultServiceNaming != null);
        assert (rejectedRouteHandler != null);
        assert (accessLoggerMapper != null);
        assert (extensions != null);
        assert (blockingTaskExecutor != null);
        assert (successFunction != null);
        assert (multipartUploadsLocation != null);
        assert (requestIdGenerator != null);
        List serviceConfigs = this.getServiceConfigSetters(template).stream().flatMap(cfgSetters -> {
            if (cfgSetters instanceof VirtualHostAnnotatedServiceBindingBuilder) {
                return ((VirtualHostAnnotatedServiceBindingBuilder)cfgSetters).buildServiceConfigBuilder(extensions, dependencyInjector).stream();
            }
            if (cfgSetters instanceof AnnotatedServiceBindingBuilder) {
                return ((AnnotatedServiceBindingBuilder)cfgSetters).buildServiceConfigBuilder(extensions, dependencyInjector).stream();
            }
            if (cfgSetters instanceof ServiceConfigBuilder) {
                return Stream.of((ServiceConfigBuilder)cfgSetters);
            }
            throw new Error("Unexpected service config setters type: " + cfgSetters.getClass().getSimpleName());
        }).map(cfgBuilder -> cfgBuilder.build(defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, successFunction, multipartUploadsLocation, defaultHeaders, requestIdGenerator, defaultErrorHandler, unhandledExceptionsReporter)).collect(ImmutableList.toImmutableList());
        ServiceConfig fallbackServiceConfig = new ServiceConfigBuilder(RouteBuilder.FALLBACK_ROUTE, FallbackService.INSTANCE).build(defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, successFunction, multipartUploadsLocation, defaultHeaders, requestIdGenerator, defaultErrorHandler, unhandledExceptionsReporter);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.shutdownSupports);
        builder.addAll(template.shutdownSupports);
        VirtualHost virtualHost = new VirtualHost(this.defaultHostname, this.hostnamePattern, this.port, this.sslContext(template), serviceConfigs, fallbackServiceConfig, rejectedRouteHandler, accessLoggerMapper, defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, blockingTaskExecutor, multipartUploadsLocation, (List<ShutdownSupport>)((Object)builder.build()), requestIdGenerator);
        Function<? super HttpService, ? extends HttpService> decorator = this.getRouteDecoratingService(template);
        return decorator != null ? virtualHost.decorate(decorator) : virtualHost;
    }

    static HttpHeaders mergeDefaultHeaders(HttpHeadersBuilder lowPriorityHeaders, HttpHeaders highPriorityHeaders) {
        if (lowPriorityHeaders.isEmpty()) {
            return highPriorityHeaders;
        }
        if (highPriorityHeaders.isEmpty()) {
            return lowPriorityHeaders.build();
        }
        HttpHeadersBuilder headersBuilder = highPriorityHeaders.toBuilder();
        for (AsciiString name : lowPriorityHeaders.names()) {
            if (headersBuilder.contains(name)) continue;
            headersBuilder.add((CharSequence)name, lowPriorityHeaders.getAll(name));
        }
        return headersBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private SslContext sslContext(VirtualHostBuilder template) {
        if (this.portBased) {
            return null;
        }
        SslContext sslContext = null;
        boolean releaseSslContextOnFailure = false;
        try {
            boolean tlsAllowUnsafeCiphers = this.tlsAllowUnsafeCiphers != null ? this.tlsAllowUnsafeCiphers : template.tlsAllowUnsafeCiphers;
            boolean sslContextFromThis = false;
            if (this.sslContextBuilderSupplier != null) {
                sslContext = ServerSslContextUtil.buildSslContext(this.sslContextBuilderSupplier, tlsAllowUnsafeCiphers, this.tlsCustomizers);
                sslContextFromThis = true;
                releaseSslContextOnFailure = true;
            } else if (template.sslContextBuilderSupplier != null) {
                sslContext = ServerSslContextUtil.buildSslContext(template.sslContextBuilderSupplier, tlsAllowUnsafeCiphers, template.tlsCustomizers);
                releaseSslContextOnFailure = true;
            }
            if (sslContext == null) {
                List<Consumer<? super SslContextBuilder>> tlsCustomizers;
                boolean tlsSelfSigned;
                if (this.tlsSelfSigned != null) {
                    tlsSelfSigned = this.tlsSelfSigned;
                    tlsCustomizers = this.tlsCustomizers;
                    sslContextFromThis = true;
                } else {
                    tlsSelfSigned = template.tlsSelfSigned;
                    tlsCustomizers = template.tlsCustomizers;
                }
                if (tlsSelfSigned) {
                    SelfSignedCertificate ssc;
                    try {
                        ssc = this.selfSignedCertificate();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("failed to create a self signed certificate", e);
                    }
                    sslContext = ServerSslContextUtil.buildSslContext(() -> SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey()), tlsAllowUnsafeCiphers, tlsCustomizers);
                    releaseSslContextOnFailure = true;
                }
            }
            Preconditions.checkState(sslContextFromThis || this.tlsCustomizers.isEmpty(), "Cannot call tlsCustomizer() without tls() or tlsSelfSigned()");
            if (sslContext != null) {
                ServerSslContextUtil.validateSslContext(sslContext);
                Preconditions.checkState(sslContext.isServer(), "sslContextBuilder built a client SSL context.");
            }
            if (!(releaseSslContextOnFailure = false)) return sslContext;
        }
        catch (Throwable throwable) {
            if (!releaseSslContextOnFailure) throw throwable;
            ReferenceCountUtil.release(sslContext);
            throw throwable;
        }
        ReferenceCountUtil.release(sslContext);
        return sslContext;
    }

    private SelfSignedCertificate selfSignedCertificate() throws CertificateException {
        if (this.selfSignedCertificate == null) {
            this.selfSignedCertificate = new SelfSignedCertificate(this.defaultHostname);
            return this.selfSignedCertificate;
        }
        return this.selfSignedCertificate;
    }

    int port() {
        return this.port;
    }

    boolean defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("defaultHostname", this.defaultHostname).add("hostnamePattern", this.hostnamePattern).add("serviceConfigSetters", this.serviceConfigSetters).add("routeDecoratingServices", this.routeDecoratingServices).add("accessLoggerMapper", this.accessLoggerMapper).add("rejectedRouteHandler", this.rejectedRouteHandler).add("defaultServiceNaming", this.defaultServiceNaming).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("shutdownSupports", this.shutdownSupports).toString();
    }
}

