/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceFactory;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AnnotatedServiceConfigSetters;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.DefaultServiceConfigSetters;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class VirtualHostAnnotatedServiceBindingBuilder
implements AnnotatedServiceConfigSetters {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();
    private final VirtualHostBuilder virtualHostBuilder;
    private final ImmutableList.Builder<ExceptionHandlerFunction> exceptionHandlerFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<RequestConverterFunction> requestConverterFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<ResponseConverterFunction> responseConverterFunctionBuilder = ImmutableList.builder();
    @Nullable
    private String queryDelimiter;
    private boolean useBlockingTaskExecutor;
    private String pathPrefix = "/";
    @Nullable
    private Object service;

    VirtualHostAnnotatedServiceBindingBuilder(VirtualHostBuilder virtualHostBuilder) {
        this.virtualHostBuilder = virtualHostBuilder;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder pathPrefix(String pathPrefix) {
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder exceptionHandlers(ExceptionHandlerFunction ... exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.add(exceptionHandlerFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder exceptionHandlers(Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.addAll(exceptionHandlerFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder responseConverters(ResponseConverterFunction ... responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.add(responseConverterFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder responseConverters(Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.addAll(responseConverterFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestConverters(RequestConverterFunction ... requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.add(requestConverterFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestConverters(Iterable<? extends RequestConverterFunction> requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.addAll(requestConverterFunctions);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder queryDelimiter(String delimiter) {
        this.queryDelimiter = Objects.requireNonNull(delimiter, "delimiter");
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestTimeout(Duration requestTimeout) {
        this.defaultServiceConfigSetters.requestTimeout(requestTimeout);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder accessLogFormat(String accessLogFormat) {
        this.defaultServiceConfigSetters.accessLogFormat(accessLogFormat);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (VirtualHostAnnotatedServiceBindingBuilder)AnnotatedServiceConfigSetters.super.decorator(decoratingHttpServiceFunction);
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator(decorator);
        return this;
    }

    @Override
    @SafeVarargs
    public final VirtualHostAnnotatedServiceBindingBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder blockingTaskExecutor(int numThreads) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(numThreads);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.defaultServiceConfigSetters.requestIdGenerator(requestIdGenerator);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder addHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.addHeader(name, value);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.addHeaders(defaultHeaders);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder setHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.setHeader(name, value);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.setHeaders(defaultHeaders);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder errorHandler(ServiceErrorHandler serviceErrorHandler) {
        this.defaultServiceConfigSetters.errorHandler(serviceErrorHandler);
        return this;
    }

    public VirtualHostBuilder build(Object service) {
        Objects.requireNonNull(service, "service");
        this.service = service;
        this.virtualHostBuilder.addServiceConfigSetters(this);
        return this.virtualHostBuilder;
    }

    List<ServiceConfigBuilder> buildServiceConfigBuilder(AnnotatedServiceExtensions extensions, DependencyInjector dependencyInjector) {
        ImmutableCollection requestConverterFunctions = ((ImmutableList.Builder)this.requestConverterFunctionBuilder.addAll(extensions.requestConverters())).build();
        ImmutableCollection responseConverterFunctions = ((ImmutableList.Builder)this.responseConverterFunctionBuilder.addAll(extensions.responseConverters())).build();
        ImmutableCollection exceptionHandlerFunctions = ((ImmutableList.Builder)this.exceptionHandlerFunctionBuilder.addAll(extensions.exceptionHandlers())).build();
        assert (this.service != null);
        List<AnnotatedServiceElement> elements = AnnotatedServiceFactory.find(this.pathPrefix, this.service, this.useBlockingTaskExecutor, (List<RequestConverterFunction>)((Object)requestConverterFunctions), (List<ResponseConverterFunction>)((Object)responseConverterFunctions), (List<ExceptionHandlerFunction>)((Object)exceptionHandlerFunctions), dependencyInjector, this.queryDelimiter);
        return elements.stream().map(element -> {
            HttpService decoratedService = element.buildSafeDecoratedService(this.defaultServiceConfigSetters.decorator());
            return this.defaultServiceConfigSetters.toServiceConfigBuilder(element.route(), decoratedService);
        }).collect(ImmutableList.toImmutableList());
    }
}

