/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ProtocolViolationException;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.metric.NoopMeterRegistry;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.RequestTargetCache;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.AggregatedHttpResponseHandler;
import com.linecorp.armeria.server.CapturedServiceException;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.HttpHeaderUtil;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpResponseSubscriber;
import com.linecorp.armeria.server.HttpServer;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientService;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpServerHandler
extends ChannelInboundHandlerAdapter
implements HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final MediaType ERROR_CONTENT_TYPE = MediaType.PLAIN_TEXT_UTF_8;
    private static final String ALLOWED_METHODS_STRING = HttpMethod.knownMethods().stream().map(Enum::name).collect(Collectors.joining(","));
    private static final String MSG_INVALID_REQUEST_PATH = HttpStatus.BAD_REQUEST + "\nInvalid request path";
    private static final HttpData DATA_INVALID_REQUEST_PATH = HttpData.ofUtf8(MSG_INVALID_REQUEST_PATH);
    private static final ChannelFutureListener CLOSE = future -> {
        Throwable cause = future.cause();
        Channel ch = future.channel();
        if (cause != null) {
            HttpServerHandler.logException(ch, cause);
        }
        HttpServerHandler.safeClose(ch);
    };
    static final ChannelFutureListener CLOSE_ON_FAILURE = future -> {
        Throwable cause = future.cause();
        if (cause == null) {
            return;
        }
        if (cause instanceof ClosedSessionException) {
            HttpServerHandler.safeClose(future.channel());
            return;
        }
        if (cause instanceof ClosedStreamException) {
            return;
        }
        Channel ch = future.channel();
        HttpServerHandler.logException(ch, cause);
        HttpServerHandler.safeClose(ch);
    };
    private static boolean warnedRequestIdGenerateFailure;
    private static boolean warnedNullRequestId;
    private final ServerConfig config;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private SessionProtocol protocol;
    @Nullable
    private SSLSession sslSession;
    @Nullable
    private ServerHttpObjectEncoder responseEncoder;
    @Nullable
    private final ProxiedAddresses proxiedAddresses;
    private final IdentityHashMap<DecodedHttpRequest, HttpResponse> unfinishedRequests;
    private boolean isReading;
    private boolean isCleaning;
    private boolean handledLastRequest;

    private static void logException(Channel ch, Throwable cause) {
        HttpServer server = HttpServer.get(ch);
        if (server != null) {
            Exceptions.logIfUnexpected(logger, ch, server.protocol(), cause);
        } else {
            Exceptions.logIfUnexpected(logger, ch, cause);
        }
    }

    static void safeClose(Channel ch) {
        if (!ch.isActive()) {
            return;
        }
        AbstractHttp2ConnectionHandler h2handler = ch.pipeline().get(AbstractHttp2ConnectionHandler.class);
        if (h2handler == null || !h2handler.isClosing()) {
            ch.close();
        }
    }

    HttpServerHandler(ServerConfig config, GracefulShutdownSupport gracefulShutdownSupport, @Nullable ServerHttpObjectEncoder responseEncoder, SessionProtocol protocol, @Nullable ProxiedAddresses proxiedAddresses) {
        assert (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C || protocol == SessionProtocol.H2);
        this.config = Objects.requireNonNull(config, "config");
        this.gracefulShutdownSupport = Objects.requireNonNull(gracefulShutdownSupport, "gracefulShutdownSupport");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.responseEncoder = responseEncoder;
        this.proxiedAddresses = proxiedAddresses;
        this.unfinishedRequests = new IdentityHashMap();
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public int unfinishedRequests() {
        return this.unfinishedRequests.size();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.responseEncoder != null) {
            this.responseEncoder.close();
        }
        switch (this.protocol) {
            case H1C: 
            case H1: {
                ctx.channel().eventLoop().schedule(this::cleanup, 1L, TimeUnit.SECONDS);
                break;
            }
            default: {
                this.cleanup();
            }
        }
    }

    private void cleanup() {
        if (!this.unfinishedRequests.isEmpty()) {
            this.isCleaning = true;
            ClosedSessionException cause = ClosedSessionException.get();
            this.unfinishedRequests.forEach((req, res) -> {
                boolean cancel = !this.protocol.isMultiplex();
                req.abortResponse(cause, cancel);
            });
            this.unfinishedRequests.clear();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.isReading = true;
        if (msg instanceof Http2Settings) {
            this.handleHttp2Settings(ctx, (Http2Settings)msg);
        } else {
            this.handleRequest(ctx, (DecodedHttpRequest)msg);
        }
    }

    private void handleHttp2Settings(ChannelHandlerContext ctx, Http2Settings h2settings) {
        if (h2settings.isEmpty()) {
            logger.trace("{} HTTP/2 settings: <empty>", (Object)ctx.channel());
        } else {
            logger.debug("{} HTTP/2 settings: {}", (Object)ctx.channel(), (Object)h2settings);
        }
        if (this.protocol == SessionProtocol.H1) {
            this.protocol = SessionProtocol.H2;
        } else if (this.protocol == SessionProtocol.H1C) {
            this.protocol = SessionProtocol.H2C;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        ChannelHandlerContext connectionHandlerCtx = pipeline.context(Http2ServerConnectionHandler.class);
        Http2ServerConnectionHandler connectionHandler = (Http2ServerConnectionHandler)connectionHandlerCtx.handler();
        if (this.responseEncoder instanceof Http1ObjectEncoder) {
            this.responseEncoder.close();
        }
        this.responseEncoder = connectionHandler.getOrCreateResponseEncoder(connectionHandlerCtx);
        int initialWindow = this.config.http2InitialConnectionWindowSize();
        if (initialWindow > 65535) {
            HttpServerHandler.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = pipeline.get(Http2ServerConnectionHandler.class).connection();
            connection.local().flowController().incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    private void handleRequest(ChannelHandlerContext ctx, DecodedHttpRequest req) throws Exception {
        ServerHttpObjectEncoder responseEncoder = this.responseEncoder;
        assert (responseEncoder != null);
        if (this.handledLastRequest) {
            return;
        }
        if (!req.isKeepAlive()) {
            this.handledLastRequest = true;
            responseEncoder.keepAliveHandler().disconnectWhenFinished();
        }
        Channel channel = ctx.channel();
        RequestHeaders headers = req.headers();
        ProxiedAddresses proxiedAddresses = this.determineProxiedAddresses(channel, headers);
        InetAddress clientAddress = this.config.clientAddressMapper().apply(proxiedAddresses).getAddress();
        RoutingContext routingCtx = req.routingContext();
        RoutingStatus routingStatus = routingCtx.status();
        if (!routingStatus.routeMustExist()) {
            ServiceRequestContext reqCtx = this.newEarlyRespondingRequestContext(channel, req, proxiedAddresses, clientAddress, routingCtx);
            if (routingStatus == RoutingStatus.OPTIONS) {
                this.handleOptions(ctx, reqCtx);
                return;
            }
            throw new Error();
        }
        Routed<ServiceConfig> routed = req.route();
        assert (routed != null);
        RoutingResult routingResult = routed.routingResult();
        ServiceConfig serviceCfg = routed.value();
        HttpService service = serviceCfg.service();
        DefaultServiceRequestContext reqCtx = new DefaultServiceRequestContext(serviceCfg, channel, this.config.meterRegistry(), this.protocol, HttpServerHandler.nextRequestId(routingCtx, serviceCfg), routingCtx, routingResult, req.exchangeType(), req, this.sslSession, proxiedAddresses, clientAddress, req.requestStartTimeNanos(), req.requestStartTimeMicros());
        try (SafeCloseable ignored = reqCtx.push();){
            boolean isTransientService;
            HttpResponse serviceResponse;
            RequestLogBuilder logBuilder = reqCtx.logBuilder();
            try {
                req.init(reqCtx);
                serviceResponse = service.serve((ServiceRequestContext)reqCtx, req);
            }
            catch (Throwable cause2) {
                if (cause2 instanceof HttpResponseException || cause2 instanceof HttpStatusException) {
                    req.abort(ResponseCompleteException.get());
                } else {
                    req.abort(cause2);
                }
                serviceResponse = HttpResponse.ofFailure(cause2);
            }
            HttpResponse res = serviceResponse = serviceResponse.recover(cause -> {
                CapturedServiceException.set(reqCtx, cause);
                return serviceCfg.errorHandler().onServiceException(reqCtx, (Throwable)cause);
            });
            EventLoop eventLoop = channel.eventLoop();
            boolean bl = isTransientService = serviceCfg.service().as(TransientService.class) != null;
            if (!isTransientService) {
                this.gracefulShutdownSupport.inc();
            }
            this.unfinishedRequests.put(req, res);
            if (service.shouldCachePath(routingCtx.path(), routingCtx.query(), routed.route())) {
                reqCtx.log().whenComplete().thenAccept(log -> {
                    int statusCode = log.responseHeaders().status().code();
                    if (statusCode >= 200 && statusCode < 400) {
                        RequestTargetCache.putForServer(req.path(), routingCtx.requestTarget());
                    }
                });
            }
            req.whenComplete().handle((ret, cause) -> {
                try {
                    if (cause == null) {
                        logBuilder.endRequest();
                    } else {
                        logBuilder.endRequest((Throwable)cause);
                    }
                }
                catch (Throwable t) {
                    logger.warn("Unexpected exception:", t);
                }
                return null;
            });
            CompletableFuture<Void> resWriteFuture = new CompletableFuture<Void>();
            resWriteFuture.handle((ret, cause) -> {
                try {
                    boolean needsDisconnection;
                    assert (eventLoop.inEventLoop());
                    if (cause == null || !req.isOpen()) {
                        req.abort(ResponseCompleteException.get());
                    } else {
                        req.abort((Throwable)cause);
                    }
                    if (!isTransientService) {
                        this.gracefulShutdownSupport.dec();
                    }
                    if (!this.isCleaning) {
                        this.unfinishedRequests.remove(req);
                    }
                    boolean bl = needsDisconnection = ctx.channel().isActive() && (this.handledLastRequest || responseEncoder.keepAliveHandler().needsDisconnection());
                    if (needsDisconnection) {
                        if (this.protocol.isMultiplex()) {
                            ctx.channel().close();
                        } else {
                            this.handledLastRequest = true;
                            if (this.unfinishedRequests.isEmpty()) {
                                ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(CLOSE);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    logger.warn("Unexpected exception:", t);
                }
                return null;
            });
            req.setResponse(res);
            if (reqCtx.exchangeType().isResponseStreaming()) {
                HttpResponseSubscriber resSubscriber = new HttpResponseSubscriber(ctx, responseEncoder, reqCtx, req, resWriteFuture);
                res.subscribe(resSubscriber, eventLoop, SubscriptionOption.WITH_POOLED_OBJECTS);
            } else {
                AggregatedHttpResponseHandler resHandler = new AggregatedHttpResponseHandler(ctx, responseEncoder, reqCtx, req, resWriteFuture);
                res.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), eventLoop)).handle((BiFunction)resHandler);
            }
        }
    }

    private ProxiedAddresses determineProxiedAddresses(Channel channel, RequestHeaders headers) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (this.config.clientAddressTrustedProxyFilter().test(remoteAddress.getAddress())) {
            return HttpHeaderUtil.determineProxiedAddresses(headers, this.config.clientAddressSources(), this.proxiedAddresses, remoteAddress, this.config.clientAddressFilter());
        }
        return this.proxiedAddresses != null ? this.proxiedAddresses : ProxiedAddresses.of(remoteAddress);
    }

    private void handleOptions(ChannelHandlerContext ctx, ServiceRequestContext reqCtx) {
        this.respond(ctx, reqCtx, ResponseHeaders.builder(HttpStatus.OK).add((CharSequence)HttpHeaderNames.ALLOW, ALLOWED_METHODS_STRING), HttpData.empty(), null);
    }

    private void rejectInvalidPath(ChannelHandlerContext ctx, ServiceRequestContext reqCtx) {
        this.respond(ctx, reqCtx, HttpStatus.BAD_REQUEST, DATA_INVALID_REQUEST_PATH, (Throwable)new ProtocolViolationException(MSG_INVALID_REQUEST_PATH));
    }

    private void respond(ChannelHandlerContext ctx, ServiceRequestContext reqCtx, HttpStatus status, HttpData resContent, @Nullable Throwable cause) {
        if (status.code() < 400) {
            this.respond(ctx, reqCtx, ResponseHeaders.builder(status), HttpData.empty(), cause);
            return;
        }
        if (reqCtx.method() == HttpMethod.HEAD || status.isContentAlwaysEmpty()) {
            resContent = HttpData.empty();
        } else if (resContent.isEmpty()) {
            resContent = status.toHttpData();
        }
        this.respond(ctx, reqCtx, ResponseHeaders.builder(status).contentType(ERROR_CONTENT_TYPE), resContent, cause);
    }

    private void respond(ChannelHandlerContext ctx, ServiceRequestContext reqCtx, ResponseHeadersBuilder resHeaders, HttpData resContent, @Nullable Throwable cause) {
        if (!this.handledLastRequest) {
            this.respond(reqCtx, resHeaders, resContent, cause).addListener(CLOSE_ON_FAILURE);
        } else {
            this.respond(reqCtx, resHeaders, resContent, cause).addListener(CLOSE);
        }
        if (!this.isReading) {
            ctx.flush();
        }
    }

    private ChannelFuture respond(ServiceRequestContext reqCtx, ResponseHeadersBuilder resHeaders, HttpData resContent, @Nullable Throwable cause) {
        DecodedHttpRequest req = (DecodedHttpRequest)reqCtx.request();
        if (req instanceof HttpRequestWriter) {
            ((HttpRequestWriter)((Object)req)).close();
        }
        RequestLogBuilder logBuilder = reqCtx.logBuilder();
        if (cause == null) {
            logBuilder.endRequest();
        } else {
            logBuilder.endRequest(cause);
        }
        boolean hasContent = !resContent.isEmpty();
        logBuilder.startResponse();
        assert (this.responseEncoder != null);
        if (this.handledLastRequest) {
            this.addConnectionCloseHeaders(resHeaders);
        }
        HttpServerHandler.setContentLength(req, resHeaders, hasContent ? resContent.length() : 0);
        ResponseHeaders immutableResHeaders = resHeaders.build();
        ChannelFuture future = this.responseEncoder.writeHeaders(req.id(), req.streamId(), immutableResHeaders, !hasContent);
        logBuilder.responseHeaders(immutableResHeaders);
        if (hasContent) {
            logBuilder.increaseResponseLength(resContent);
            future = this.responseEncoder.writeData(req.id(), req.streamId(), resContent, true);
        }
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                if (cause == null && f.isSuccess()) {
                    logBuilder.endResponse();
                } else {
                    logBuilder.endResponse(MoreObjects.firstNonNull(cause, f.cause()));
                }
                reqCtx.log().whenComplete().thenAccept(reqCtx.config().accessLogWriter()::log);
            }
        }));
        return future;
    }

    private void addConnectionCloseHeaders(ResponseHeadersBuilder headers) {
        if (this.protocol == SessionProtocol.H1 || this.protocol == SessionProtocol.H1C) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeadersUtil.CLOSE_STRING);
        }
    }

    private static void setContentLength(HttpRequest req, ResponseHeadersBuilder headers, int contentLength) {
        if (req.method() == HttpMethod.HEAD || headers.status().isContentAlwaysEmpty()) {
            return;
        }
        headers.contentLength(contentLength);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isReading = false;
        ctx.flush();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandler sslHandler = ctx.channel().pipeline().get(SslHandler.class);
            this.sslSession = sslHandler != null ? sslHandler.engine().getSession() : null;
            return;
        }
        if (evt instanceof SslCloseCompletionEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)ctx.channel(), evt);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exceptions.logIfUnexpected(logger, ctx.channel(), this.protocol, cause);
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private ServiceRequestContext newEarlyRespondingRequestContext(Channel channel, DecodedHttpRequest req, ProxiedAddresses proxiedAddresses, InetAddress clientAddress, RoutingContext routingCtx) {
        ServiceConfig serviceConfig = routingCtx.virtualHost().fallbackServiceConfig();
        RoutingResult routingResult = RoutingResult.builder().path(routingCtx.path()).build();
        return new DefaultServiceRequestContext(serviceConfig, channel, NoopMeterRegistry.get(), this.protocol(), HttpServerHandler.nextRequestId(routingCtx, serviceConfig), routingCtx, routingResult, req.exchangeType(), req, this.sslSession, proxiedAddresses, clientAddress, System.nanoTime(), SystemInfo.currentTimeMicros());
    }

    private static RequestId nextRequestId(RoutingContext routingCtx, ServiceConfig serviceConfig) {
        try {
            RequestId id = serviceConfig.requestIdGenerator().apply(routingCtx);
            if (id != null) {
                return id;
            }
            if (!warnedNullRequestId) {
                warnedNullRequestId = true;
                logger.warn("requestIdGenerator.apply(routingCtx) returned null; using RequestId.random()");
            }
            return RequestId.random();
        }
        catch (Exception e) {
            if (!warnedRequestIdGenerateFailure) {
                warnedRequestIdGenerateFailure = true;
                logger.warn("requestIdGenerator.apply(routingCtx) threw an exception; using RequestId.random()", e);
            }
            return RequestId.random();
        }
    }
}

