/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.CancellationException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.EmptyHttpResponseException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.AbstractHttpResponseHandler;
import com.linecorp.armeria.server.CapturedServiceException;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpServerHandler;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpResponseSubscriber
extends AbstractHttpResponseHandler
implements Subscriber<HttpObject> {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseSubscriber.class);
    @Nullable
    private Subscription subscription;
    private State state = State.NEEDS_HEADERS;
    private boolean isSubscriptionCompleted;
    private boolean loggedResponseHeadersFirstBytesTransferred;
    @Nullable
    private WriteHeadersFutureListener cachedWriteHeadersListener;
    @Nullable
    private WriteDataFutureListener cachedWriteDataListener;

    HttpResponseSubscriber(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state == State.DONE) {
            if (!this.isSubscriptionCompleted) {
                this.isSubscriptionCompleted = true;
                subscription.cancel();
            }
            return;
        }
        this.scheduleTimeout();
        subscription.request(1L);
    }

    @Override
    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            this.req.abortResponse(new IllegalArgumentException("published an HttpObject that's neither HttpHeaders nor HttpData: " + o + " (service: " + this.service() + ')'), true);
            return;
        }
        if (this.failIfStreamOrSessionClosed()) {
            PooledObjects.close(o);
            this.setDone(true);
            return;
        }
        boolean endOfStream = o.isEndOfStream();
        switch (this.state) {
            case NEEDS_HEADERS: {
                ResponseHeaders merged;
                this.logBuilder().startResponse();
                if (!(o instanceof ResponseHeaders)) {
                    this.req.abortResponse(new IllegalStateException("published an HttpData without a preceding ResponseHeaders: " + o + " (service: " + this.service() + ')'), true);
                    return;
                }
                ResponseHeaders headers = (ResponseHeaders)o;
                HttpStatus status = headers.status();
                if (status.isInformational()) {
                    if (endOfStream) {
                        this.req.abortResponse(new IllegalStateException("published an informational headers whose endOfStream is true: " + o + " (service: " + this.service() + ')'), true);
                        return;
                    }
                    merged = headers;
                } else {
                    if (this.responseEncoder.isResponseHeadersSent(this.req.id(), this.req.streamId())) {
                        this.tryComplete(new CancelledSubscriptionException("An HTTP response was sent already. ctx: " + this.reqCtx));
                        this.setDone(true);
                        return;
                    }
                    if (this.req.method() == HttpMethod.HEAD) {
                        endOfStream = true;
                    } else {
                        this.state = status.isContentAlwaysEmpty() ? State.NEEDS_TRAILERS : State.NEEDS_DATA_OR_TRAILERS;
                    }
                    if (endOfStream) {
                        this.setDone(true);
                    }
                    ServerConfig config = this.reqCtx.config().server().config();
                    merged = HttpHeadersUtil.mergeResponseHeaders(headers, this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
                    String connectionOption = merged.get(HttpHeaderNames.CONNECTION);
                    if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption)) {
                        this.disconnectWhenFinished();
                    }
                    this.logBuilder().responseHeaders(merged);
                }
                this.responseEncoder.writeHeaders(this.req.id(), this.req.streamId(), merged, endOfStream, this.reqCtx.additionalResponseTrailers().isEmpty()).addListener(this.writeHeadersFutureListener(endOfStream));
                break;
            }
            case NEEDS_TRAILERS: {
                if (o instanceof ResponseHeaders) {
                    this.req.abortResponse(new IllegalStateException("published a ResponseHeaders: " + o + " (expected: an HTTP trailers). service: " + this.service()), true);
                    return;
                }
                if (o instanceof HttpData) {
                    ((HttpData)o).close();
                    assert (this.subscription != null);
                    this.subscription.request(1L);
                    return;
                }
            }
            case NEEDS_DATA_OR_TRAILERS: {
                if (o instanceof HttpHeaders) {
                    HttpHeaders trailers = (HttpHeaders)o;
                    if (trailers.contains(HttpHeaderNames.STATUS)) {
                        this.req.abortResponse(new IllegalArgumentException("published an HTTP trailers with status: " + o + " (service: " + this.service() + ')'), true);
                        return;
                    }
                    this.setDone(false);
                    HttpHeaders merged = HttpHeadersUtil.mergeTrailers(trailers, this.reqCtx.additionalResponseTrailers());
                    this.logBuilder().responseTrailers(merged);
                    this.responseEncoder.writeTrailers(this.req.id(), this.req.streamId(), merged).addListener(this.writeHeadersFutureListener(true));
                    break;
                }
                HttpData data = (HttpData)o;
                data.touch(this.reqCtx);
                boolean wroteEmptyData = data.isEmpty();
                this.logBuilder().increaseResponseLength(data);
                if (endOfStream) {
                    this.setDone(false);
                }
                HttpHeaders additionalTrailers = this.reqCtx.additionalResponseTrailers();
                if (endOfStream && !additionalTrailers.isEmpty()) {
                    this.responseEncoder.writeData(this.req.id(), this.req.streamId(), data, false).addListener(this.writeDataFutureListener(false, wroteEmptyData));
                    this.logBuilder().responseTrailers(additionalTrailers);
                    this.responseEncoder.writeTrailers(this.req.id(), this.req.streamId(), additionalTrailers).addListener(this.writeHeadersFutureListener(true));
                    break;
                }
                this.responseEncoder.writeData(this.req.id(), this.req.streamId(), data, endOfStream).addListener(this.writeDataFutureListener(endOfStream, wroteEmptyData));
                break;
            }
            case DONE: {
                this.isSubscriptionCompleted = true;
                this.subscription.cancel();
                PooledObjects.close(o);
                return;
            }
        }
        this.ctx.flush();
    }

    @Override
    boolean isDone() {
        return this.state == State.DONE;
    }

    private State setDone(boolean cancel) {
        if (cancel && this.subscription != null && !this.isSubscriptionCompleted) {
            this.isSubscriptionCompleted = true;
            this.subscription.cancel();
        }
        this.clearTimeout();
        State oldState = this.state;
        this.state = State.DONE;
        return oldState;
    }

    @Override
    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        Throwable peeled = Exceptions.peel(cause);
        if (!this.isWritable()) {
            this.fail(peeled);
            return;
        }
        if (peeled instanceof HttpResponseException) {
            this.toAggregatedHttpResponse((HttpResponseException)peeled).handleAsync((res, throwable) -> {
                if (throwable != null) {
                    this.failAndRespond((Throwable)throwable, internalServerErrorResponse, Http2Error.CANCEL, false);
                } else {
                    this.failAndRespond(peeled, (AggregatedHttpResponse)res, Http2Error.CANCEL, false);
                }
                return null;
            }, (Executor)this.ctx.executor());
        } else if (peeled instanceof HttpStatusException) {
            Throwable cause0 = MoreObjects.firstNonNull(peeled.getCause(), peeled);
            AggregatedHttpResponse res2 = this.toAggregatedHttpResponse((HttpStatusException)peeled);
            this.failAndRespond(cause0, res2, Http2Error.CANCEL, false);
        } else if (Exceptions.isStreamCancelling(peeled)) {
            this.failAndReset(peeled);
        } else {
            if (!(peeled instanceof CancellationException)) {
                logger.warn("{} Unexpected exception from a service or a response publisher: {}", this.ctx.channel(), this.service(), peeled);
            }
            this.failAndRespond(peeled, internalServerErrorResponse, Http2Error.INTERNAL_ERROR, false);
        }
    }

    @Override
    public void onComplete() {
        this.isSubscriptionCompleted = true;
        State oldState = this.setDone(false);
        if (oldState == State.NEEDS_HEADERS) {
            this.responseEncoder.writeReset(this.req.id(), this.req.streamId(), Http2Error.INTERNAL_ERROR).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                try (SafeCloseable ignored = RequestContextUtil.pop();){
                    this.fail(EmptyHttpResponseException.get());
                }
            }));
            this.ctx.flush();
            return;
        }
        if (oldState != State.DONE) {
            HttpHeaders additionalTrailers = this.reqCtx.additionalResponseTrailers();
            if (!additionalTrailers.isEmpty()) {
                this.logBuilder().responseTrailers(additionalTrailers);
                this.responseEncoder.writeTrailers(this.req.id(), this.req.streamId(), additionalTrailers).addListener(this.writeHeadersFutureListener(true));
                this.ctx.flush();
            } else if (this.isWritable()) {
                this.responseEncoder.writeData(this.req.id(), this.req.streamId(), HttpData.empty(), true).addListener(this.writeDataFutureListener(true, true));
                this.ctx.flush();
            } else if (!this.reqCtx.sessionProtocol().isMultiplex()) {
                this.succeed();
            } else {
                this.fail(ClosedStreamException.get());
            }
        }
    }

    private void succeed() {
        if (this.tryComplete(null)) {
            Throwable capturedException = CapturedServiceException.get(this.reqCtx);
            if (capturedException != null) {
                this.endLogRequestAndResponse(capturedException);
            } else {
                this.endLogRequestAndResponse();
            }
            this.maybeWriteAccessLog();
        }
    }

    @Override
    void fail(Throwable cause) {
        if (this.tryComplete(cause)) {
            this.setDone(true);
            this.endLogRequestAndResponse(cause);
            this.maybeWriteAccessLog();
        }
    }

    private void failAndRespond(Throwable cause, AggregatedHttpResponse res, Http2Error error, boolean cancel) {
        boolean isReset;
        ChannelFuture future;
        State oldState = this.setDone(cancel);
        int id = this.req.id();
        int streamId = this.req.streamId();
        if (oldState == State.NEEDS_HEADERS) {
            future = this.writeAggregatedHttpResponse(res);
            isReset = false;
        } else {
            future = this.responseEncoder.writeReset(id, streamId, error);
            isReset = true;
        }
        this.addCallbackAndFlush(cause, oldState, future, isReset);
    }

    private void failAndReset(Throwable cause) {
        State oldState = this.setDone(false);
        ChannelFuture future = this.responseEncoder.writeReset(this.req.id(), this.req.streamId(), Http2Error.CANCEL);
        this.addCallbackAndFlush(cause, oldState, future, true);
    }

    private void addCallbackAndFlush(Throwable cause, State oldState, ChannelFuture future, boolean isReset) {
        if (oldState != State.DONE) {
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                try (SafeCloseable ignored = RequestContextUtil.pop();){
                    if (f.isSuccess() && !isReset) {
                        this.maybeLogFirstResponseBytesTransferred();
                    }
                    this.fail(cause);
                }
            }));
        }
        this.ctx.flush();
    }

    private WriteHeadersFutureListener writeHeadersFutureListener(boolean endOfStream) {
        if (!endOfStream) {
            if (this.cachedWriteHeadersListener == null) {
                this.cachedWriteHeadersListener = new WriteHeadersFutureListener(false);
            }
            return this.cachedWriteHeadersListener;
        }
        return new WriteHeadersFutureListener(true);
    }

    private WriteDataFutureListener writeDataFutureListener(boolean endOfStream, boolean wroteEmptyData) {
        if (!endOfStream && !wroteEmptyData) {
            if (this.cachedWriteDataListener == null) {
                this.cachedWriteDataListener = new WriteDataFutureListener(false, false);
            }
            return this.cachedWriteDataListener;
        }
        return new WriteDataFutureListener(endOfStream, wroteEmptyData);
    }

    void handleWriteComplete(ChannelFuture future, boolean endOfStream, boolean isSuccess) throws Exception {
        if (isSuccess) {
            this.maybeLogFirstResponseBytesTransferred();
            if (endOfStream) {
                this.succeed();
            }
            if (!this.isSubscriptionCompleted) {
                assert (this.subscription != null);
                this.subscription.request(1L);
            }
            return;
        }
        this.fail(future.cause());
        HttpServerHandler.CLOSE_ON_FAILURE.operationComplete(future);
    }

    private void maybeLogFirstResponseBytesTransferred() {
        if (!this.loggedResponseHeadersFirstBytesTransferred) {
            this.loggedResponseHeadersFirstBytesTransferred = true;
            this.logBuilder().responseFirstBytesTransferred();
        }
    }

    static enum State {
        NEEDS_HEADERS,
        NEEDS_DATA_OR_TRAILERS,
        NEEDS_TRAILERS,
        DONE;

    }

    private class WriteHeadersFutureListener
    implements ChannelFutureListener {
        private final boolean endOfStream;

        WriteHeadersFutureListener(boolean endOfStream) {
            this.endOfStream = endOfStream;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                HttpResponseSubscriber.this.handleWriteComplete(future, this.endOfStream, future.isSuccess());
            }
        }
    }

    private class WriteDataFutureListener
    implements ChannelFutureListener {
        private final boolean endOfStream;
        private final boolean wroteEmptyData;

        WriteDataFutureListener(boolean endOfStream, boolean wroteEmptyData) {
            this.endOfStream = endOfStream;
            this.wroteEmptyData = wroteEmptyData;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                boolean isSuccess;
                if (future.isSuccess()) {
                    isSuccess = true;
                } else {
                    Throwable cause = future.cause();
                    isSuccess = this.endOfStream && this.wroteEmptyData && HttpResponseSubscriber.this.responseEncoder instanceof Http1ObjectEncoder && (cause instanceof ClosedChannelException || cause instanceof ClosedSessionException);
                }
                HttpResponseSubscriber.this.handleWriteComplete(future, this.endOfStream, isSuccess);
            }
        }
    }
}

