/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.UnhandledExceptionsReporter;

final class ExceptionReportingServiceErrorHandler
implements ServiceErrorHandler {
    private final ServiceErrorHandler delegate;
    private final UnhandledExceptionsReporter reporter;

    ExceptionReportingServiceErrorHandler(ServiceErrorHandler delegate, UnhandledExceptionsReporter reporter) {
        this.delegate = delegate;
        this.reporter = reporter;
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        if (ctx.shouldReportUnhandledExceptions() && !ExceptionReportingServiceErrorHandler.isIgnorableException(cause)) {
            this.reporter.report(cause);
        }
        return this.delegate.onServiceException(ctx, cause);
    }

    private static boolean isIgnorableException(Throwable cause) {
        return (cause instanceof HttpStatusException || cause instanceof HttpResponseException) && cause.getCause() == null;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.delegate.renderStatus(config, headers, status, description, cause);
    }
}

