/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.math.ec;

import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.AbstractECMultiplier;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECAlgorithms;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.endo.ECEndomorphism;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.endo.EndoUtil;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve eCCurve, GLVEndomorphism gLVEndomorphism) {
        if (eCCurve == null || eCCurve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = eCCurve;
        this.glvEndomorphism = gLVEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger2 = eCPoint.getCurve().getOrder();
        BigInteger[] bigIntegerArray = this.glvEndomorphism.decomposeScalar(bigInteger.mod(bigInteger2));
        BigInteger bigInteger3 = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf((ECEndomorphism)this.glvEndomorphism, (ECPoint)eCPoint, (BigInteger)bigInteger3, (BigInteger)bigInteger4);
        }
        ECPoint eCPoint2 = EndoUtil.mapPoint((ECEndomorphism)this.glvEndomorphism, (ECPoint)eCPoint);
        return ECAlgorithms.implShamirsTrickWNaf((ECPoint)eCPoint, (BigInteger)bigInteger3, (ECPoint)eCPoint2, (BigInteger)bigInteger4);
    }
}

