/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);
    private static final Set<Class<? extends Annotation>> knownCyclicAnnotationTypes = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    @Nullable
    public static <T extends Annotation> T findFirst(AnnotatedElement element, Class<T> annotationType) {
        List<T> found = AnnotationUtil.findAll(element, annotationType);
        return (T)(found.isEmpty() ? null : (Annotation)found.get(0));
    }

    @Nullable
    static <T extends Annotation> T findFirstDeclared(AnnotatedElement element, Class<T> annotationType) {
        List<T> found = AnnotationUtil.findDeclared(element, annotationType);
        return (T)(found.isEmpty() ? null : (Annotation)found.get(0));
    }

    static <T extends Annotation> List<T> findAll(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES, FindOption.LOOKUP_META_ANNOTATIONS));
    }

    static <T extends Annotation> List<T> findInherited(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES));
    }

    static <T extends Annotation> List<T> findDeclared(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.noneOf(FindOption.class));
    }

    static <T extends Annotation> List<T> find(AnnotatedElement element, Class<T> annotationType, FindOption ... findOptions) {
        return AnnotationUtil.find(element, annotationType, EnumSet.copyOf(ImmutableList.copyOf(Objects.requireNonNull(findOptions, "findOptions"))));
    }

    static <T extends Annotation> List<T> find(AnnotatedElement element, Class<T> annotationType, EnumSet<FindOption> findOptions) {
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(annotationType, "annotationType");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Repeatable[] repeatableAnnotations = (Repeatable[])annotationType.getAnnotationsByType(Repeatable.class);
        Class<? extends Annotation> containerType = repeatableAnnotations.length > 0 ? repeatableAnnotations[0].value() : null;
        for (AnnotatedElement e : AnnotationUtil.resolveTargetElements(element, findOptions)) {
            for (Annotation annotation : e.getDeclaredAnnotations()) {
                if (findOptions.contains((Object)FindOption.LOOKUP_META_ANNOTATIONS)) {
                    AnnotationUtil.findMetaAnnotations(builder, annotation, annotationType, containerType);
                }
                AnnotationUtil.collectAnnotations(builder, annotation, annotationType, containerType);
            }
        }
        return builder.build();
    }

    private static <T extends Annotation> void findMetaAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType) {
        AnnotationUtil.findMetaAnnotations(builder, annotation, annotationType, containerType, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static <T extends Annotation> boolean findMetaAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        Annotation[] metaAnnotations;
        Class<? extends Annotation> actualAnnotationType = annotation.annotationType();
        if (knownCyclicAnnotationTypes.contains(actualAnnotationType)) {
            return false;
        }
        if (!visitedAnnotationTypes.add(actualAnnotationType)) {
            AnnotationUtil.disallowedListAnnotation(actualAnnotationType);
            return false;
        }
        for (Annotation metaAnnotation : metaAnnotations = annotation.annotationType().getDeclaredAnnotations()) {
            if (!AnnotationUtil.findMetaAnnotations(builder, metaAnnotation, annotationType, containerType, visitedAnnotationTypes)) continue;
            AnnotationUtil.collectAnnotations(builder, metaAnnotation, annotationType, containerType);
        }
        visitedAnnotationTypes.remove(actualAnnotationType);
        return true;
    }

    static List<Annotation> getAllAnnotations(AnnotatedElement element) {
        return AnnotationUtil.getAnnotations(element, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES, FindOption.LOOKUP_META_ANNOTATIONS));
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, FindOption ... findOptions) {
        Objects.requireNonNull(findOptions, "findOptions");
        return AnnotationUtil.getAnnotations(element, findOptions.length > 0 ? EnumSet.copyOf(ImmutableList.copyOf(findOptions)) : EnumSet.noneOf(FindOption.class));
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, EnumSet<FindOption> findOptions) {
        return AnnotationUtil.getAnnotations(element, findOptions, (Annotation annotation) -> true);
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, EnumSet<FindOption> findOptions, Predicate<Annotation> collectingFilter) {
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(collectingFilter, "collectingFilter");
        ImmutableList.Builder<Annotation> builder = new ImmutableList.Builder<Annotation>();
        for (AnnotatedElement e : AnnotationUtil.resolveTargetElements(element, findOptions)) {
            for (Annotation annotation : e.getDeclaredAnnotations()) {
                if (findOptions.contains((Object)FindOption.LOOKUP_META_ANNOTATIONS)) {
                    AnnotationUtil.getMetaAnnotations(builder, annotation, collectingFilter);
                }
                if (!collectingFilter.test(annotation)) continue;
                builder.add((Object)annotation);
            }
        }
        return builder.build();
    }

    private static void getMetaAnnotations(ImmutableList.Builder<Annotation> builder, Annotation annotation, Predicate<Annotation> collectingFilter) {
        AnnotationUtil.getMetaAnnotations(builder, annotation, collectingFilter, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static boolean getMetaAnnotations(ImmutableList.Builder<Annotation> builder, Annotation annotation, Predicate<Annotation> collectingFilter, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        Annotation[] metaAnnotations;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (knownCyclicAnnotationTypes.contains(annotationType)) {
            return false;
        }
        if (!visitedAnnotationTypes.add(annotationType)) {
            AnnotationUtil.disallowedListAnnotation(annotationType);
            return false;
        }
        for (Annotation metaAnnotation : metaAnnotations = annotationType.getDeclaredAnnotations()) {
            if (!AnnotationUtil.getMetaAnnotations(builder, metaAnnotation, collectingFilter, visitedAnnotationTypes) || !collectingFilter.test(metaAnnotation)) continue;
            builder.add((Object)metaAnnotation);
        }
        visitedAnnotationTypes.remove(annotationType);
        return true;
    }

    private static void disallowedListAnnotation(Class<? extends Annotation> annotationType) {
        if (!knownCyclicAnnotationTypes.add(annotationType)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            String typeName = annotationType.getName();
            Class<?>[] ifaces = annotationType.getInterfaces();
            List ifaceNames = ifaces.length != 0 ? (List)Arrays.stream(ifaces).filter(Class::isAnnotation).map(Class::getName).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
            if (ifaceNames.isEmpty()) {
                logger.debug("Disallowed listing an annotation with a cyclic reference: {}", (Object)typeName);
            } else {
                logger.debug("Disallowed listing an annotation with a cyclic reference: {}{}", (Object)typeName, (Object)ifaceNames);
            }
        }
    }

    private static List<AnnotatedElement> resolveTargetElements(AnnotatedElement element, EnumSet<FindOption> findOptions) {
        ImmutableCollection elements;
        if (findOptions.contains((Object)FindOption.LOOKUP_SUPER_CLASSES) && element instanceof Class) {
            Class superclass = ((Class)element).getSuperclass();
            if ((superclass == null || superclass == Object.class) && ((Class)element).getInterfaces().length == 0) {
                elements = ImmutableList.of(element);
            } else {
                ImmutableList.Builder<AnnotatedElement> collector = new ImmutableList.Builder<AnnotatedElement>();
                AnnotationUtil.collectSuperClasses((Class)element, collector, findOptions.contains((Object)FindOption.COLLECT_SUPER_CLASSES_FIRST));
                elements = collector.build();
            }
        } else {
            elements = ImmutableList.of(element);
        }
        return elements;
    }

    private static void collectSuperClasses(Class<?> clazz, ImmutableList.Builder<AnnotatedElement> collector, boolean collectSuperClassesFirst) {
        Class<?> superClass = clazz.getSuperclass();
        Class<?>[] superInterfaces = clazz.getInterfaces();
        if (!collectSuperClassesFirst) {
            collector.add((Object)clazz);
        }
        if (superInterfaces.length > 0) {
            Arrays.stream(superInterfaces).forEach(superInterface -> AnnotationUtil.collectSuperClasses(superInterface, collector, collectSuperClassesFirst));
        }
        if (superClass != null && superClass != Object.class) {
            AnnotationUtil.collectSuperClasses(superClass, collector, collectSuperClassesFirst);
        }
        if (collectSuperClassesFirst) {
            collector.add((Object)clazz);
        }
    }

    private static <T extends Annotation> void collectAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType) {
        Class<? extends Annotation> type = annotation.annotationType();
        if (type == annotationType) {
            builder.add((Annotation)annotationType.cast(annotation));
            return;
        }
        if (containerType == null || type != containerType) {
            return;
        }
        Method method = Iterables.getFirst(ReflectionUtils.getMethods(containerType, ReflectionUtils.withName("value"), ReflectionUtils.withParametersCount(0)), null);
        if (method == null) {
            return;
        }
        method.setAccessible(true);
        try {
            Annotation[] values = (Annotation[])method.invoke((Object)annotation, new Object[0]);
            Arrays.stream(values).forEach(builder::add);
        }
        catch (Exception e) {
            throw new Error("Failed to invoke 'value' method of the repeatable annotation: " + containerType.getName(), e);
        }
    }

    private AnnotationUtil() {
    }

    static {
        knownCyclicAnnotationTypes.add(Documented.class);
        knownCyclicAnnotationTypes.add(Retention.class);
        knownCyclicAnnotationTypes.add(Target.class);
    }

    static enum FindOption {
        LOOKUP_SUPER_CLASSES,
        LOOKUP_META_ANNOTATIONS,
        COLLECT_SUPER_CLASSES_FIRST;

    }
}

