/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.multipart.Multipart;
import com.linecorp.armeria.common.multipart.MultipartFile;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public final class FileAggregatedMultipart {
    private final ListMultimap<String, String> params;
    private final ListMultimap<String, MultipartFile> files;

    private FileAggregatedMultipart(ListMultimap<String, String> params, ListMultimap<String, MultipartFile> files) {
        this.params = params;
        this.files = files;
    }

    public ListMultimap<String, String> params() {
        return this.params;
    }

    public ListMultimap<String, MultipartFile> files() {
        return this.files;
    }

    public static CompletableFuture<FileAggregatedMultipart> aggregateMultipart(ServiceRequestContext ctx, HttpRequest req) {
        Path destination = ctx.config().multipartUploadsLocation();
        return Multipart.from(req).collect(bodyPart -> {
            String name = bodyPart.name();
            assert (name != null);
            String filename = bodyPart.filename();
            ContextAwareEventLoop eventLoop = ctx.eventLoop();
            if (filename != null) {
                Path incompleteDir = destination.resolve("incomplete");
                BlockingTaskExecutor executor = ctx.blockingTaskExecutor().withoutContext();
                return FileAggregatedMultipart.resolveTmpFile(incompleteDir, filename, executor).thenCompose(path -> ((CompletableFuture)bodyPart.writeTo((Path)path, eventLoop, executor, new OpenOption[0]).thenCompose(ignore -> {
                    Path completeDir = destination.resolve("complete");
                    return FileAggregatedMultipart.moveFile(path, completeDir, executor);
                })).thenApply(completePath -> MultipartFile.of(name, filename, completePath.toFile())));
            }
            return bodyPart.aggregateWithPooledObjects(eventLoop, ctx.alloc()).thenApply(aggregatedBodyPart -> {
                try (HttpData httpData = aggregatedBodyPart.content();){
                    Map.Entry<String, String> entry = Maps.immutableEntry(name, httpData.toStringUtf8());
                    return entry;
                }
            });
        }).thenApply(results -> {
            ImmutableListMultimap.Builder params = ImmutableListMultimap.builder();
            ImmutableListMultimap.Builder files = ImmutableListMultimap.builder();
            for (Object result : results) {
                if (result instanceof MultipartFile) {
                    MultipartFile multipartFile = (MultipartFile)result;
                    files.put(multipartFile.name(), multipartFile);
                    continue;
                }
                Map.Entry entry = (Map.Entry)result;
                params.put((String)entry.getKey(), (String)entry.getValue());
            }
            return new FileAggregatedMultipart((ListMultimap<String, String>)((Object)params.build()), (ListMultimap<String, MultipartFile>)((Object)files.build()));
        });
    }

    private static CompletableFuture<Path> moveFile(Path file, Path targetDirectory, ExecutorService blockingExecutorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.createDirectories(targetDirectory, new FileAttribute[0]);
                return Files.move(file, Files.createTempFile(targetDirectory, null, ".multipart", new FileAttribute[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, blockingExecutorService);
    }

    private static CompletableFuture<Path> resolveTmpFile(Path directory, String filename, ExecutorService blockingExecutorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                return Files.createTempFile(directory, null, '-' + filename, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, blockingExecutorService);
    }
}

