/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientServiceOption;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class LoggingDecorators {
    private static final String REQUEST_FORMAT = "{} Request: {}";
    private static final String RESPONSE_FORMAT = "{} Response: {}";
    private static final String RESPONSE_FORMAT2 = "{} Response: {}, cause: {}";

    public static void log(Logger logger, RequestContext ctx, RequestLog requestLog, Consumer<RequestOnlyLog> requestLogger, Consumer<RequestLog> responseLogger) {
        try {
            requestLogger.accept(requestLog);
        }
        catch (Throwable t) {
            LoggingDecorators.logException(logger, ctx, "request", t);
        }
        try {
            responseLogger.accept(requestLog);
        }
        catch (Throwable t) {
            LoggingDecorators.logException(logger, ctx, "response", t);
        }
    }

    public static void logRequest(Logger logger, RequestOnlyLog log, RequestLogLevelMapper requestLogLevelMapper, BiFunction<? super RequestContext, ? super RequestHeaders, ? extends @Nullable Object> requestHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer) {
        LogLevel requestLogLevel = requestLogLevelMapper.apply(log);
        assert (requestLogLevel != null);
        if (requestLogLevel.isEnabled(logger)) {
            RequestContext ctx = log.context();
            if (log.requestCause() == null && LoggingDecorators.isTransientService(ctx)) {
                return;
            }
            String requestStr = log.toStringRequestOnly(requestHeadersSanitizer, requestContentSanitizer, requestTrailersSanitizer);
            try (SafeCloseable ignored = ctx.push();){
                requestLogLevel.log(logger, REQUEST_FORMAT, (Object)ctx, (Object)requestStr);
            }
        }
    }

    public static void logResponse(Logger logger, RequestLog log, RequestLogLevelMapper requestLogLevelMapper, ResponseLogLevelMapper responseLogLevelMapper, BiFunction<? super RequestContext, ? super RequestHeaders, ? extends @Nullable Object> requestHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super ResponseHeaders, ? extends @Nullable Object> responseHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer, BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer) {
        LogLevel responseLogLevel = responseLogLevelMapper.apply(log);
        assert (responseLogLevel != null);
        Throwable responseCause = log.responseCause();
        if (responseLogLevel.isEnabled(logger)) {
            RequestContext ctx = log.context();
            if (responseCause == null && !log.responseHeaders().status().isServerError() && LoggingDecorators.isTransientService(ctx)) {
                return;
            }
            String responseStr = log.toStringResponseOnly(responseHeadersSanitizer, responseContentSanitizer, responseTrailersSanitizer);
            try (SafeCloseable ignored = ctx.push();){
                Object sanitizedResponseCause;
                if (responseCause == null) {
                    responseLogLevel.log(logger, RESPONSE_FORMAT, (Object)ctx, (Object)responseStr);
                    return;
                }
                LogLevel requestLogLevel = requestLogLevelMapper.apply(log);
                assert (requestLogLevel != null);
                if (!requestLogLevel.isEnabled(logger)) {
                    responseLogLevel.log(logger, REQUEST_FORMAT, (Object)ctx, (Object)log.toStringRequestOnly(requestHeadersSanitizer, requestContentSanitizer, requestTrailersSanitizer));
                }
                if ((sanitizedResponseCause = responseCauseSanitizer.apply(ctx, responseCause)) == null) {
                    responseLogLevel.log(logger, RESPONSE_FORMAT, (Object)ctx, (Object)responseStr);
                    return;
                }
                if (sanitizedResponseCause instanceof Throwable) {
                    responseLogLevel.log(logger, RESPONSE_FORMAT, (Object)ctx, (Object)responseStr, sanitizedResponseCause);
                } else {
                    responseLogLevel.log(logger, RESPONSE_FORMAT2, (Object)ctx, (Object)responseStr, sanitizedResponseCause);
                }
            }
        }
    }

    private LoggingDecorators() {
    }

    private static void logException(Logger logger, RequestContext ctx, String requestOrResponse, Throwable cause) {
        try (SafeCloseable ignored = ctx.push();){
            logger.warn("{} Unexpected exception while logging {}: ", ctx, requestOrResponse, cause);
        }
    }

    private static boolean isTransientService(RequestContext ctx) {
        return ctx instanceof ServiceRequestContext && !((ServiceRequestContext)ctx).config().transientServiceOptions().contains((Object)TransientServiceOption.WITH_SERVICE_LOGGING);
    }
}

