/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.AggregatedHttpObject;
import com.linecorp.armeria.common.Bytes;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class HttpObjectAggregator<T extends AggregatedHttpObject>
implements Subscriber<HttpObject> {
    private final CompletableFuture<T> future;
    private final List<HttpData> contentList = new ArrayList<HttpData>();
    @Nullable
    private final ByteBufAllocator alloc;
    private int contentLength;
    @Nullable
    private Subscription subscription;

    protected HttpObjectAggregator(CompletableFuture<T> future, @Nullable ByteBufAllocator alloc) {
        this.future = future;
        this.alloc = alloc;
    }

    @Override
    public final void onSubscribe(Subscription s) {
        this.subscription = s;
        s.request(Long.MAX_VALUE);
    }

    @Override
    public final void onError(Throwable t) {
        this.fail(t);
    }

    @Override
    public final void onComplete() {
        HttpData content;
        if (this.future.isDone()) {
            return;
        }
        if (this.contentLength == 0) {
            content = HttpData.empty();
        } else {
            Object merged;
            if (this.alloc != null) {
                merged = this.alloc.buffer(this.contentLength);
                for (int i = 0; i < this.contentList.size(); ++i) {
                    try (HttpData data = this.contentList.set(i, null);){
                        ByteBuf buf = data.byteBuf();
                        ((ByteBuf)merged).writeBytes(buf, buf.readerIndex(), data.length());
                        continue;
                    }
                }
                content = HttpData.wrap((ByteBuf)merged);
            } else {
                merged = new byte[this.contentLength];
                int offset = 0;
                for (int i = 0; i < this.contentList.size(); ++i) {
                    HttpData data = this.contentList.set(i, null);
                    int dataLength = data.length();
                    System.arraycopy(data.array(), 0, merged, offset, dataLength);
                    offset += dataLength;
                }
                content = HttpData.wrap((byte[])merged);
            }
            this.contentList.clear();
        }
        try {
            this.future.complete(this.onSuccess(content));
        }
        catch (Throwable e) {
            this.future.completeExceptionally(e);
        }
    }

    @Override
    public final void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            this.onHeaders((HttpHeaders)o);
        } else {
            this.onData((HttpData)o);
        }
    }

    protected abstract void onHeaders(HttpHeaders var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onData(HttpData data) {
        boolean added = false;
        try {
            if (this.future.isDone()) {
                return;
            }
            int dataLength = data.length();
            if (dataLength > 0) {
                int allowedMaxDataLength = Integer.MAX_VALUE - this.contentLength;
                if (dataLength > allowedMaxDataLength) {
                    this.subscription.cancel();
                    this.fail(new IllegalStateException("content length greater than Integer.MAX_VALUE"));
                    return;
                }
                this.contentList.add(data);
                this.contentLength += dataLength;
                added = true;
            }
        }
        finally {
            if (!added) {
                data.close();
            }
        }
    }

    private void fail(Throwable cause) {
        this.contentList.forEach(Bytes::close);
        this.contentList.clear();
        this.onFailure();
        this.future.completeExceptionally(cause);
    }

    protected abstract T onSuccess(HttpData var1);

    protected abstract void onFailure();
}

