/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.RequestTargetForm;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.RequestTargetCache;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteArrays;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.BitSet;
import java.util.Objects;

public final class DefaultRequestTarget
implements RequestTarget {
    private static final String ALLOWED_COMMON_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?@!$&'()*,;=";
    private static final BitSet PATH_ALLOWED = DefaultRequestTarget.toBitSet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?@!$&'()*,;=+");
    private static final BitSet QUERY_ALLOWED = DefaultRequestTarget.toBitSet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?@!$&'()*,;=[]");
    private static final BitSet FRAGMENT_ALLOWED = PATH_ALLOWED;
    private static final BitSet PATH_MUST_PRESERVE_ENCODING = DefaultRequestTarget.toBitSet("/");
    private static final BitSet QUERY_MUST_PRESERVE_ENCODING = DefaultRequestTarget.toBitSet(":/?[]@!$&'()*+,;=");
    private static final BitSet FRAGMENT_MUST_PRESERVE_ENCODING = PATH_MUST_PRESERVE_ENCODING;
    private static final char[][] TO_PERCENT_ENCODED_CHARS = new char[256][];
    private static final Bytes EMPTY_BYTES;
    private static final Bytes SLASH_BYTES;
    private static final RequestTarget INSTANCE_ASTERISK;
    private final RequestTargetForm form;
    @Nullable
    private final String scheme;
    @Nullable
    private final String authority;
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final String fragment;
    private boolean cached;

    private static BitSet toBitSet(String chars) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < chars.length(); ++i) {
            bitSet.set(chars.charAt(i));
        }
        return bitSet;
    }

    @Nullable
    public static RequestTarget forServer(String reqTarget, boolean allowDoubleDotsInQueryString) {
        RequestTarget cached = RequestTargetCache.getForServer(reqTarget);
        if (cached != null) {
            return cached;
        }
        return DefaultRequestTarget.slowForServer(reqTarget, allowDoubleDotsInQueryString);
    }

    @Nullable
    public static RequestTarget forClient(String reqTarget, @Nullable String prefix) {
        Objects.requireNonNull(reqTarget, "reqTarget");
        int authorityPos = DefaultRequestTarget.findAuthority(reqTarget);
        if (authorityPos >= 0) {
            RequestTarget cached = RequestTargetCache.getForClient(reqTarget);
            if (cached != null) {
                return cached;
            }
            return DefaultRequestTarget.slowAbsoluteFormForClient(reqTarget, authorityPos);
        }
        String actualReqTarget = prefix == null || "*".equals(reqTarget) ? reqTarget : ArmeriaHttpUtil.concatPaths(prefix, reqTarget);
        RequestTarget cached = RequestTargetCache.getForClient(actualReqTarget);
        if (cached != null) {
            return cached;
        }
        return DefaultRequestTarget.slowForClient(actualReqTarget, null, 0);
    }

    public static RequestTarget createWithoutValidation(RequestTargetForm form, @Nullable String scheme, @Nullable String authority, String path, @Nullable String query, @Nullable String fragment) {
        return new DefaultRequestTarget(form, scheme, authority, path, query, fragment);
    }

    private DefaultRequestTarget(RequestTargetForm form, @Nullable String scheme, @Nullable String authority, String path, @Nullable String query, @Nullable String fragment) {
        assert (scheme != null && authority != null || scheme == null && authority == null) : "scheme: " + scheme + ", authority: " + authority;
        this.form = form;
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    @Override
    public RequestTargetForm form() {
        return this.form;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String fragment() {
        return this.fragment;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached() {
        this.cached = true;
    }

    public RequestTarget withPath(String path) {
        if (this.path == path) {
            return this;
        }
        return new DefaultRequestTarget(this.form, this.scheme, this.authority, path, this.query, this.fragment);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRequestTarget)) {
            return false;
        }
        DefaultRequestTarget that = (DefaultRequestTarget)o;
        return this.path.equals(that.path) && Objects.equals(this.query, that.query) && Objects.equals(this.fragment, that.fragment) && Objects.equals(this.authority, that.authority) && Objects.equals(this.scheme, that.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.authority, this.path, this.query, this.fragment);
    }

    @Override
    public String toString() {
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tmp.stringBuilder();
            if (this.scheme != null) {
                buf.append(this.scheme).append("://").append(this.authority);
            }
            buf.append(this.path);
            if (this.query != null) {
                buf.append('?').append(this.query);
            }
            if (this.fragment != null) {
                buf.append('#').append(this.fragment);
            }
            String string = buf.toString();
            return string;
        }
    }

    @Nullable
    private static RequestTarget slowForServer(String reqTarget, boolean allowDoubleDotsInQueryString) {
        Bytes query;
        Bytes path;
        int queryPos = reqTarget.indexOf(63);
        if (queryPos >= 0) {
            path = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, 0, queryPos, ComponentType.SERVER_PATH, null);
            if (path == null) {
                return null;
            }
            query = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, queryPos + 1, reqTarget.length(), ComponentType.QUERY, EMPTY_BYTES);
            if (query == null) {
                return null;
            }
        } else {
            path = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, 0, reqTarget.length(), ComponentType.SERVER_PATH, null);
            if (path == null) {
                return null;
            }
            query = null;
        }
        if (DefaultRequestTarget.isRelativePath(path)) {
            if (query == null && path.length == 1 && path.data[0] == 42) {
                return INSTANCE_ASTERISK;
            }
            return null;
        }
        if (DefaultRequestTarget.pathContainsDoubleDots(path)) {
            return null;
        }
        if (!allowDoubleDotsInQueryString && DefaultRequestTarget.queryContainsDoubleDots(query)) {
            return null;
        }
        return new DefaultRequestTarget(RequestTargetForm.ORIGIN, null, null, DefaultRequestTarget.encodePathToPercents(path), DefaultRequestTarget.encodeQueryToPercents(query), null);
    }

    @Nullable
    private static RequestTarget slowAbsoluteFormForClient(String reqTarget, int authorityPos) {
        String scheme = reqTarget.substring(0, authorityPos - 3);
        int nextPos = DefaultRequestTarget.findNextComponent(reqTarget, authorityPos);
        String authority = nextPos < 0 ? reqTarget.substring(authorityPos) : reqTarget.substring(authorityPos, nextPos);
        if (authority.isEmpty()) {
            return null;
        }
        URI schemeAndAuthority = DefaultRequestTarget.normalizeSchemeAndAuthority(scheme, authority);
        if (schemeAndAuthority == null) {
            return null;
        }
        if (nextPos < 0) {
            return new DefaultRequestTarget(RequestTargetForm.ABSOLUTE, schemeAndAuthority.getScheme(), schemeAndAuthority.getRawAuthority(), "/", null, null);
        }
        return DefaultRequestTarget.slowForClient(reqTarget, schemeAndAuthority, nextPos);
    }

    private static int findNextComponent(String reqTarget, int startPos) {
        for (int i = startPos; i < reqTarget.length(); ++i) {
            switch (reqTarget.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    return i;
                }
            }
        }
        return -1;
    }

    @Nullable
    private static RequestTarget slowForClient(String reqTarget, @Nullable URI schemeAndAuthority, int pathPos) {
        Bytes fragment;
        Bytes query;
        Bytes path;
        int queryPos;
        int fragmentPos;
        int maybeQueryPos = reqTarget.indexOf(63, pathPos);
        int maybeFragmentPos = reqTarget.indexOf(35, pathPos);
        if (maybeQueryPos >= 0) {
            if (maybeFragmentPos >= 0) {
                fragmentPos = maybeFragmentPos;
                queryPos = maybeQueryPos < maybeFragmentPos ? maybeQueryPos : -1;
            } else {
                queryPos = maybeQueryPos;
                fragmentPos = -1;
            }
        } else {
            queryPos = -1;
            fragmentPos = maybeFragmentPos;
        }
        if (queryPos >= 0) {
            path = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, pathPos, queryPos, ComponentType.CLIENT_PATH, SLASH_BYTES);
            if (path == null) {
                return null;
            }
            if (fragmentPos >= 0) {
                query = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, queryPos + 1, fragmentPos, ComponentType.QUERY, EMPTY_BYTES);
                if (query == null) {
                    return null;
                }
                fragment = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, fragmentPos + 1, reqTarget.length(), ComponentType.FRAGMENT, EMPTY_BYTES);
                if (fragment == null) {
                    return null;
                }
            } else {
                query = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, queryPos + 1, reqTarget.length(), ComponentType.QUERY, EMPTY_BYTES);
                if (query == null) {
                    return null;
                }
                fragment = null;
            }
        } else if (fragmentPos >= 0) {
            path = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, pathPos, fragmentPos, ComponentType.CLIENT_PATH, EMPTY_BYTES);
            if (path == null) {
                return null;
            }
            query = null;
            fragment = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, fragmentPos + 1, reqTarget.length(), ComponentType.FRAGMENT, EMPTY_BYTES);
            if (fragment == null) {
                return null;
            }
        } else {
            path = DefaultRequestTarget.decodePercentsAndEncodeToUtf8(reqTarget, pathPos, reqTarget.length(), ComponentType.CLIENT_PATH, EMPTY_BYTES);
            if (path == null) {
                return null;
            }
            query = null;
            fragment = null;
        }
        if (query == null && path.length == 1 && path.data[0] == 42) {
            return INSTANCE_ASTERISK;
        }
        String encodedPath = DefaultRequestTarget.isRelativePath(path) ? '/' + DefaultRequestTarget.encodePathToPercents(path) : DefaultRequestTarget.encodePathToPercents(path);
        String encodedQuery = DefaultRequestTarget.encodeQueryToPercents(query);
        String encodedFragment = DefaultRequestTarget.encodeFragmentToPercents(fragment);
        if (schemeAndAuthority != null) {
            return new DefaultRequestTarget(RequestTargetForm.ABSOLUTE, schemeAndAuthority.getScheme(), schemeAndAuthority.getRawAuthority(), encodedPath, encodedQuery, encodedFragment);
        }
        return new DefaultRequestTarget(RequestTargetForm.ORIGIN, null, null, encodedPath, encodedQuery, encodedFragment);
    }

    private static int findAuthority(String reqTarget) {
        int firstColonIdx = reqTarget.indexOf(58);
        if (firstColonIdx <= 0 || reqTarget.length() <= firstColonIdx + 3) {
            return -1;
        }
        int firstSlashIdx = reqTarget.indexOf(47);
        if (firstSlashIdx <= 0 || firstSlashIdx < firstColonIdx) {
            return -1;
        }
        if (reqTarget.charAt(firstColonIdx + 1) == '/' && reqTarget.charAt(firstColonIdx + 2) == '/') {
            return firstColonIdx + 3;
        }
        return -1;
    }

    @Nullable
    private static URI normalizeSchemeAndAuthority(String scheme, String authority) {
        try {
            return new URI(scheme, authority, null, null, null);
        }
        catch (Exception unused) {
            return null;
        }
    }

    private static boolean isRelativePath(Bytes path) {
        return path.length == 0 || path.data[0] != 47 || path.isEncoded(0);
    }

    @Nullable
    private static Bytes decodePercentsAndEncodeToUtf8(String value, int start, int end, ComponentType type, @Nullable Bytes whenEmpty) {
        int length = end - start;
        if (length == 0) {
            return whenEmpty;
        }
        Bytes buf = new Bytes(Math.max(length * 3 / 2, 4));
        boolean wasSlash = false;
        CodePointIterator i = new CodePointIterator(value, start, end);
        while (i.hasNextCodePoint()) {
            int pos = i.position();
            int cp = i.nextCodePoint();
            if (cp == 37) {
                int hexEnd = pos + 3;
                if (hexEnd > end) {
                    return null;
                }
                int digit1 = StringUtil.decodeHexNibble(value.charAt(pos + 1));
                int digit2 = StringUtil.decodeHexNibble(value.charAt(pos + 2));
                if (digit1 < 0 || digit2 < 0) {
                    return null;
                }
                int decoded = digit1 << 4 | digit2;
                if (type.mustPreserveEncoding(decoded)) {
                    buf.ensure(1);
                    buf.addEncoded((byte)decoded);
                    wasSlash = false;
                } else if (DefaultRequestTarget.appendOneByte(buf, decoded, wasSlash, type)) {
                    wasSlash = decoded == 47;
                } else {
                    return null;
                }
                i.position(hexEnd);
                continue;
            }
            if (cp == 43 && type == ComponentType.QUERY) {
                buf.ensure(1);
                buf.addEncoded((byte)32);
                wasSlash = false;
                continue;
            }
            if (cp <= 127) {
                if (!DefaultRequestTarget.appendOneByte(buf, cp, wasSlash, type)) {
                    return null;
                }
                wasSlash = cp == 47;
                continue;
            }
            if (cp <= 2047) {
                buf.ensure(2);
                buf.addEncoded((byte)(cp >>> 6 | 0xC0));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 65535) {
                buf.ensure(3);
                buf.addEncoded((byte)(cp >>> 12 | 0xE0));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x1FFFFF) {
                buf.ensure(4);
                buf.addEncoded((byte)(cp >>> 18 | 0xF0));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x3FFFFFF) {
                buf.ensure(5);
                buf.addEncoded((byte)(cp >>> 24 | 0xF8));
                buf.addEncoded((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else {
                buf.ensure(6);
                buf.addEncoded((byte)(cp >>> 30 | 0xFC));
                buf.addEncoded((byte)(cp >>> 24 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            }
            wasSlash = false;
        }
        return buf;
    }

    private static boolean appendOneByte(Bytes buf, int cp, boolean wasSlash, ComponentType type) {
        if (cp == 127) {
            return false;
        }
        if (cp >>> 5 == 0) {
            if (type != ComponentType.QUERY) {
                return false;
            }
            if (cp != 10 && cp != 13 && cp != 9) {
                return false;
            }
        }
        if (cp == 47 && type == ComponentType.SERVER_PATH) {
            if (!wasSlash) {
                buf.ensure(1);
                buf.add((byte)47);
            }
        } else {
            buf.ensure(1);
            if (type.isAllowed(cp)) {
                buf.add((byte)cp);
            } else {
                buf.addEncoded((byte)cp);
            }
        }
        return true;
    }

    private static boolean pathContainsDoubleDots(Bytes path) {
        int length = path.length;
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 47;
        for (int i = 1; i < length; ++i) {
            byte b3 = path.data[i];
            if (b1 == 46 && b2 == 46 && DefaultRequestTarget.isSlash(b0) && DefaultRequestTarget.isSlash(b3)) {
                return true;
            }
            b0 = b1;
            b1 = b2;
            b2 = b3;
        }
        return b1 == 46 && b2 == 46 && DefaultRequestTarget.isSlash(b0);
    }

    private static boolean queryContainsDoubleDots(@Nullable Bytes query) {
        if (query == null) {
            return false;
        }
        int length = query.length;
        boolean lookingForEquals = true;
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 47;
        for (int i = 0; i < length; ++i) {
            byte b3 = query.data[i];
            switch (b3) {
                case 61: {
                    if (!lookingForEquals) break;
                    lookingForEquals = false;
                    b3 = 47;
                    break;
                }
                case 38: 
                case 59: {
                    b3 = 47;
                    lookingForEquals = true;
                }
            }
            if (b1 == 46 && b2 == 46 && DefaultRequestTarget.isSlash(b0) && DefaultRequestTarget.isSlash(b3)) {
                return true;
            }
            b0 = b1;
            b1 = b2;
            b2 = b3;
        }
        return b1 == 46 && b2 == 46 && DefaultRequestTarget.isSlash(b0);
    }

    private static boolean isSlash(byte b) {
        switch (b) {
            case 47: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    private static String encodePathToPercents(Bytes value) {
        if (!value.hasEncodedBytes()) {
            return new String(value.data, 0, 0, value.length);
        }
        return DefaultRequestTarget.slowEncodePathToPercents(value);
    }

    @Nullable
    private static String encodeQueryToPercents(@Nullable Bytes value) {
        if (value == null) {
            return null;
        }
        if (!value.hasEncodedBytes()) {
            return new String(value.data, 0, 0, value.length);
        }
        return DefaultRequestTarget.slowEncodeQueryToPercents(value);
    }

    @Nullable
    private static String encodeFragmentToPercents(@Nullable Bytes value) {
        if (value == null) {
            return null;
        }
        if (!value.hasEncodedBytes()) {
            return new String(value.data, 0, 0, value.length);
        }
        return DefaultRequestTarget.slowEncodePathToPercents(value);
    }

    private static String slowEncodePathToPercents(Bytes value) {
        int length = value.length;
        StringBuilder buf = new StringBuilder(length + value.numEncodedBytes() * 2);
        for (int i = 0; i < length; ++i) {
            int b = value.data[i] & 0xFF;
            if (value.isEncoded(i)) {
                buf.append(TO_PERCENT_ENCODED_CHARS[b]);
                continue;
            }
            buf.append((char)b);
        }
        return buf.toString();
    }

    private static String slowEncodeQueryToPercents(Bytes value) {
        int length = value.length;
        StringBuilder buf = new StringBuilder(length + value.numEncodedBytes() * 2);
        for (int i = 0; i < length; ++i) {
            int b = value.data[i] & 0xFF;
            if (value.isEncoded(i)) {
                if (b == 32) {
                    buf.append('+');
                    continue;
                }
                buf.append(TO_PERCENT_ENCODED_CHARS[b]);
                continue;
            }
            buf.append((char)b);
        }
        return buf.toString();
    }

    static /* synthetic */ BitSet access$000() {
        return PATH_ALLOWED;
    }

    static /* synthetic */ BitSet access$100() {
        return PATH_MUST_PRESERVE_ENCODING;
    }

    static /* synthetic */ BitSet access$200() {
        return QUERY_ALLOWED;
    }

    static /* synthetic */ BitSet access$300() {
        return QUERY_MUST_PRESERVE_ENCODING;
    }

    static /* synthetic */ BitSet access$400() {
        return FRAGMENT_ALLOWED;
    }

    static /* synthetic */ BitSet access$500() {
        return FRAGMENT_MUST_PRESERVE_ENCODING;
    }

    static {
        for (int i = 0; i < TO_PERCENT_ENCODED_CHARS.length; ++i) {
            DefaultRequestTarget.TO_PERCENT_ENCODED_CHARS[i] = String.format("%%%02X", i).toCharArray();
        }
        EMPTY_BYTES = new Bytes(0);
        SLASH_BYTES = new Bytes(new byte[]{47});
        INSTANCE_ASTERISK = DefaultRequestTarget.createWithoutValidation(RequestTargetForm.ASTERISK, null, null, "*", null, null);
    }

    private static enum ComponentType {
        CLIENT_PATH(DefaultRequestTarget.access$000(), DefaultRequestTarget.access$100()),
        SERVER_PATH(DefaultRequestTarget.access$000(), DefaultRequestTarget.access$100()),
        QUERY(DefaultRequestTarget.access$200(), DefaultRequestTarget.access$300()),
        FRAGMENT(DefaultRequestTarget.access$400(), DefaultRequestTarget.access$500());

        private final BitSet allowed;
        private final BitSet mustPreserveEncoding;

        private ComponentType(BitSet allowed, BitSet mustPreserveEncoding) {
            this.allowed = allowed;
            this.mustPreserveEncoding = mustPreserveEncoding;
        }

        boolean isAllowed(int cp) {
            return this.allowed.get(cp);
        }

        boolean mustPreserveEncoding(int cp) {
            return this.mustPreserveEncoding.get(cp);
        }
    }

    private static final class Bytes {
        byte[] data;
        int length;
        @Nullable
        private BitSet encoded;
        private int numEncodedBytes;

        Bytes(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        Bytes(byte[] data) {
            this.data = data;
            this.length = data.length;
        }

        void add(byte b) {
            this.data[this.length++] = b;
        }

        void addEncoded(byte b) {
            if (this.encoded == null) {
                this.encoded = new BitSet();
            }
            this.encoded.set(this.length);
            this.data[this.length++] = b;
            ++this.numEncodedBytes;
        }

        boolean isEncoded(int index) {
            return this.encoded != null && this.encoded.get(index);
        }

        boolean hasEncodedBytes() {
            return this.encoded != null;
        }

        int numEncodedBytes() {
            return this.numEncodedBytes;
        }

        void ensure(int numBytes) {
            int newCapacity = this.length + numBytes;
            if (newCapacity <= this.data.length) {
                return;
            }
            newCapacity = (int)Math.max(Math.min((long)this.data.length + (long)(this.data.length >> 1), 0x7FFFFFF7L), (long)newCapacity);
            this.data = ByteArrays.forceCapacity(this.data, newCapacity, this.length);
        }
    }

    private static final class CodePointIterator {
        private final CharSequence str;
        private final int end;
        private int pos;

        CodePointIterator(CharSequence str, int start, int end) {
            this.str = str;
            this.end = end;
            this.pos = start;
        }

        int position() {
            return this.pos;
        }

        void position(int pos) {
            this.pos = pos;
        }

        boolean hasNextCodePoint() {
            return this.pos < this.end;
        }

        int nextCodePoint() {
            char c2;
            char c1;
            assert (this.pos < this.end);
            if (Character.isHighSurrogate(c1 = this.str.charAt(this.pos++)) && this.pos < this.end && Character.isLowSurrogate(c2 = this.str.charAt(this.pos))) {
                ++this.pos;
                return Character.toCodePoint(c1, c2);
            }
            return c1;
        }
    }
}

