/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.SignalLengthGetter;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamMessageDuplicator;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.AbortingSubscriber;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NeverInvokedSubscriber;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.SubscriberUtil;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamMessageDuplicator<T>
implements StreamMessageDuplicator<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStreamMessageDuplicator.class);
    private static final AtomicIntegerFieldUpdater<DefaultStreamMessageDuplicator> unsubscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultStreamMessageDuplicator.class, "unsubscribed");
    private final StreamMessageProcessor<T> processor;
    private final EventExecutor executor;
    private volatile int unsubscribed;

    public DefaultStreamMessageDuplicator(StreamMessage<T> upstream, SignalLengthGetter<? super T> signalLengthGetter, EventExecutor executor, long maxSignalLength) {
        Objects.requireNonNull(upstream, "upstream");
        Objects.requireNonNull(signalLengthGetter, "signalLengthGetter");
        this.executor = Objects.requireNonNull(executor, "executor");
        Preconditions.checkArgument(maxSignalLength >= 0L, "maxSignalLength: %s (expected: >= 0)", maxSignalLength);
        this.processor = new StreamMessageProcessor<T>(this, upstream, signalLengthGetter, executor, maxSignalLength);
    }

    @Override
    public StreamMessage<T> duplicate() {
        if (!this.processor.isDuplicable()) {
            throw new IllegalStateException("duplicator is closed.");
        }
        unsubscribedUpdater.incrementAndGet(this);
        return new ChildStreamMessage<T>(this.processor);
    }

    protected final EventExecutor duplicatorExecutor() {
        return this.executor;
    }

    @Override
    public final void close() {
        this.processor.close();
    }

    @Override
    public final void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public final void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.processor.abort(cause);
    }

    static final class StreamMessageProcessor<T>
    implements Subscriber<T> {
        private final DefaultStreamMessageDuplicator<T> duplicator;
        private final StreamMessage<T> upstream;
        private final SignalQueue signals;
        private final SignalLengthGetter<Object> signalLengthGetter;
        private final EventExecutor executor;
        private final int maxSignalLength;
        private int signalLength;
        private final Set<DownstreamSubscription<T>> downstreamSubscriptions = Collections.newSetFromMap(new ConcurrentHashMap());
        volatile int downstreamSignaledCounter;
        volatile int upstreamOffset;
        private long requestedDemand;
        @Nullable
        private Subscription upstreamSubscription;
        @Nullable
        private Throwable abortCause;
        private boolean cancelUpstream;
        private volatile State state = State.DUPLICABLE;

        StreamMessageProcessor(DefaultStreamMessageDuplicator<T> duplicator, StreamMessage<T> upstream, SignalLengthGetter<?> signalLengthGetter, EventExecutor executor, long maxSignalLength) {
            this.duplicator = duplicator;
            this.upstream = upstream;
            this.signalLengthGetter = signalLengthGetter;
            this.executor = executor;
            this.maxSignalLength = maxSignalLength == 0L || maxSignalLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxSignalLength;
            this.signals = new SignalQueue(this.signalLengthGetter);
            upstream.subscribe(this, executor, InternalStreamMessageUtil.CANCELLATION_AND_POOLED_OPTIONS);
        }

        StreamMessage<T> upstream() {
            return this.upstream;
        }

        EventExecutor executor() {
            return this.executor;
        }

        SignalQueue signals() {
            return this.signals;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.executor.inEventLoop()) {
                this.doOnSubscribe(s);
            } else {
                this.executor.execute(() -> this.doOnSubscribe(s));
            }
        }

        private void doOnSubscribe(Subscription s) {
            if (this.cancelUpstream) {
                s.cancel();
                return;
            }
            this.upstreamSubscription = s;
            this.downstreamSubscriptions.forEach(DownstreamSubscription::invokeOnSubscribe);
        }

        @Override
        public void onNext(T obj) {
            this.pushSignal(obj);
        }

        @Override
        public void onError(Throwable cause) {
            this.pushSignal(new CloseEvent(cause));
        }

        @Override
        public void onComplete() {
            this.pushSignal(CloseEvent.SUCCESSFUL_CLOSE);
        }

        private void pushSignal(Object obj) {
            if (this.executor.inEventLoop()) {
                this.doPushSignal(obj);
            } else {
                this.executor.execute(() -> this.doPushSignal(obj));
            }
        }

        private void doPushSignal(Object obj) {
            int dataLength;
            if (this.state == State.ABORTED) {
                StreamMessageUtil.closeOrAbort(obj, this.abortCause);
                return;
            }
            if (!(obj instanceof CloseEvent) && (dataLength = this.signalLengthGetter.length(obj)) > 0) {
                int allowedMaxSignalLength = this.maxSignalLength - this.signalLength;
                if (dataLength > allowedMaxSignalLength) {
                    long transferred = LongMath.saturatedAdd(this.signalLength, dataLength);
                    ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(this.maxSignalLength).transferred(transferred).build();
                    StreamMessageUtil.closeOrAbort(obj, cause);
                    this.upstream.abort(cause);
                    return;
                }
                this.signalLength += dataLength;
            }
            try {
                int removedLength = this.signals.addAndRemoveIfRequested(obj);
                this.signalLength -= removedLength;
            }
            catch (IllegalStateException e) {
                StreamMessageUtil.closeOrAbort(obj, e);
                this.upstream.abort(e);
                return;
            }
            ++this.upstreamOffset;
            if (!this.downstreamSubscriptions.isEmpty()) {
                this.downstreamSubscriptions.forEach(DownstreamSubscription::signal);
            }
        }

        void subscribe(DownstreamSubscription<T> subscription) {
            if (this.executor.inEventLoop()) {
                this.doSubscribe(subscription);
            } else {
                this.executor.execute(() -> this.doSubscribe(subscription));
            }
        }

        private void doSubscribe(DownstreamSubscription<T> subscription) {
            if (this.state == State.ABORTED) {
                EventExecutor executor = subscription.executor;
                if (executor.inEventLoop()) {
                    StreamMessageProcessor.failLateProcessorSubscriber(subscription);
                } else {
                    executor.execute(() -> StreamMessageProcessor.failLateProcessorSubscriber(subscription));
                }
                return;
            }
            this.downstreamSubscriptions.add(subscription);
            unsubscribedUpdater.decrementAndGet(this.duplicator);
            if (this.upstreamSubscription != null) {
                subscription.invokeOnSubscribe();
            }
        }

        private static void failLateProcessorSubscriber(DownstreamSubscription<?> subscription) {
            Subscriber<?> lateSubscriber = subscription.subscriber();
            try {
                lateSubscriber.onSubscribe(NoopSubscription.get());
                lateSubscriber.onError(new IllegalStateException("duplicator is closed or no more downstream can be added."));
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber should not throw an exception. subscriber: {}", (Object)lateSubscriber, (Object)t);
            }
        }

        void unsubscribe(DownstreamSubscription<T> subscription, @Nullable Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.doUnsubscribe(subscription, cause);
            } else {
                this.executor.execute(() -> this.doUnsubscribe(subscription, cause));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUnsubscribe(DownstreamSubscription<T> subscription, @Nullable Throwable cause) {
            if (!this.downstreamSubscriptions.remove(subscription)) {
                return;
            }
            Subscriber<T> subscriber = subscription.subscriber();
            subscription.clearSubscriber();
            CompletableFuture<Void> completionFuture = subscription.whenComplete();
            if (cause == null) {
                try {
                    subscriber.onComplete();
                    completionFuture.complete(null);
                }
                catch (Throwable t) {
                    completionFuture.completeExceptionally(t);
                    Exceptions.throwIfFatal(t);
                    logger.warn("Subscriber.onComplete() should not raise an exception. subscriber: {}", (Object)subscriber, (Object)t);
                }
                finally {
                    this.doCleanupIfLastSubscription();
                }
                return;
            }
            try {
                if (((DownstreamSubscription)subscription).notifyCancellation || !(cause instanceof CancelledSubscriptionException)) {
                    subscriber.onError(cause);
                }
                completionFuture.completeExceptionally(cause);
            }
            catch (Throwable t) {
                CompositeException composite = new CompositeException(t, cause);
                completionFuture.completeExceptionally(composite);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onError() should not raise an exception. subscriber: {}", (Object)subscriber, (Object)composite);
            }
            finally {
                this.doCleanupIfLastSubscription();
            }
        }

        private void doCleanupIfLastSubscription() {
            if (this.isClosed() && ((DefaultStreamMessageDuplicator)this.duplicator).unsubscribed == 0 && this.downstreamSubscriptions.isEmpty()) {
                this.state = State.ABORTED;
                this.doCancelUpstreamSubscription();
                this.signals.clear(null);
            }
        }

        private void doCancelUpstreamSubscription() {
            if (this.upstreamSubscription != null) {
                this.upstreamSubscription.cancel();
            } else {
                this.cancelUpstream = true;
            }
        }

        void requestDemand(long cumulativeDemand) {
            if (this.executor.inEventLoop()) {
                this.doRequestDemand(cumulativeDemand);
            } else {
                this.executor.execute(() -> this.doRequestDemand(cumulativeDemand));
            }
        }

        void doRequestDemand(long cumulativeDemand) {
            if (this.upstreamSubscription == null) {
                return;
            }
            if (cumulativeDemand <= this.requestedDemand) {
                return;
            }
            long delta = cumulativeDemand - this.requestedDemand;
            this.requestedDemand += delta;
            this.upstreamSubscription.request(delta);
        }

        boolean isDuplicable() {
            return this.state == State.DUPLICABLE;
        }

        boolean isClosed() {
            return this.state == State.CLOSED;
        }

        void close() {
            if (this.executor.inEventLoop()) {
                this.doClose();
            } else {
                this.executor.execute(this::doClose);
            }
        }

        void doClose() {
            if (this.state == State.DUPLICABLE) {
                if (((DefaultStreamMessageDuplicator)this.duplicator).unsubscribed == 0 && this.downstreamSubscriptions.isEmpty()) {
                    this.state = State.ABORTED;
                    this.doCancelUpstreamSubscription();
                    this.signals.clear(null);
                } else {
                    this.state = State.CLOSED;
                }
            }
        }

        void abort(Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.doAbort(cause);
            } else {
                this.executor.execute(() -> this.doAbort(cause));
            }
        }

        void doAbort(Throwable cause) {
            if (this.state != State.ABORTED) {
                this.state = State.ABORTED;
                this.abortCause = cause;
                this.doCancelUpstreamSubscription();
                this.doCleanup(cause);
            }
        }

        private void doCleanup(Throwable cause) {
            ArrayList completionFutures = new ArrayList(this.downstreamSubscriptions.size());
            this.downstreamSubscriptions.forEach(s -> {
                s.abort(cause);
                CompletableFuture<Void> future = s.whenComplete();
                completionFutures.add(future);
            });
            this.downstreamSubscriptions.clear();
            CompletableFutures.successfulAsList(completionFutures, unused -> null).handle((unused1, unused2) -> {
                this.signals.clear(cause);
                return null;
            });
        }

        private static enum State {
            DUPLICABLE,
            CLOSED,
            ABORTED;

        }
    }

    static final class ChildStreamMessage<T>
    implements StreamMessage<T> {
        private static final AtomicReferenceFieldUpdater<ChildStreamMessage, DownstreamSubscription> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(ChildStreamMessage.class, DownstreamSubscription.class, "subscription");
        private final StreamMessageProcessor<T> processor;
        @Nullable
        private volatile DownstreamSubscription<T> subscription;
        private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();

        ChildStreamMessage(StreamMessageProcessor<T> processor) {
            this.processor = processor;
        }

        @Override
        public boolean isOpen() {
            return this.processor.upstream().isOpen() && !this.completionFuture.isDone();
        }

        @Override
        public boolean isEmpty() {
            if (this.isOpen()) {
                return false;
            }
            return this.processor.upstream().isEmpty();
        }

        @Override
        public long demand() {
            return this.processor.upstream().demand();
        }

        @Override
        public CompletableFuture<Void> whenComplete() {
            return this.completionFuture;
        }

        @Override
        public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor) {
            this.subscribe(subscriber, executor, false, false);
        }

        @Override
        public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
            Objects.requireNonNull(options, "options");
            boolean withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
            boolean notifyCancellation = InternalStreamMessageUtil.containsNotifyCancellation(options);
            this.subscribe(subscriber, executor, withPooledObjects, notifyCancellation);
        }

        private void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
            Objects.requireNonNull(subscriber, "subscriber");
            Objects.requireNonNull(executor, "executor");
            DownstreamSubscription<? super T> subscription = new DownstreamSubscription<T>(this, subscriber, this.processor, executor, withPooledObjects, notifyCancellation);
            if (!this.subscribe0(subscription)) {
                DownstreamSubscription<T> oldSubscription = this.subscription;
                assert (oldSubscription != null);
                ChildStreamMessage.failLateSubscriber(executor, subscriber, oldSubscription.subscriber());
            }
        }

        private boolean subscribe0(DownstreamSubscription<T> subscription) {
            if (!subscriptionUpdater.compareAndSet(this, null, subscription)) {
                return false;
            }
            this.processor.subscribe(subscription);
            return true;
        }

        private static void failLateSubscriber(EventExecutor executor, Subscriber<?> lateSubscriber, Subscriber<?> oldSubscriber) {
            Throwable cause = SubscriberUtil.abortedOrLate(oldSubscriber);
            executor.execute(() -> {
                try {
                    lateSubscriber.onSubscribe(NoopSubscription.get());
                    lateSubscriber.onError(cause);
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal(t);
                    logger.warn("Subscriber should not throw an exception. subscriber: {}", (Object)lateSubscriber, (Object)t);
                }
            });
        }

        @Override
        public EventExecutor defaultSubscriberExecutor() {
            return this.processor.executor();
        }

        @Override
        public void abort() {
            this.abort0(AbortedStreamException.get());
        }

        @Override
        public void abort(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            this.abort0(cause);
        }

        private void abort0(Throwable cause) {
            DownstreamSubscription<T> currentSubscription = this.subscription;
            if (currentSubscription != null) {
                currentSubscription.abort(cause);
                return;
            }
            DownstreamSubscription newSubscription = new DownstreamSubscription(this, AbortingSubscriber.get(cause), this.processor, ImmediateEventExecutor.INSTANCE, false, false);
            if (!this.subscribe0(newSubscription)) {
                currentSubscription = this.subscription;
                assert (currentSubscription != null);
                currentSubscription.abort(cause);
            }
        }
    }

    static final class SignalQueue {
        private static final AtomicIntegerFieldUpdater<SignalQueue> lastRemovalRequestedOffsetUpdater = AtomicIntegerFieldUpdater.newUpdater(SignalQueue.class, "lastRemovalRequestedOffset");
        private final SignalLengthGetter<Object> signalLengthGetter;
        @Nullable
        volatile Object[] elements;
        private volatile int head;
        private volatile int tail;
        private volatile int size;
        private int headOffset;
        private volatile int lastRemovalRequestedOffset;

        SignalQueue(SignalLengthGetter<Object> signalLengthGetter) {
            this.signalLengthGetter = signalLengthGetter;
            this.elements = new Object[16];
        }

        int addAndRemoveIfRequested(Object o) {
            Objects.requireNonNull(o);
            int removedLength = 0;
            if (this.headOffset < this.lastRemovalRequestedOffset) {
                removedLength = this.removeElements();
            }
            int t = this.tail;
            Object[] elements = this.elements;
            assert (elements != null) : "elements is null. SignalQueue: " + this;
            elements[t] = o;
            ++this.size;
            this.tail = t + 1 & elements.length - 1;
            if (this.tail == this.head) {
                this.doubleCapacity();
            }
            return removedLength;
        }

        private int removeElements() {
            int removalRequestedOffset = this.lastRemovalRequestedOffset;
            int numElementsToBeRemoved = removalRequestedOffset - this.headOffset;
            Object[] elements = this.elements;
            assert (elements != null) : "elements is null. SignalQueue: " + this;
            int bitMask = elements.length - 1;
            int oldHead = this.head;
            int removedLength = 0;
            for (int numRemovals = 0; numRemovals < numElementsToBeRemoved; ++numRemovals) {
                int index = oldHead + numRemovals & bitMask;
                Object o = elements[index];
                if (!(o instanceof CloseEvent)) {
                    removedLength += this.signalLengthGetter.length(o);
                }
                StreamMessageUtil.closeOrAbort(o);
                elements[index] = null;
            }
            this.head = oldHead + numElementsToBeRemoved & bitMask;
            this.headOffset = removalRequestedOffset;
            this.size -= numElementsToBeRemoved;
            return removedLength;
        }

        private void doubleCapacity() {
            assert (this.head == this.tail);
            int h = this.head;
            Object[] elements = this.elements;
            assert (elements != null) : "elements is null. SignalQueue: " + this;
            int n = elements.length;
            int r = n - h;
            int newCapacity = n << 1;
            if (newCapacity < 0) {
                throw new IllegalStateException("published more than Integer.MAX_VALUE signals.");
            }
            Object[] a = new Object[newCapacity];
            int hOffset = this.headOffset;
            if ((hOffset & newCapacity - 1) == (hOffset & n - 1)) {
                System.arraycopy(elements, h, a, h, r);
                System.arraycopy(elements, 0, a, n, h);
                this.tail += n;
            } else {
                System.arraycopy(elements, h, a, h + n, r);
                System.arraycopy(elements, 0, a, 0, h);
                this.head = h + n;
            }
            this.elements = a;
        }

        Object get(int offset) {
            int head = this.head;
            int tail = this.tail;
            Object[] elements = this.elements;
            assert (elements != null) : "elements is null. SignalQueue: " + this;
            int length = elements.length;
            int convertedIndex = offset & length - 1;
            Preconditions.checkState(this.size > 0, "queue is empty.");
            Preconditions.checkArgument(head < tail ? head <= convertedIndex && convertedIndex < tail : head <= convertedIndex && convertedIndex < length || 0 <= convertedIndex && convertedIndex < tail, "offset: %s is invalid. head: %s, tail: %s, capacity: %s ", (Object)offset, (Object)head, (Object)tail, (Object)length);
            Preconditions.checkArgument(offset >= this.lastRemovalRequestedOffset, "offset: %s is invalid. (expected: >= lastRemovalRequestedOffset: %s)", offset, this.lastRemovalRequestedOffset);
            return elements[convertedIndex];
        }

        void requestRemovalAheadOf(int offset) {
            int oldLastRemovalRequestedOffset;
            do {
                if ((oldLastRemovalRequestedOffset = this.lastRemovalRequestedOffset) < offset) continue;
                return;
            } while (!lastRemovalRequestedOffsetUpdater.compareAndSet(this, oldLastRemovalRequestedOffset, offset));
        }

        int size() {
            return this.size;
        }

        void clear(@Nullable Throwable cause) {
            Object[] oldElements = this.elements;
            if (oldElements == null) {
                return;
            }
            this.elements = null;
            int end = this.tail;
            if (end < this.head) {
                end += oldElements.length;
            }
            int bitMask = oldElements.length - 1;
            for (int i = this.head; i < end; ++i) {
                StreamMessageUtil.closeOrAbort(oldElements[i & bitMask], cause);
            }
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
            Object[] elements = this.elements;
            if (elements != null) {
                toStringHelper.add("elements.length", elements.length);
            }
            return toStringHelper.add("head", this.head).add("tail", this.tail).add("size", this.size).add("headOffset", this.headOffset).add("lastRemovalRequestedOffset", this.lastRemovalRequestedOffset).toString();
        }
    }

    private static final class CloseEvent {
        static final CloseEvent SUCCESSFUL_CLOSE = new CloseEvent(null);
        @Nullable
        private final Throwable cause;

        CloseEvent(@Nullable Throwable cause) {
            this.cause = cause;
        }

        public String toString() {
            if (this.cause == null) {
                return "CloseEvent";
            }
            return "CloseEvent(" + this.cause + ')';
        }
    }

    static final class DownstreamSubscription<T>
    implements Subscription {
        private static final int REQUEST_REMOVAL_THRESHOLD = 50;
        static final AtomicLongFieldUpdater<DownstreamSubscription> demandUpdater = AtomicLongFieldUpdater.newUpdater(DownstreamSubscription.class, "demand");
        private static final AtomicReferenceFieldUpdater<DownstreamSubscription, Throwable> cancelledOrAbortedUpdater = AtomicReferenceFieldUpdater.newUpdater(DownstreamSubscription.class, Throwable.class, "cancelledOrAborted");
        private final StreamMessage<T> streamMessage;
        private Subscriber<? super T> subscriber;
        private final StreamMessageProcessor<T> processor;
        private final EventExecutor executor;
        private final boolean withPooledObjects;
        private final boolean notifyCancellation;
        private boolean invokedOnSubscribe;
        private volatile long demand;
        @Nullable
        private volatile Throwable cancelledOrAborted;
        private volatile int offset;
        private long cumulativeDemand;
        private boolean inOnNext;

        DownstreamSubscription(ChildStreamMessage<T> streamMessage, Subscriber<? super T> subscriber, StreamMessageProcessor<T> processor, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
            this.streamMessage = streamMessage;
            this.subscriber = subscriber;
            this.processor = processor;
            this.executor = executor;
            this.withPooledObjects = withPooledObjects;
            this.notifyCancellation = notifyCancellation;
        }

        CompletableFuture<Void> whenComplete() {
            return this.streamMessage.whenComplete();
        }

        Subscriber<? super T> subscriber() {
            return this.subscriber;
        }

        void clearSubscriber() {
            if (!(this.subscriber instanceof AbortingSubscriber)) {
                this.subscriber = NeverInvokedSubscriber.get();
            }
        }

        void invokeOnSubscribe() {
            if (this.invokedOnSubscribe) {
                return;
            }
            this.invokedOnSubscribe = true;
            if (this.executor.inEventLoop()) {
                this.invokeOnSubscribe0();
            } else {
                this.executor.execute(this::invokeOnSubscribe0);
            }
        }

        void invokeOnSubscribe0() {
            try {
                this.subscriber.onSubscribe(this);
            }
            catch (Throwable t) {
                this.processor.unsubscribe(this, t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onSubscribe() should not raise an exception. subscriber: {}", (Object)this.subscriber, (Object)t);
            }
        }

        @Override
        public void request(long n) {
            block2: {
                long newDemand;
                long oldDemand;
                if (n <= 0L) {
                    IllegalArgumentException cause = new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)");
                    this.processor.unsubscribe(this, cause);
                    return;
                }
                this.accumulateDemand(n);
                this.processor.requestDemand(this.cumulativeDemand);
                while (!demandUpdater.compareAndSet(this, oldDemand, newDemand = (oldDemand = this.demand) >= Long.MAX_VALUE - n ? Long.MAX_VALUE : oldDemand + n)) {
                }
                if (oldDemand != 0L) break block2;
                this.signal();
            }
        }

        private void accumulateDemand(long n) {
            this.cumulativeDemand = n == Long.MAX_VALUE || Long.MAX_VALUE - n >= this.cumulativeDemand ? Long.MAX_VALUE : (this.cumulativeDemand += n);
        }

        void signal() {
            if (this.executor.inEventLoop()) {
                this.doSignal();
            } else {
                this.executor.execute(this::doSignal);
            }
        }

        private void doSignal() {
            SignalQueue signals = this.processor.signals();
            while (this.doSignalSingle(signals)) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doSignalSingle(SignalQueue signals) {
            long demand;
            if (this.inOnNext) {
                return false;
            }
            if (this.cancelledOrAborted != null) {
                this.processor.unsubscribe(this, this.cancelledOrAborted);
                return false;
            }
            if (this.offset == this.processor.upstreamOffset) {
                return false;
            }
            Object signal = signals.get(this.offset);
            if (signal instanceof CloseEvent) {
                ++this.offset;
                this.processor.unsubscribe(this, ((CloseEvent)signal).cause);
                return false;
            }
            do {
                if ((demand = this.demand) != 0L) continue;
                return false;
            } while (demand != Long.MAX_VALUE && !demandUpdater.compareAndSet(this, demand, demand - 1L));
            ++this.offset;
            Object obj = signal;
            try {
                HttpData data;
                if (obj instanceof HttpData && (data = (HttpData)obj).isPooled()) {
                    ByteBuf byteBuf;
                    if (this.withPooledObjects) {
                        byteBuf = data.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE);
                        HttpData retained = HttpData.wrap(byteBuf).withEndOfStream(data.isEndOfStream());
                        obj = retained;
                    } else {
                        byteBuf = data.byteBuf();
                        HttpData copied = HttpData.copyOf(byteBuf).withEndOfStream(data.isEndOfStream());
                        obj = copied;
                    }
                }
            }
            catch (Throwable thrown) {
                this.processor.unsubscribe(this, thrown);
                return false;
            }
            if (this.processor.isClosed() && ((StreamMessageProcessor)this.processor).duplicator.unsubscribed == 0 && ++this.processor.downstreamSignaledCounter >= 50) {
                this.processor.downstreamSignaledCounter = 0;
                int minOffset = Integer.MAX_VALUE;
                for (DownstreamSubscription s : ((StreamMessageProcessor)this.processor).downstreamSubscriptions) {
                    minOffset = Math.min(minOffset, s.offset);
                }
                signals.requestRemovalAheadOf(minOffset);
            }
            this.inOnNext = true;
            try {
                this.subscriber.onNext(obj);
            }
            catch (Throwable t) {
                this.processor.unsubscribe(this, t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onNext({}) should not raise an exception. subscriber: {}", obj, this.subscriber, t);
                boolean bl = false;
                return bl;
            }
            finally {
                this.inOnNext = false;
            }
            return true;
        }

        @Override
        public void cancel() {
            this.abort(this.subscriber instanceof AbortingSubscriber ? ((AbortingSubscriber)this.subscriber).cause() : CancelledSubscriptionException.get());
        }

        void abort(Throwable cause) {
            if (cancelledOrAbortedUpdater.compareAndSet(this, null, cause)) {
                this.signal();
            }
        }
    }
}

