/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.multipart;

import com.linecorp.armeria.common.multipart.DefaultMultipartFile;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public interface MultipartFile {
    public static MultipartFile of(String name, String filename, File file) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(filename, "filename");
        Objects.requireNonNull(file, "file");
        return MultipartFile.of(name, filename, file.toPath());
    }

    public static MultipartFile of(String name, String filename, Path path) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(filename, "filename");
        Objects.requireNonNull(path, "path");
        return new DefaultMultipartFile(name, filename, path);
    }

    public String name();

    public String filename();

    default public File file() {
        return this.path().toFile();
    }

    public Path path();
}

