/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface RequestLogLevelMapper
extends Function<RequestOnlyLog, LogLevel> {
    public static RequestLogLevelMapper of(LogLevel logLevel) {
        Objects.requireNonNull(logLevel, "logLevel");
        return log -> logLevel;
    }

    public static RequestLogLevelMapper of(Class<? extends Throwable> clazz, LogLevel logLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(logLevel, "logLevel");
        return log -> {
            Throwable t = log.requestCause();
            if (t == null) {
                return null;
            }
            Class<?> throwableClass = t.getClass();
            if (clazz.isAssignableFrom(throwableClass)) {
                return logLevel;
            }
            return null;
        };
    }

    @Override
    @Nullable
    public LogLevel apply(RequestOnlyLog var1);

    default public RequestLogLevelMapper orElse(RequestLogLevelMapper other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return log -> {
            LogLevel logLevel = this.apply(log);
            if (logLevel != null) {
                return logLevel;
            }
            return other.apply(log);
        };
    }

    @Override
    @Deprecated
    default public <V> Function<V, LogLevel> compose(Function<? super V, ? extends RequestOnlyLog> before) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public <V> Function<RequestOnlyLog, V> andThen(Function<? super LogLevel, ? extends V> after) {
        throw new UnsupportedOperationException();
    }
}

