/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.DefaultAggregationOptions;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;

public final class AggregationOptionsBuilder {
    @Nullable
    private EventExecutor executor;
    @Nullable
    private ByteBufAllocator alloc;
    private boolean cacheResult;
    private boolean preferCached = true;

    AggregationOptionsBuilder() {
    }

    public AggregationOptionsBuilder executor(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public AggregationOptionsBuilder cacheResult(boolean cache) {
        if (this.alloc != null) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.cacheResult = cache;
        return this;
    }

    @Deprecated
    public AggregationOptionsBuilder alloc(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        if (this.cacheResult) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.alloc = alloc;
        return this;
    }

    public AggregationOptionsBuilder usePooledObjects() {
        return this.usePooledObjects(ByteBufAllocator.DEFAULT);
    }

    public AggregationOptionsBuilder usePooledObjects(ByteBufAllocator alloc) {
        return this.usePooledObjects(Objects.requireNonNull(alloc, "alloc"), true);
    }

    public AggregationOptionsBuilder usePooledObjects(ByteBufAllocator alloc, boolean preferCached) {
        Objects.requireNonNull(alloc, "alloc");
        if (this.cacheResult) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.alloc = alloc;
        this.preferCached = preferCached;
        return this;
    }

    public AggregationOptions build() {
        return new DefaultAggregationOptions(this.executor, this.alloc, this.preferCached, this.cacheResult);
    }
}

