/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

final class WeightedRandomDistributionEndpointSelector {
    private final ReentrantLock lock = new ReentrantLock();
    private final List<Entry> allEntries;
    @GuardedBy(value="lock")
    private final List<Entry> currentEntries;
    private final long total;
    private long remaining;

    WeightedRandomDistributionEndpointSelector(List<Endpoint> endpoints) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(endpoints.size());
        long total = 0L;
        for (Endpoint endpoint : endpoints) {
            if (endpoint.weight() <= 0) continue;
            builder.add(new Entry(endpoint));
            total += (long)endpoint.weight();
        }
        this.total = total;
        this.remaining = total;
        this.allEntries = builder.build();
        this.currentEntries = new ArrayList<Entry>(this.allEntries);
    }

    List<Entry> entries() {
        return this.allEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Endpoint selectEndpoint() {
        if (this.allEntries.isEmpty()) {
            return null;
        }
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        this.lock.lock();
        try {
            long target = threadLocalRandom.nextLong(this.remaining);
            Iterator<Entry> it = this.currentEntries.iterator();
            while (it.hasNext()) {
                Entry entry = it.next();
                int weight = entry.weight();
                if ((target -= (long)weight) >= 0L) continue;
                entry.increment();
                if (entry.isFull()) {
                    it.remove();
                    entry.reset();
                    this.remaining -= (long)weight;
                    if (this.remaining == 0L) {
                        this.currentEntries.addAll(this.allEntries);
                        this.remaining = this.total;
                    } else assert (this.remaining > 0L) : this.remaining;
                }
                Endpoint endpoint = entry.endpoint();
                return endpoint;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new Error("Should never reach here");
    }

    static final class Entry {
        private final Endpoint endpoint;
        private int counter;

        Entry(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        Endpoint endpoint() {
            return this.endpoint;
        }

        void increment() {
            assert (this.counter < this.endpoint().weight());
            ++this.counter;
        }

        int weight() {
            return this.endpoint().weight();
        }

        void reset() {
            this.counter = 0;
        }

        int counter() {
            return this.counter;
        }

        boolean isFull() {
            return this.counter >= this.endpoint.weight();
        }
    }
}

