/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.client.DefaultWebClient;
import com.linecorp.armeria.client.FutureResponseAs;
import com.linecorp.armeria.client.FutureTransformingRequestPreparation;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RequestOptionsBuilder;
import com.linecorp.armeria.client.ResponseAs;
import com.linecorp.armeria.client.TransformingRequestPreparation;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebRequestPreparationSetters;
import com.linecorp.armeria.common.AbstractHttpRequestBuilder;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.util.AttributeKey;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;

public final class WebClientRequestPreparation
extends AbstractHttpRequestBuilder
implements WebRequestPreparationSetters<HttpResponse> {
    private final WebClient client;
    @Nullable
    private RequestOptionsBuilder requestOptionsBuilder;

    WebClientRequestPreparation(WebClient client) {
        this.client = client;
    }

    @Override
    public HttpResponse execute() {
        HttpRequest httpRequest = this.buildRequest();
        RequestOptions requestOptions = this.buildRequestOptions();
        return this.client.execute(httpRequest, requestOptions);
    }

    private RequestOptions buildRequestOptions() {
        RequestOptions requestOptions;
        boolean requestStreaming = this.isRequestStreaming();
        if (this.requestOptionsBuilder != null) {
            if (this.requestOptionsBuilder.exchangeType() == null && !requestStreaming) {
                this.requestOptionsBuilder.exchangeType(ExchangeType.RESPONSE_STREAMING);
            }
            requestOptions = this.requestOptionsBuilder.build();
        } else {
            requestOptions = !requestStreaming ? DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS : RequestOptions.of();
        }
        return requestOptions;
    }

    boolean isRequestStreaming() {
        return this.publisher() != null;
    }

    public <T> TransformingRequestPreparation<HttpResponse, T> as(ResponseAs<HttpResponse, T> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new TransformingRequestPreparation<HttpResponse, T>(this, responseAs);
    }

    public <T> FutureTransformingRequestPreparation<ResponseEntity<T>> asEntity(FutureResponseAs<ResponseEntity<T>> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new FutureTransformingRequestPreparation<ResponseEntity<T>>(this, responseAs);
    }

    public FutureTransformingRequestPreparation<ResponseEntity<byte[]>> asBytes() {
        return this.asEntity(ResponseAs.bytes());
    }

    public FutureTransformingRequestPreparation<ResponseEntity<String>> asString() {
        return this.asEntity(ResponseAs.string());
    }

    public FutureTransformingRequestPreparation<ResponseEntity<Path>> asFile(Path path) {
        Objects.requireNonNull(path, "path");
        return this.asEntity(ResponseAs.path(path));
    }

    public FutureTransformingRequestPreparation<ResponseEntity<Path>> asFile(File file) {
        Objects.requireNonNull(file, "file");
        return this.asFile(file.toPath());
    }

    public <T> FutureTransformingRequestPreparation<ResponseEntity<T>> asJson(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.asEntity(ResponseAs.json(clazz));
    }

    public <T> FutureTransformingRequestPreparation<ResponseEntity<T>> asJson(Class<? extends T> clazz, ObjectMapper mapper) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(mapper, "mapper");
        return this.asEntity(ResponseAs.json(clazz));
    }

    public <T> FutureTransformingRequestPreparation<ResponseEntity<T>> asJson(TypeReference<? extends T> typeRef) {
        Objects.requireNonNull(typeRef, "typeRef");
        return this.asEntity(ResponseAs.json(typeRef));
    }

    public <T> FutureTransformingRequestPreparation<ResponseEntity<T>> asJson(TypeReference<? extends T> typeRef, ObjectMapper mapper) {
        Objects.requireNonNull(typeRef, "typeRef");
        Objects.requireNonNull(mapper, "mapper");
        return this.asEntity(ResponseAs.json(typeRef, mapper));
    }

    @Override
    public WebClientRequestPreparation requestOptions(RequestOptions requestOptions) {
        ExchangeType exchangeType;
        Map<AttributeKey<?>, Object> attrs;
        long writeTimeoutMillis;
        long responseTimeoutMillis;
        Objects.requireNonNull(requestOptions, "requestOptions");
        long maxResponseLength = requestOptions.maxResponseLength();
        if (maxResponseLength >= 0L) {
            this.maxResponseLength(maxResponseLength);
        }
        if ((responseTimeoutMillis = requestOptions.responseTimeoutMillis()) >= 0L) {
            this.responseTimeoutMillis(responseTimeoutMillis);
        }
        if ((writeTimeoutMillis = requestOptions.writeTimeoutMillis()) >= 0L) {
            this.writeTimeoutMillis(writeTimeoutMillis);
        }
        if (!(attrs = requestOptions.attrs()).isEmpty()) {
            attrs.forEach((key, value) -> this.attr((AttributeKey)key, value));
        }
        if ((exchangeType = requestOptions.exchangeType()) != null) {
            this.exchangeType(exchangeType);
        }
        return this;
    }

    @Override
    public WebClientRequestPreparation responseTimeout(Duration responseTimeout) {
        return this.responseTimeoutMillis(Objects.requireNonNull(responseTimeout, "responseTimeout").toMillis());
    }

    @Override
    public WebClientRequestPreparation responseTimeoutMillis(long responseTimeoutMillis) {
        this.requestOptionsBuilder().responseTimeoutMillis(responseTimeoutMillis);
        return this;
    }

    @Override
    public WebClientRequestPreparation writeTimeout(Duration writeTimeout) {
        return this.writeTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    @Override
    public WebClientRequestPreparation writeTimeoutMillis(long writeTimeoutMillis) {
        this.requestOptionsBuilder().writeTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    @Override
    public WebClientRequestPreparation maxResponseLength(long maxResponseLength) {
        this.requestOptionsBuilder().maxResponseLength(maxResponseLength);
        return this;
    }

    @Override
    public <V> WebClientRequestPreparation attr(AttributeKey<V> key, @Nullable V value) {
        this.requestOptionsBuilder().attr((AttributeKey)key, (Object)value);
        return this;
    }

    @Nullable
    ExchangeType exchangeType() {
        if (this.requestOptionsBuilder == null) {
            return null;
        }
        return this.requestOptionsBuilder.exchangeType();
    }

    @Override
    public WebClientRequestPreparation exchangeType(ExchangeType exchangeType) {
        this.requestOptionsBuilder().exchangeType(exchangeType);
        return this;
    }

    private RequestOptionsBuilder requestOptionsBuilder() {
        if (this.requestOptionsBuilder == null) {
            this.requestOptionsBuilder = RequestOptions.builder();
        }
        return this.requestOptionsBuilder;
    }

    @Override
    public WebClientRequestPreparation get(String path) {
        return (WebClientRequestPreparation)super.get(path);
    }

    @Override
    public WebClientRequestPreparation post(String path) {
        return (WebClientRequestPreparation)super.post(path);
    }

    @Override
    public WebClientRequestPreparation put(String path) {
        return (WebClientRequestPreparation)super.put(path);
    }

    @Override
    public WebClientRequestPreparation delete(String path) {
        return (WebClientRequestPreparation)super.delete(path);
    }

    @Override
    public WebClientRequestPreparation patch(String path) {
        return (WebClientRequestPreparation)super.patch(path);
    }

    @Override
    public WebClientRequestPreparation options(String path) {
        return (WebClientRequestPreparation)super.options(path);
    }

    @Override
    public WebClientRequestPreparation head(String path) {
        return (WebClientRequestPreparation)super.head(path);
    }

    @Override
    public WebClientRequestPreparation trace(String path) {
        return (WebClientRequestPreparation)super.trace(path);
    }

    @Override
    public WebClientRequestPreparation method(HttpMethod method) {
        return (WebClientRequestPreparation)super.method(method);
    }

    @Override
    public WebClientRequestPreparation path(String path) {
        return (WebClientRequestPreparation)super.path(path);
    }

    @Override
    public WebClientRequestPreparation content(String content) {
        return (WebClientRequestPreparation)super.content(content);
    }

    @Override
    public WebClientRequestPreparation content(MediaType contentType, CharSequence content) {
        return (WebClientRequestPreparation)super.content(contentType, content);
    }

    @Override
    public WebClientRequestPreparation content(MediaType contentType, String content) {
        return (WebClientRequestPreparation)super.content(contentType, content);
    }

    @Override
    @FormatMethod
    public WebClientRequestPreparation content(@FormatString String format, Object ... content) {
        return (WebClientRequestPreparation)super.content(format, content);
    }

    @Override
    @FormatMethod
    public WebClientRequestPreparation content(MediaType contentType, @FormatString String format, Object ... content) {
        return (WebClientRequestPreparation)super.content(contentType, format, content);
    }

    @Override
    public WebClientRequestPreparation content(MediaType contentType, byte[] content) {
        return (WebClientRequestPreparation)super.content(contentType, content);
    }

    @Override
    public WebClientRequestPreparation content(MediaType contentType, HttpData content) {
        return (WebClientRequestPreparation)super.content(contentType, content);
    }

    @Override
    public WebClientRequestPreparation content(MediaType contentType, Publisher<? extends HttpData> publisher) {
        return (WebClientRequestPreparation)super.content(contentType, (Publisher)publisher);
    }

    @Override
    public WebClientRequestPreparation contentJson(Object content) {
        return (WebClientRequestPreparation)super.contentJson(content);
    }

    @Override
    public WebClientRequestPreparation header(CharSequence name, Object value) {
        return (WebClientRequestPreparation)super.header(name, value);
    }

    @Override
    public WebClientRequestPreparation headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        return (WebClientRequestPreparation)super.headers((Iterable)headers);
    }

    @Override
    public WebClientRequestPreparation trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        return (WebClientRequestPreparation)super.trailers((Iterable)trailers);
    }

    @Override
    public WebClientRequestPreparation pathParam(String name, Object value) {
        return (WebClientRequestPreparation)super.pathParam(name, value);
    }

    @Override
    public WebClientRequestPreparation pathParams(Map<String, ?> pathParams) {
        return (WebClientRequestPreparation)super.pathParams((Map)pathParams);
    }

    @Override
    public WebClientRequestPreparation disablePathParams() {
        return (WebClientRequestPreparation)super.disablePathParams();
    }

    @Override
    public WebClientRequestPreparation queryParam(String name, Object value) {
        return (WebClientRequestPreparation)super.queryParam(name, value);
    }

    @Override
    public WebClientRequestPreparation queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        return (WebClientRequestPreparation)super.queryParams((Iterable)queryParams);
    }

    @Override
    public WebClientRequestPreparation cookie(Cookie cookie) {
        return (WebClientRequestPreparation)super.cookie(cookie);
    }

    @Override
    public WebClientRequestPreparation cookies(Iterable<? extends Cookie> cookies) {
        return (WebClientRequestPreparation)super.cookies((Iterable)cookies);
    }
}

