/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AggregatedHttpRequestHandler;
import com.linecorp.armeria.client.ClientHttp1ObjectEncoder;
import com.linecorp.armeria.client.ClientHttp2ObjectEncoder;
import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Http1ClientKeepAliveHandler;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpChannelPool;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpRequestSubscriber;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.common.Http2GoAwayHandler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpSessionHandler
extends ChannelDuplexHandler
implements HttpSession {
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);
    private static final AttributeKey<Throwable> PENDING_EXCEPTION = AttributeKey.valueOf(HttpSessionHandler.class, "PENDING_EXCEPTION");
    private final HttpChannelPool channelPool;
    private final Channel channel;
    private final SocketAddress remoteAddress;
    private final Promise<Channel> sessionPromise;
    private final ScheduledFuture<?> sessionTimeoutFuture;
    private final SessionProtocol desiredProtocol;
    private final HttpChannelPool.PoolKey poolKey;
    private final HttpClientFactory clientFactory;
    @Nullable
    private SocketAddress proxyDestinationAddress;
    private volatile boolean isAcquirable;
    @Nullable
    private SessionProtocol protocol;
    @Nullable
    private HttpResponseDecoder responseDecoder;
    @Nullable
    private ClientHttpObjectEncoder requestEncoder;
    private int maxUnfinishedResponses = Integer.MAX_VALUE;
    private int numRequestsSent;
    private boolean needsRetryWithH1C;

    HttpSessionHandler(HttpChannelPool channelPool, Channel channel, Promise<Channel> sessionPromise, ScheduledFuture<?> sessionTimeoutFuture, SessionProtocol desiredProtocol, HttpChannelPool.PoolKey poolKey, HttpClientFactory clientFactory) {
        this.channelPool = Objects.requireNonNull(channelPool, "channelPool");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.remoteAddress = channel.remoteAddress();
        this.sessionPromise = Objects.requireNonNull(sessionPromise, "sessionPromise");
        this.sessionTimeoutFuture = Objects.requireNonNull(sessionTimeoutFuture, "sessionTimeoutFuture");
        this.desiredProtocol = desiredProtocol;
        this.poolKey = poolKey;
        this.clientFactory = clientFactory;
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.inboundTrafficController();
    }

    @Override
    public boolean hasUnfinishedResponses() {
        if (this.responseDecoder == null) {
            return false;
        }
        return this.responseDecoder.hasUnfinishedResponses();
    }

    @Override
    public boolean incrementNumUnfinishedResponses() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.reserveUnfinishedResponse(this.maxUnfinishedResponses);
    }

    @Override
    public boolean canSendRequest() {
        assert (this.responseDecoder != null);
        if (!this.channel.isActive()) {
            return false;
        }
        if (this.responseDecoder instanceof Http2ResponseDecoder) {
            Http2GoAwayHandler goAwayHandler = ((Http2ResponseDecoder)this.responseDecoder).goAwayHandler();
            return !goAwayHandler.sentGoAway() && !goAwayHandler.receivedGoAway();
        }
        return this.isAcquirable();
    }

    @Override
    public void invoke(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        SafeCloseable ignored;
        if (this.handleEarlyCancellation(ctx, req, res)) {
            pooledChannel.release();
            return;
        }
        long writeTimeoutMillis = ctx.writeTimeoutMillis();
        assert (this.protocol != null);
        assert (this.responseDecoder != null);
        assert (this.requestEncoder != null);
        if (!this.protocol.isMultiplex()) {
            boolean useHttp1Pipelining = this.clientFactory.useHttp1Pipelining();
            CompletableFuture<Void> completionFuture = useHttp1Pipelining ? req.whenComplete() : CompletableFuture.allOf(req.whenComplete(), res.whenComplete());
            completionFuture.handle((ret, cause) -> {
                if (this.isAcquirable()) {
                    pooledChannel.release();
                }
                return null;
            });
        }
        if (ctx.exchangeType().isRequestStreaming()) {
            HttpRequestSubscriber reqSubscriber = new HttpRequestSubscriber(this.channel, this.requestEncoder, this.responseDecoder, req, res, ctx, writeTimeoutMillis);
            ignored = ctx.push();
            try {
                req.subscribe(reqSubscriber, this.channel.eventLoop(), SubscriptionOption.WITH_POOLED_OBJECTS);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        AggregatedHttpRequestHandler reqHandler = new AggregatedHttpRequestHandler(this.channel, this.requestEncoder, this.responseDecoder, req, res, ctx, writeTimeoutMillis);
        ignored = ctx.push();
        try {
            req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), this.channel.eventLoop())).handle((BiFunction)reqHandler);
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @Override
    public int incrementAndGetNumRequestsSent() {
        return ++this.numRequestsSent;
    }

    private boolean handleEarlyCancellation(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (res.isOpen()) {
            return false;
        }
        assert (this.responseDecoder != null);
        this.responseDecoder.decrementUnfinishedResponses();
        assert (this.protocol != null);
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            req.abort(CancelledSubscriptionException.get());
            ctx.logBuilder().session(this.channel, this.protocol, null);
            ctx.logBuilder().requestHeaders(req.headers());
            req.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endRequest();
                } else {
                    ctx.logBuilder().endRequest((Throwable)cause);
                }
                return null;
            });
            res.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endResponse();
                } else {
                    ctx.logBuilder().endResponse((Throwable)cause);
                }
                return null;
            });
        }
        return true;
    }

    @Override
    public void retryWithH1C() {
        this.needsRetryWithH1C = true;
    }

    @Override
    public boolean isAcquirable() {
        if (!this.isAcquirable) {
            return false;
        }
        assert (this.responseDecoder != null);
        KeepAliveHandler keepAliveHandler = this.responseDecoder.keepAliveHandler();
        assert (keepAliveHandler != null);
        return !keepAliveHandler.needsDisconnection();
    }

    @Override
    public void deactivate() {
        if (this.isAcquirable) {
            this.isAcquirable = false;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = this.channel.isActive();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = true;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2Settings) {
            Long maxConcurrentStreams = ((Http2Settings)msg).maxConcurrentStreams();
            this.maxUnfinishedResponses = maxConcurrentStreams != null ? (maxConcurrentStreams > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxConcurrentStreams.intValue()) : Integer.MAX_VALUE;
            return;
        }
        try {
            String typeInfo = msg instanceof ByteBuf ? msg + " HexDump: " + ByteBufUtil.hexDump((ByteBuf)msg) : String.valueOf(msg);
            throw new IllegalStateException("unexpected message type: " + typeInfo + " (expected: ByteBuf)");
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(msg);
            throw throwable;
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SessionProtocol) {
            SessionProtocol protocol;
            assert (this.protocol == null);
            assert (this.responseDecoder == null);
            this.sessionTimeoutFuture.cancel(false);
            this.protocol = protocol = (SessionProtocol)((Object)evt);
            if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
                KeepAliveHandler keepAliveHandler;
                int maxNumRequestsPerConnection;
                long maxConnectionAgeMillis;
                long pingIntervalMillis;
                Http1ResponseDecoder responseDecoder = ctx.pipeline().get(Http1ResponseDecoder.class);
                long idleTimeoutMillis = this.clientFactory.idleTimeoutMillis();
                boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis = this.clientFactory.pingIntervalMillis(), maxConnectionAgeMillis = this.clientFactory.maxConnectionAgeMillis(), maxNumRequestsPerConnection = this.clientFactory.maxNumRequestsPerConnection());
                if (needsKeepAliveHandler) {
                    Timer keepAliveTimer = MoreMeters.newTimer(this.clientFactory.meterRegistry(), "armeria.client.connections.lifespan", ImmutableList.of(Tag.of("protocol", protocol.uriText())));
                    keepAliveHandler = new Http1ClientKeepAliveHandler(this.channel, responseDecoder, keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection);
                } else {
                    keepAliveHandler = new NoopKeepAliveHandler();
                }
                ClientHttp1ObjectEncoder requestEncoder = new ClientHttp1ObjectEncoder(this.channel, protocol, this.clientFactory.http1HeaderNaming(), keepAliveHandler);
                if (keepAliveHandler instanceof Http1ClientKeepAliveHandler) {
                    ((Http1ClientKeepAliveHandler)keepAliveHandler).setEncoder(requestEncoder);
                }
                responseDecoder.setKeepAliveHandler(ctx, keepAliveHandler);
                this.requestEncoder = requestEncoder;
                this.responseDecoder = responseDecoder;
            } else if (protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) {
                ChannelHandlerContext connectionHandlerCtx = ctx.pipeline().context(Http2ClientConnectionHandler.class);
                Http2ClientConnectionHandler connectionHandler = (Http2ClientConnectionHandler)connectionHandlerCtx.handler();
                this.requestEncoder = new ClientHttp2ObjectEncoder(connectionHandlerCtx, connectionHandler, protocol);
                this.responseDecoder = connectionHandler.responseDecoder();
            } else {
                throw new Error();
            }
            if (this.poolKey.proxyConfig.proxyType() != ProxyType.DIRECT) {
                if (this.proxyDestinationAddress != null) {
                    this.tryCompleteSessionPromise(ctx);
                }
            } else {
                this.tryCompleteSessionPromise(ctx);
            }
            return;
        }
        if (evt instanceof SessionProtocolNegotiationException || evt instanceof ProxyConnectException) {
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)evt);
            ctx.close();
            return;
        }
        if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent || evt instanceof SslHandshakeCompletionEvent || evt instanceof SslCloseCompletionEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        if (evt instanceof ProxyConnectionEvent) {
            this.proxyDestinationAddress = ((ProxyConnectionEvent)evt).destinationAddress();
            if (this.protocol != null) {
                this.tryCompleteSessionPromise(ctx);
            }
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)this.channel, evt);
    }

    private void tryCompleteSessionPromise(ChannelHandlerContext ctx) {
        if (!this.sessionPromise.trySuccess(this.channel)) {
            ctx.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = false;
        if (this.needsRetryWithH1C) {
            assert (this.responseDecoder == null || !this.responseDecoder.hasUnfinishedResponses());
            this.sessionTimeoutFuture.cancel(false);
            if (this.proxyDestinationAddress != null) {
                this.channelPool.connect(this.proxyDestinationAddress, SessionProtocol.H1C, this.poolKey, this.sessionPromise);
            } else {
                this.channelPool.connect(this.remoteAddress, SessionProtocol.H1C, this.poolKey, this.sessionPromise);
            }
        } else {
            Throwable pendingException;
            HttpResponseDecoder responseDecoder = this.responseDecoder;
            if (responseDecoder != null && responseDecoder.hasUnfinishedResponses()) {
                pendingException = HttpSessionHandler.getPendingException(ctx);
                responseDecoder.failUnfinishedResponses(pendingException);
            } else {
                pendingException = null;
            }
            this.sessionTimeoutFuture.cancel(false);
            if (!this.sessionPromise.isDone()) {
                this.sessionPromise.tryFailure(pendingException != null ? pendingException : HttpSessionHandler.getPendingException(ctx));
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ProxyConnectException) {
            SessionProtocol protocol = this.protocol != null ? this.protocol : this.desiredProtocol;
            UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
            this.channelPool.maybeHandleProxyFailure(protocol, this.poolKey, wrapped);
            this.sessionPromise.tryFailure(wrapped);
            return;
        }
        HttpSessionHandler.setPendingException(ctx, new ClosedSessionException(cause));
        if (!(cause instanceof IOException)) {
            ctx.close();
        }
    }

    private static Throwable getPendingException(ChannelHandlerContext ctx) {
        if (ctx.channel().hasAttr(PENDING_EXCEPTION)) {
            return ctx.channel().attr(PENDING_EXCEPTION).get();
        }
        return ClosedSessionException.get();
    }

    static void setPendingException(ChannelHandlerContext ctx, Throwable cause) {
        Throwable previousCause = ctx.channel().attr(PENDING_EXCEPTION).setIfAbsent(cause);
        if (previousCause != null && logger.isWarnEnabled()) {
            logger.warn("{} Unexpected suppressed exception:", (Object)ctx.channel(), (Object)cause);
        }
    }
}

