/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractDnsResolverBuilder;
import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.client.RefreshingAddressResolverGroup;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.ToLongFunction;

public final class DnsResolverGroupBuilder
extends AbstractDnsResolverBuilder {
    static final ToLongFunction<String> DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION = hostname -> Long.MAX_VALUE;
    @Nullable
    private ResolvedAddressTypes resolvedAddressTypes;
    private boolean autoRefresh = true;
    @Nullable
    private Backoff autoRefreshBackoff;
    @Nullable
    private ToLongFunction<String> autoRefreshTimeoutFunction;

    DnsResolverGroupBuilder() {
    }

    @Deprecated
    public DnsResolverGroupBuilder refreshBackoff(Backoff refreshBackoff) {
        return this.autoRefreshBackoff(refreshBackoff);
    }

    public DnsResolverGroupBuilder resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
        this.resolvedAddressTypes = Objects.requireNonNull(resolvedAddressTypes, "resolvedAddressTypes");
        return this;
    }

    public DnsResolverGroupBuilder enableAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        return this;
    }

    public DnsResolverGroupBuilder autoRefreshBackoff(Backoff refreshBackoff) {
        this.autoRefreshBackoff = Objects.requireNonNull(refreshBackoff, "refreshBackoff");
        return this;
    }

    public DnsResolverGroupBuilder autoRefreshTimeout(ToLongFunction<? super String> timeoutFunction) {
        Objects.requireNonNull(timeoutFunction, "timeoutFunction");
        this.autoRefreshTimeoutFunction = timeoutFunction;
        return this;
    }

    public DnsResolverGroupBuilder autoRefreshTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.autoRefreshTimeoutMillis(timeout.toMillis());
    }

    public DnsResolverGroupBuilder autoRefreshTimeoutMillis(long timeoutMillis) {
        Preconditions.checkArgument(timeoutMillis >= 0L, "timeoutMillis: %s (expected: >= 0)", timeoutMillis);
        long adjustedTimeoutMillis = timeoutMillis == 0L ? Long.MAX_VALUE : timeoutMillis;
        return this.autoRefreshTimeout((? super String hostname) -> adjustedTimeoutMillis);
    }

    @Nullable
    MeterRegistry meterRegistry0() {
        return this.meterRegistry();
    }

    RefreshingAddressResolverGroup build(EventLoopGroup eventLoopGroup) {
        ToLongFunction<String> autoRefreshTimeoutFunction = this.autoRefreshTimeoutFunction;
        Backoff autoRefreshBackoff = this.autoRefreshBackoff;
        if (!(this.autoRefresh || autoRefreshTimeoutFunction == null && autoRefreshBackoff == null)) {
            throw new IllegalStateException("Can't set 'autoRefreshTimeout()' or 'autoRefreshBackoff()' if 'autoRefresh' is disabled");
        }
        if (this.autoRefresh) {
            if (autoRefreshTimeoutFunction == null) {
                autoRefreshTimeoutFunction = DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION;
            }
            if (autoRefreshBackoff == null) {
                autoRefreshBackoff = Backoff.ofDefault();
            }
        }
        return new RefreshingAddressResolverGroup(this.cacheSpec(), this.negativeTtl(), this.resolvedAddressTypes, this.maybeCreateDnsCache(), this.autoRefresh, autoRefreshBackoff, autoRefreshTimeoutFunction, this.searchDomains(), this.ndots(), this.queryTimeoutMillis(), this.hostsFileEntriesResolver(), this.buildConfigurator(eventLoopGroup));
    }

    @Override
    public DnsResolverGroupBuilder traceEnabled(boolean traceEnabled) {
        return (DnsResolverGroupBuilder)super.traceEnabled(traceEnabled);
    }

    @Override
    public DnsResolverGroupBuilder queryTimeout(Duration queryTimeout) {
        return (DnsResolverGroupBuilder)super.queryTimeout(queryTimeout);
    }

    @Override
    public DnsResolverGroupBuilder queryTimeoutMillis(long queryTimeoutMillis) {
        return (DnsResolverGroupBuilder)super.queryTimeoutMillis(queryTimeoutMillis);
    }

    @Override
    public DnsResolverGroupBuilder queryTimeoutForEachAttempt(Duration queryTimeoutForEachAttempt) {
        return (DnsResolverGroupBuilder)super.queryTimeoutForEachAttempt(queryTimeoutForEachAttempt);
    }

    @Override
    public DnsResolverGroupBuilder queryTimeoutMillisForEachAttempt(long queryTimeoutMillisForEachAttempt) {
        return (DnsResolverGroupBuilder)super.queryTimeoutMillisForEachAttempt(queryTimeoutMillisForEachAttempt);
    }

    @Override
    public DnsResolverGroupBuilder recursionDesired(boolean recursionDesired) {
        return (DnsResolverGroupBuilder)super.recursionDesired(recursionDesired);
    }

    @Override
    public DnsResolverGroupBuilder maxQueriesPerResolve(int maxQueriesPerResolve) {
        return (DnsResolverGroupBuilder)super.maxQueriesPerResolve(maxQueriesPerResolve);
    }

    @Override
    public DnsResolverGroupBuilder serverAddresses(InetSocketAddress ... serverAddresses) {
        return (DnsResolverGroupBuilder)super.serverAddresses(serverAddresses);
    }

    @Override
    public DnsResolverGroupBuilder serverAddresses(Iterable<InetSocketAddress> serverAddresses) {
        return (DnsResolverGroupBuilder)super.serverAddresses(serverAddresses);
    }

    @Override
    public DnsResolverGroupBuilder serverAddressStreamProvider(DnsServerAddressStreamProvider serverAddressStreamProvider) {
        return (DnsResolverGroupBuilder)super.serverAddressStreamProvider(serverAddressStreamProvider);
    }

    @Override
    @Deprecated
    public DnsResolverGroupBuilder dnsServerAddressStreamProvider(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        return (DnsResolverGroupBuilder)super.dnsServerAddressStreamProvider(dnsServerAddressStreamProvider);
    }

    @Override
    public DnsResolverGroupBuilder maxPayloadSize(int maxPayloadSize) {
        return (DnsResolverGroupBuilder)super.maxPayloadSize(maxPayloadSize);
    }

    @Override
    public DnsResolverGroupBuilder optResourceEnabled(boolean optResourceEnabled) {
        return (DnsResolverGroupBuilder)super.optResourceEnabled(optResourceEnabled);
    }

    @Override
    public DnsResolverGroupBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        return (DnsResolverGroupBuilder)super.hostsFileEntriesResolver(hostsFileEntriesResolver);
    }

    @Override
    public DnsResolverGroupBuilder dnsQueryLifecycleObserverFactory(DnsQueryLifecycleObserverFactory observerFactory) {
        return (DnsResolverGroupBuilder)super.dnsQueryLifecycleObserverFactory(observerFactory);
    }

    @Override
    @Deprecated
    public DnsResolverGroupBuilder disableDnsQueryMetrics() {
        return (DnsResolverGroupBuilder)super.disableDnsQueryMetrics();
    }

    @Override
    public DnsResolverGroupBuilder searchDomains(String ... searchDomains) {
        return (DnsResolverGroupBuilder)super.searchDomains(searchDomains);
    }

    @Override
    public DnsResolverGroupBuilder searchDomains(Iterable<String> searchDomains) {
        return (DnsResolverGroupBuilder)super.searchDomains(searchDomains);
    }

    @Override
    public DnsResolverGroupBuilder ndots(int ndots) {
        return (DnsResolverGroupBuilder)super.ndots(ndots);
    }

    @Override
    public DnsResolverGroupBuilder decodeIdn(boolean decodeIdn) {
        return (DnsResolverGroupBuilder)super.decodeIdn(decodeIdn);
    }

    @Override
    public DnsResolverGroupBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (DnsResolverGroupBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public DnsResolverGroupBuilder cacheSpec(String cacheSpec) {
        return (DnsResolverGroupBuilder)super.cacheSpec(cacheSpec);
    }

    @Override
    public DnsResolverGroupBuilder ttl(int minTtl, int maxTtl) {
        return (DnsResolverGroupBuilder)super.ttl(minTtl, maxTtl);
    }

    @Override
    public DnsResolverGroupBuilder negativeTtl(int negativeTtl) {
        return (DnsResolverGroupBuilder)super.negativeTtl(negativeTtl);
    }

    @Override
    public DnsResolverGroupBuilder dnsCache(DnsCache dnsCache) {
        return (DnsResolverGroupBuilder)super.dnsCache(dnsCache);
    }
}

