/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public enum KubernetesEndpoints {
    INSTANCE;

    private final LoadingCache<KubernetesEndpoints, List<Endpoints>> endpoints;

    private KubernetesEndpoints() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(3L));
        this.endpoints = cacheBuilder.build(CacheLoader.from(() -> {
            List list;
            block8: {
                KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
                try {
                    list = ((EndpointsList)((AnyNamespaceOperation)kubernetesClient.endpoints().inAnyNamespace()).list()).getItems();
                    if (kubernetesClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (kubernetesClient != null) {
                            try {
                                kubernetesClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Failed to list Endpoints.", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                kubernetesClient.close();
            }
            return list;
        }));
    }

    public List<Endpoints> list() {
        return (List)this.endpoints.get((Object)this);
    }
}

