/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.source.Log;
import org.apache.skywalking.restapi.TagGenerator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public final class LogRequest
implements Generator<Log> {
    @JsonIgnore
    private final ObjectMapper om = new ObjectMapper();
    private Generator<Long> timestamp;
    private Generator<String> serviceName;
    private Generator<String> serviceInstanceName;
    private Generator<String> endpointName;
    private Generator<String> traceId;
    private Generator<String> traceSegmentId;
    private Generator<Long> spanId;
    private Generator<Long> contentType;
    private Generator<String> content;
    private Generator<List<TagGenerator>> tags;
    private Generator<Boolean> error;

    @Override
    public Log next() {
        Log log = new Log();
        log.setTimestamp(this.getTimestamp().next().longValue());
        log.setServiceId(IDManager.ServiceID.buildId((String)this.getServiceName().next(), (boolean)true));
        log.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)log.getServiceId(), (String)this.getServiceInstanceName().next()));
        log.setEndpointId(IDManager.EndpointID.buildId((String)log.getServiceId(), (String)this.getEndpointName().next()));
        log.setTraceId(this.getTraceId().next());
        log.setTraceSegmentId(this.getTraceSegmentId().next());
        log.setSpanId(this.getSpanId().next().intValue());
        log.setContentType(ContentType.instanceOf((int)this.getContentType().next().intValue()));
        log.setContent(this.getContent().next());
        log.setError(this.getError().next().booleanValue());
        log.setTimeBucket(TimeBucket.getRecordTimeBucket((long)log.getTimestamp()));
        log.setTags(this.getTags().next().stream().map(TagGenerator::next).collect(Collectors.toList()));
        log.setTagsRawData(LogTags.newBuilder().addAllData((Iterable)log.getTags().stream().map(it -> KeyStringValuePair.newBuilder().setKey(it.getKey()).setValue(it.getValue()).build()).collect(Collectors.toList())).build().toByteArray());
        log.setUniqueId(UUID.randomUUID().toString());
        return log;
    }

    @Generated
    public LogRequest() {
    }

    @Generated
    public ObjectMapper getOm() {
        return this.om;
    }

    @Generated
    public Generator<Long> getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Generator<String> getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Generator<String> getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public Generator<String> getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public Generator<String> getTraceId() {
        return this.traceId;
    }

    @Generated
    public Generator<String> getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public Generator<Long> getSpanId() {
        return this.spanId;
    }

    @Generated
    public Generator<Long> getContentType() {
        return this.contentType;
    }

    @Generated
    public Generator<String> getContent() {
        return this.content;
    }

    @Generated
    public Generator<List<TagGenerator>> getTags() {
        return this.tags;
    }

    @Generated
    public Generator<Boolean> getError() {
        return this.error;
    }

    @Generated
    public void setTimestamp(Generator<Long> timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setServiceName(Generator<String> serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(Generator<String> serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setEndpointName(Generator<String> endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setTraceId(Generator<String> traceId) {
        this.traceId = traceId;
    }

    @Generated
    public void setTraceSegmentId(Generator<String> traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    public void setSpanId(Generator<Long> spanId) {
        this.spanId = spanId;
    }

    @Generated
    public void setContentType(Generator<Long> contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setContent(Generator<String> content) {
        this.content = content;
    }

    @Generated
    public void setTags(Generator<List<TagGenerator>> tags) {
        this.tags = tags;
    }

    @Generated
    public void setError(Generator<Boolean> error) {
        this.error = error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRequest)) {
            return false;
        }
        LogRequest other = (LogRequest)o;
        ObjectMapper this$om = this.getOm();
        ObjectMapper other$om = other.getOm();
        if (this$om == null ? other$om != null : !this$om.equals(other$om)) {
            return false;
        }
        Generator<Long> this$timestamp = this.getTimestamp();
        Generator<Long> other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        Generator<String> this$serviceName = this.getServiceName();
        Generator<String> other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        Generator<String> this$serviceInstanceName = this.getServiceInstanceName();
        Generator<String> other$serviceInstanceName = other.getServiceInstanceName();
        if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
            return false;
        }
        Generator<String> this$endpointName = this.getEndpointName();
        Generator<String> other$endpointName = other.getEndpointName();
        if (this$endpointName == null ? other$endpointName != null : !this$endpointName.equals(other$endpointName)) {
            return false;
        }
        Generator<String> this$traceId = this.getTraceId();
        Generator<String> other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Generator<String> this$traceSegmentId = this.getTraceSegmentId();
        Generator<String> other$traceSegmentId = other.getTraceSegmentId();
        if (this$traceSegmentId == null ? other$traceSegmentId != null : !this$traceSegmentId.equals(other$traceSegmentId)) {
            return false;
        }
        Generator<Long> this$spanId = this.getSpanId();
        Generator<Long> other$spanId = other.getSpanId();
        if (this$spanId == null ? other$spanId != null : !this$spanId.equals(other$spanId)) {
            return false;
        }
        Generator<Long> this$contentType = this.getContentType();
        Generator<Long> other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Generator<String> this$content = this.getContent();
        Generator<String> other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Generator<List<TagGenerator>> this$tags = this.getTags();
        Generator<List<TagGenerator>> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        Generator<Boolean> this$error = this.getError();
        Generator<Boolean> other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $om = this.getOm();
        result = result * 59 + ($om == null ? 43 : $om.hashCode());
        Generator<Long> $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        Generator<String> $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        Generator<String> $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        Generator<String> $endpointName = this.getEndpointName();
        result = result * 59 + ($endpointName == null ? 43 : $endpointName.hashCode());
        Generator<String> $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Generator<String> $traceSegmentId = this.getTraceSegmentId();
        result = result * 59 + ($traceSegmentId == null ? 43 : $traceSegmentId.hashCode());
        Generator<Long> $spanId = this.getSpanId();
        result = result * 59 + ($spanId == null ? 43 : $spanId.hashCode());
        Generator<Long> $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Generator<String> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Generator<List<TagGenerator>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        Generator<Boolean> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogRequest(om=" + this.getOm() + ", timestamp=" + this.getTimestamp() + ", serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", endpointName=" + this.getEndpointName() + ", traceId=" + this.getTraceId() + ", traceSegmentId=" + this.getTraceSegmentId() + ", spanId=" + this.getSpanId() + ", contentType=" + this.getContentType() + ", content=" + this.getContent() + ", tags=" + this.getTags() + ", error=" + this.getError() + ")";
    }
}

