/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.slack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackhookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackhookCallback.class);
    private static final Gson GSON = new Gson();
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        if (this.alarmRulesWatcher.getSlackSettings() == null || this.alarmRulesWatcher.getSlackSettings().getWebhooks().isEmpty()) {
            return;
        }
        for (String url : this.alarmRulesWatcher.getSlackSettings().getWebhooks()) {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonElements = new JsonArray();
            for (AlarmMessage item : alarmMessages) {
                jsonElements.add((JsonElement)GSON.fromJson(String.format(this.alarmRulesWatcher.getSlackSettings().getTextTemplate(), item.getAlarmMessage()), JsonObject.class));
            }
            jsonObject.add("blocks", (JsonElement)jsonElements);
            String body = GSON.toJson((JsonElement)jsonObject);
            this.post(URI.create(url), body, Map.of());
        }
    }

    @Generated
    public SlackhookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

