/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.discord;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordHookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscordHookCallback.class);
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        DiscordSettings discordSettings = this.alarmRulesWatcher.getDiscordSettings();
        if (discordSettings == null || discordSettings.getWebhooks().isEmpty()) {
            return;
        }
        for (DiscordSettings.WebHookUrl webHookUrl : discordSettings.getWebhooks()) {
            for (AlarmMessage alarmMessage : alarmMessages) {
                String content = String.format(discordSettings.getTextTemplate(), alarmMessage.getAlarmMessage());
                this.sendAlarmMessage(webHookUrl, content);
            }
        }
    }

    private void sendAlarmMessage(DiscordSettings.WebHookUrl webHookUrl, String content) throws IOException, InterruptedException {
        JsonObject body = new JsonObject();
        body.addProperty("username", webHookUrl.getUsername());
        body.addProperty("content", content);
        String requestBody = body.toString();
        this.post(URI.create(webHookUrl.getUrl()), requestBody, Map.of());
    }

    @Generated
    public DiscordHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

