/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.CompositeAlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.dingtalk.DingtalkSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.core.alarm.provider.pagerduty.PagerDutySettings;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.wechat.WechatSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class RulesReader {
    private Map yamlData;

    public RulesReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public RulesReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.yamlData = (Map)yaml.load(io);
    }

    public Rules readRules() {
        Rules rules = new Rules();
        if (Objects.nonNull(this.yamlData)) {
            this.readRulesConfig(rules);
            this.readWebHookConfig(rules);
            this.readGrpcConfig(rules);
            this.readSlackConfig(rules);
            this.readWechatConfig(rules);
            this.readCompositeRuleConfig(rules);
            this.readDingtalkConfig(rules);
            this.readFeishuConfig(rules);
            this.readWeLinkConfig(rules);
            this.readPagerDutyConfig(rules);
            this.readDiscordConfig(rules);
        }
        return rules;
    }

    private void readRulesConfig(Rules rules) {
        Map rulesData = (Map)this.yamlData.get("rules");
        if (rulesData == null) {
            return;
        }
        rules.setRules(new ArrayList<AlarmRule>());
        rulesData.forEach((k, v) -> {
            if (((String)k).endsWith("_rule")) {
                AlarmRule alarmRule = new AlarmRule();
                alarmRule.setAlarmRuleName((String)k);
                Map settings = (Map)v;
                Object metricsName = settings.get("metrics-name");
                if (metricsName == null) {
                    throw new IllegalArgumentException("metrics-name can't be null");
                }
                alarmRule.setMetricsName((String)metricsName);
                alarmRule.setIncludeNames(settings.getOrDefault("include-names", new ArrayList(0)));
                alarmRule.setExcludeNames(settings.getOrDefault("exclude-names", new ArrayList(0)));
                alarmRule.setIncludeNamesRegex(settings.getOrDefault("include-names-regex", ""));
                alarmRule.setExcludeNamesRegex(settings.getOrDefault("exclude-names-regex", ""));
                alarmRule.setIncludeLabels(settings.getOrDefault("include-labels", new ArrayList(0)));
                alarmRule.setExcludeLabels(settings.getOrDefault("exclude-labels", new ArrayList(0)));
                alarmRule.setIncludeLabelsRegex(settings.getOrDefault("include-labels-regex", ""));
                alarmRule.setExcludeLabelsRegex(settings.getOrDefault("exclude-labels-regex", ""));
                alarmRule.setThreshold(settings.get("threshold").toString());
                alarmRule.setOp((String)settings.get("op"));
                alarmRule.setPeriod(settings.getOrDefault("period", 1));
                alarmRule.setCount(settings.getOrDefault("count", 1));
                alarmRule.setSilencePeriod(settings.getOrDefault("silence-period", alarmRule.getPeriod()));
                alarmRule.setOnlyAsCondition(settings.getOrDefault("only-as-condition", false));
                alarmRule.setMessage((String)((Object)settings.getOrDefault("message", "Alarm caused by Rule " + alarmRule.getAlarmRuleName())));
                alarmRule.setTags(settings.getOrDefault("tags", new HashMap()));
                rules.getRules().add(alarmRule);
            }
        });
    }

    private void readWebHookConfig(Rules rules) {
        List webhooks = (List)this.yamlData.get("webhooks");
        if (webhooks != null) {
            rules.setWebhooks(new ArrayList<String>());
            webhooks.forEach(url -> rules.getWebhooks().add((String)url));
        }
    }

    private void readGrpcConfig(Rules rules) {
        Map grpchooks = (Map)this.yamlData.get("gRPCHook");
        if (grpchooks != null) {
            Object targetPort;
            GRPCAlarmSetting grpcAlarmSetting = new GRPCAlarmSetting();
            Object targetHost = grpchooks.get("target_host");
            if (targetHost != null) {
                grpcAlarmSetting.setTargetHost((String)targetHost);
            }
            if ((targetPort = grpchooks.get("target_port")) != null) {
                grpcAlarmSetting.setTargetPort((Integer)targetPort);
            }
            rules.setGrpchookSetting(grpcAlarmSetting);
        }
    }

    private void readSlackConfig(Rules rules) {
        Map slacks = (Map)this.yamlData.get("slackHooks");
        if (slacks != null) {
            SlackSettings slackSettings = new SlackSettings();
            String textTemplate = slacks.getOrDefault("textTemplate", "");
            slackSettings.setTextTemplate(textTemplate);
            List slackWebhooks = (List)slacks.get("webhooks");
            if (slackWebhooks != null) {
                slackSettings.getWebhooks().addAll(slackWebhooks);
            }
            rules.setSlacks(slackSettings);
        }
    }

    private void readWechatConfig(Rules rules) {
        Map wechatConfig = (Map)this.yamlData.get("wechatHooks");
        if (wechatConfig != null) {
            WechatSettings wechatSettings = new WechatSettings();
            String textTemplate = wechatConfig.getOrDefault("textTemplate", "");
            wechatSettings.setTextTemplate(textTemplate);
            List wechatWebhooks = (List)wechatConfig.get("webhooks");
            if (wechatWebhooks != null) {
                wechatSettings.getWebhooks().addAll(wechatWebhooks);
            }
            rules.setWecchats(wechatSettings);
        }
    }

    private void readCompositeRuleConfig(Rules rules) {
        Map compositeRulesData = (Map)this.yamlData.get("composite-rules");
        if (compositeRulesData == null) {
            return;
        }
        compositeRulesData.forEach((k, v) -> {
            String ruleName = (String)k;
            if (ruleName.endsWith("_rule")) {
                Map settings = (Map)v;
                CompositeAlarmRule compositeAlarmRule = new CompositeAlarmRule();
                compositeAlarmRule.setAlarmRuleName(ruleName);
                String expression = (String)settings.get("expression");
                if (expression == null) {
                    throw new IllegalArgumentException("expression can't be null");
                }
                compositeAlarmRule.setExpression(expression);
                compositeAlarmRule.setMessage((String)((Object)settings.getOrDefault("message", "Alarm caused by Rule " + ruleName)));
                compositeAlarmRule.setTags(settings.getOrDefault("tags", new HashMap(0)));
                rules.getCompositeRules().add(compositeAlarmRule);
            }
        });
    }

    private void readDingtalkConfig(Rules rules) {
        Map dingtalkConfig = (Map)this.yamlData.get("dingtalkHooks");
        if (dingtalkConfig != null) {
            DingtalkSettings dingtalkSettings = new DingtalkSettings();
            String textTemplate = dingtalkConfig.getOrDefault("textTemplate", "");
            dingtalkSettings.setTextTemplate(textTemplate);
            List wechatWebhooks = (List)dingtalkConfig.get("webhooks");
            if (wechatWebhooks != null) {
                wechatWebhooks.forEach(wechatWebhook -> {
                    String secret = wechatWebhook.getOrDefault("secret", "");
                    String url = wechatWebhook.getOrDefault("url", "");
                    dingtalkSettings.getWebhooks().add(new DingtalkSettings.WebHookUrl(secret, url));
                });
            }
            rules.setDingtalks(dingtalkSettings);
        }
    }

    private void readFeishuConfig(Rules rules) {
        Map feishuConfig = (Map)this.yamlData.get("feishuHooks");
        if (feishuConfig != null) {
            FeishuSettings feishuSettings = new FeishuSettings();
            String textTemplate = feishuConfig.getOrDefault("textTemplate", "");
            feishuSettings.setTextTemplate(textTemplate);
            List wechatWebhooks = (List)feishuConfig.get("webhooks");
            if (wechatWebhooks != null) {
                wechatWebhooks.forEach(wechatWebhook -> {
                    String secret = wechatWebhook.getOrDefault("secret", "");
                    String url = wechatWebhook.getOrDefault("url", "");
                    feishuSettings.getWebhooks().add(new FeishuSettings.WebHookUrl(secret, url));
                });
            }
            rules.setFeishus(feishuSettings);
        }
    }

    private void readWeLinkConfig(Rules rules) {
        Map welinkConfig = this.yamlData.getOrDefault("welinkHooks", Collections.EMPTY_MAP);
        String textTemplate = (String)welinkConfig.get("textTemplate");
        List welinkWebHooks = (List)welinkConfig.get("webhooks");
        if (StringUtil.isBlank((String)textTemplate) || CollectionUtils.isEmpty((List)welinkWebHooks)) {
            return;
        }
        List<WeLinkSettings.WebHookUrl> webHookUrls = welinkWebHooks.stream().map(WeLinkSettings.WebHookUrl::generateFromMap).collect(Collectors.toList());
        WeLinkSettings welinkSettings = new WeLinkSettings();
        welinkSettings.setTextTemplate(textTemplate);
        welinkSettings.setWebhooks(webHookUrls);
        rules.setWelinks(welinkSettings);
    }

    private void readPagerDutyConfig(Rules rules) {
        Map pagerDutyConfig = (Map)this.yamlData.get("pagerDutyHooks");
        if (pagerDutyConfig != null) {
            PagerDutySettings pagerDutySettings = new PagerDutySettings();
            String textTemplate = pagerDutyConfig.getOrDefault("textTemplate", "");
            pagerDutySettings.setTextTemplate(textTemplate);
            List integrationKeys = (List)pagerDutyConfig.get("integrationKeys");
            if (integrationKeys != null) {
                pagerDutySettings.getIntegrationKeys().addAll(integrationKeys);
            }
            rules.setPagerDutySettings(pagerDutySettings);
        }
    }

    private void readDiscordConfig(Rules rules) {
        Map discordConfig = this.yamlData.getOrDefault("discordHooks", Collections.EMPTY_MAP);
        String textTemplate = (String)discordConfig.get("textTemplate");
        List discordWebHooks = (List)discordConfig.get("webhooks");
        if (StringUtil.isBlank((String)textTemplate) || CollectionUtils.isEmpty((List)discordWebHooks)) {
            return;
        }
        List<DiscordSettings.WebHookUrl> webHookUrls = discordWebHooks.stream().map(DiscordSettings.WebHookUrl::generateFromMap).collect(Collectors.toList());
        DiscordSettings discordSettings = new DiscordSettings();
        discordSettings.setTextTemplate(textTemplate);
        discordSettings.setWebhooks(webHookUrls);
        rules.setDiscordSettings(discordSettings);
    }
}

