/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.Objects;

public enum OP {
    GT{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() > Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    GTE{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() >= Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    LT{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() < Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    LTE{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() <= Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    EQ{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() == Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    NEQ{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() != Objects.requireNonNull(expected, "expected").doubleValue();
        }
    };


    public static OP get(String op) {
        switch (op) {
            case ">": {
                return GT;
            }
            case ">=": {
                return GTE;
            }
            case "<": {
                return LT;
            }
            case "<=": {
                return LTE;
            }
            case "==": {
                return EQ;
            }
            case "!=": {
                return NEQ;
            }
        }
        throw new IllegalArgumentException("unknown op, " + op);
    }

    public abstract boolean test(Number var1, Number var2);
}

