/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmMessageFormatter;
import org.apache.skywalking.oap.server.core.alarm.provider.CompositeAlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.expression.Expression;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;

public class CompositeRuleEvaluator {
    private Expression expression;
    private Map<String, AlarmMessageFormatter> messageFormatterCache;

    public CompositeRuleEvaluator(Expression expression) {
        this.expression = expression;
        this.messageFormatterCache = new ConcurrentHashMap<String, AlarmMessageFormatter>();
    }

    public List<AlarmMessage> evaluate(List<CompositeAlarmRule> compositeAlarmRules, List<AlarmMessage> alarmMessages) {
        ArrayList<AlarmMessage> compositeRuleMessages = new ArrayList<AlarmMessage>();
        ImmutableListMultimap messageMap = Multimaps.index(alarmMessages, alarmMessage -> Joiner.on((String)"_").useForNull("").join((Object)alarmMessage.getId0(), (Object)alarmMessage.getId1(), new Object[0]));
        for (CompositeAlarmRule compositeAlarmRule : compositeAlarmRules) {
            String expr = compositeAlarmRule.getExpression();
            Set<String> dependencyRules = this.expression.analysisInputs(expr);
            HashMap dataContext = new HashMap();
            messageMap.asMap().forEach((key, alarmMessageList) -> {
                dependencyRules.forEach(ruleName -> dataContext.put(ruleName, false));
                alarmMessageList.forEach(alarmMessage -> {
                    if (dependencyRules.contains(alarmMessage.getRuleName())) {
                        dataContext.put(alarmMessage.getRuleName(), true);
                    }
                });
                Object matched = this.expression.eval(expr, dataContext);
                if (matched instanceof Boolean && ((Boolean)matched).booleanValue()) {
                    AlarmMessage headMsg = (AlarmMessage)alarmMessageList.iterator().next();
                    AlarmMessage message = new AlarmMessage();
                    message.setOnlyAsCondition(false);
                    message.setScopeId(headMsg.getScopeId());
                    message.setScope(headMsg.getScope());
                    message.setName(headMsg.getName());
                    message.setId0(headMsg.getId0());
                    message.setId1(headMsg.getId1());
                    message.setStartTime(System.currentTimeMillis());
                    message.setRuleName(compositeAlarmRule.getAlarmRuleName());
                    String alarmMessage2 = this.formatMessage(message, compositeAlarmRule.getMessage(), compositeAlarmRule.getExpression());
                    message.setAlarmMessage(alarmMessage2);
                    message.setPeriod(headMsg.getPeriod());
                    message.setTags(compositeAlarmRule.getTags().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
                    compositeRuleMessages.add(message);
                }
            });
        }
        return compositeRuleMessages;
    }

    private String formatMessage(final AlarmMessage alarmMessage, String message, final String metricName) {
        return this.messageFormatterCache.computeIfAbsent(message, AlarmMessageFormatter::new).format(new MetaInAlarm(){

            public String getScope() {
                return alarmMessage.getScope();
            }

            public int getScopeId() {
                return alarmMessage.getScopeId();
            }

            public String getName() {
                return alarmMessage.getName();
            }

            public String getMetricsName() {
                return metricName;
            }

            public String getId0() {
                return alarmMessage.getId0();
            }

            public String getId1() {
                return alarmMessage.getId1();
            }
        });
    }
}

