/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmCore.class);
    private LocalDateTime lastExecuteTime;
    private AlarmRulesWatcher alarmRulesWatcher;

    AlarmCore(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }

    public List<RunningRule> findRunningRule(String metricsName) {
        return this.alarmRulesWatcher.getRunningContext().get(metricsName);
    }

    public void start(List<AlarmCallback> allCallbacks) {
        LocalDateTime now;
        this.lastExecuteTime = now = LocalDateTime.now();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                ArrayList<AlarmMessage> alarmMessageList = new ArrayList<AlarmMessage>(30);
                LocalDateTime checkTime = LocalDateTime.now();
                int minutes = Minutes.minutesBetween((ReadablePartial)this.lastExecuteTime, (ReadablePartial)checkTime).getMinutes();
                boolean[] hasExecute = new boolean[]{false};
                this.alarmRulesWatcher.getRunningContext().values().forEach(ruleList -> ruleList.forEach(runningRule -> {
                    if (minutes > 0) {
                        runningRule.moveTo(checkTime);
                        if (checkTime.getSecondOfMinute() > 15) {
                            hasExecute[0] = true;
                            alarmMessageList.addAll(runningRule.check());
                        }
                    }
                }));
                if (hasExecute[0]) {
                    this.lastExecuteTime = checkTime.withSecondOfMinute(0).withMillisOfSecond(0);
                }
                if (!alarmMessageList.isEmpty()) {
                    List filteredMessages;
                    if (!this.alarmRulesWatcher.getCompositeRules().isEmpty()) {
                        List<AlarmMessage> messages = this.alarmRulesWatcher.getCompositeRuleEvaluator().evaluate(this.alarmRulesWatcher.getCompositeRules(), alarmMessageList);
                        alarmMessageList.addAll(messages);
                    }
                    if (!(filteredMessages = alarmMessageList.stream().filter(msg -> !msg.isOnlyAsCondition()).collect(Collectors.toList())).isEmpty()) {
                        for (AlarmCallback callback : allCallbacks) {
                            callback.doAlarm(filteredMessages);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }
}

