/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import io.grpc.Channel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.database.v1.StreamRegistryServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.MetadataClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;

public class StreamMetadataRegistry
extends MetadataClient<StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub, BanyandbDatabase.Stream, Stream> {
    public StreamMetadataRegistry(Channel channel) {
        super(StreamRegistryServiceGrpc.newBlockingStub(channel));
    }

    @Override
    public void create(Stream payload) throws BanyanDBException {
        this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).create(BanyandbDatabase.StreamRegistryServiceCreateRequest.newBuilder().setStream(payload.serialize()).build()));
    }

    @Override
    public void update(Stream payload) throws BanyanDBException {
        this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).update(BanyandbDatabase.StreamRegistryServiceUpdateRequest.newBuilder().setStream(payload.serialize()).build()));
    }

    @Override
    public boolean delete(String group, String name) throws BanyanDBException {
        BanyandbDatabase.StreamRegistryServiceDeleteResponse resp = this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).delete(BanyandbDatabase.StreamRegistryServiceDeleteRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return resp != null && resp.getDeleted();
    }

    @Override
    public Stream get(String group, String name) throws BanyanDBException {
        BanyandbDatabase.StreamRegistryServiceGetResponse resp = this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).get(BanyandbDatabase.StreamRegistryServiceGetRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return Stream.fromProtobuf(resp.getStream());
    }

    @Override
    public ResourceExist exist(String group, String name) throws BanyanDBException {
        BanyandbDatabase.StreamRegistryServiceExistResponse resp = this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).exist(BanyandbDatabase.StreamRegistryServiceExistRequest.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name).build()).build()));
        return ResourceExist.create(resp.getHasGroup(), resp.getHasStream());
    }

    @Override
    public List<Stream> list(String group) throws BanyanDBException {
        BanyandbDatabase.StreamRegistryServiceListResponse resp = this.execute(() -> ((StreamRegistryServiceGrpc.StreamRegistryServiceBlockingStub)this.stub).list(BanyandbDatabase.StreamRegistryServiceListRequest.newBuilder().setGroup(group).build()));
        return resp.getStreamList().stream().map(Stream::fromProtobuf).collect(Collectors.toList());
    }
}

