/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.$AutoValue_Stream;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.TagFamilySpec;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Stream
extends NamedSchema<BanyandbDatabase.Stream> {
    abstract ImmutableList<TagFamilySpec> tagFamilies();

    abstract ImmutableList<String> entityRelativeTags();

    public abstract ImmutableList<IndexRule> indexRules();

    abstract Builder toBuilder();

    public final Stream withIndexRules(List<IndexRule> indexRules) {
        return this.toBuilder().addIndexes(indexRules).build();
    }

    public static Builder create(String group, String name) {
        return new $AutoValue_Stream.Builder().setGroup(group).setName(name);
    }

    @Override
    public BanyandbDatabase.Stream serialize() {
        ArrayList<BanyandbDatabase.TagFamilySpec> metadataTagFamilySpecs = new ArrayList<BanyandbDatabase.TagFamilySpec>(this.tagFamilies().size());
        for (TagFamilySpec spec : this.tagFamilies()) {
            metadataTagFamilySpecs.add(spec.serialize());
        }
        BanyandbDatabase.Stream.Builder b = BanyandbDatabase.Stream.newBuilder().setMetadata(this.buildMetadata()).addAllTagFamilies(metadataTagFamilySpecs).setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames((Iterable<String>)this.entityRelativeTags()).build());
        if (this.updatedAt() != null) {
            b.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return b.build();
    }

    public static Stream fromProtobuf(BanyandbDatabase.Stream pb) {
        Builder s = Stream.create(pb.getMetadata().getGroup(), pb.getMetadata().getName()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt())).setEntityRelativeTags((List<String>)pb.getEntity().getTagNamesList());
        for (int i = 0; i < pb.getTagFamiliesCount(); ++i) {
            s.addTagFamily(TagFamilySpec.fromProtobuf(pb.getTagFamilies(i)));
        }
        return s.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract String group();

        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        abstract ImmutableList.Builder<TagFamilySpec> tagFamiliesBuilder();

        public final Builder addTagFamily(TagFamilySpec tagFamilySpec) {
            this.tagFamiliesBuilder().add((Object)tagFamilySpec);
            return this;
        }

        public final Builder addTagFamilies(Iterable<TagFamilySpec> tagFamilySpecs) {
            this.tagFamiliesBuilder().addAll(tagFamilySpecs);
            return this;
        }

        abstract ImmutableList.Builder<IndexRule> indexRulesBuilder();

        public final Builder addIndexes(Iterable<IndexRule> indexRules) {
            for (IndexRule ir : indexRules) {
                this.addIndex(ir);
            }
            return this;
        }

        public final Builder addIndex(IndexRule indexRule) {
            this.indexRulesBuilder().add((Object)indexRule.withGroup(this.group()));
            return this;
        }

        public abstract Builder setEntityRelativeTags(String ... var1);

        public abstract Builder setEntityRelativeTags(List<String> var1);

        public abstract Stream build();
    }
}

