/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.v1.client.metadata.AutoValue_Group;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.IntervalRule;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Group
extends NamedSchema<BanyandbCommon.Group> {
    abstract Catalog catalog();

    abstract int shardNum();

    @Nullable
    abstract IntervalRule blockInterval();

    @Nullable
    abstract IntervalRule segmentInterval();

    @Nullable
    abstract IntervalRule ttl();

    public static Group create(String name, Catalog catalog, int shardNum, IntervalRule blockInterval, IntervalRule segmentInterval, IntervalRule ttl) {
        Preconditions.checkArgument((shardNum > 0 ? 1 : 0) != 0, (Object)"shardNum should more than 0");
        Preconditions.checkNotNull((Object)blockInterval, (Object)"blockInterval is null");
        Preconditions.checkNotNull((Object)segmentInterval, (Object)"segmentInterval is null");
        Preconditions.checkNotNull((Object)ttl, (Object)"ttl is null");
        return new AutoValue_Group(null, name, null, catalog, shardNum, blockInterval, segmentInterval, ttl);
    }

    public static Group create(String name, Catalog catalog, int shardNum, IntervalRule blockInterval, IntervalRule segmentInterval, IntervalRule ttl, ZonedDateTime updatedAt) {
        Preconditions.checkArgument((shardNum > 0 ? 1 : 0) != 0, (Object)"shardNum should more than 0");
        Preconditions.checkNotNull((Object)blockInterval, (Object)"blockInterval is null");
        Preconditions.checkNotNull((Object)segmentInterval, (Object)"segmentInterval is null");
        Preconditions.checkNotNull((Object)ttl, (Object)"ttl is null");
        return new AutoValue_Group(null, name, updatedAt, catalog, shardNum, blockInterval, segmentInterval, ttl);
    }

    public static Group create(String name) {
        return new AutoValue_Group(null, name, null, Catalog.UNSPECIFIED, 0, null, null, null);
    }

    public static Group create(String name, ZonedDateTime updatedAt) {
        return new AutoValue_Group(null, name, updatedAt, Catalog.UNSPECIFIED, 0, null, null, null);
    }

    @Override
    public BanyandbCommon.Group serialize() {
        BanyandbCommon.Group.Builder builder = BanyandbCommon.Group.newBuilder().setMetadata(this.buildMetadata().toBuilder()).setCatalog(this.catalog().getCatalog());
        if (this.shardNum() > 0) {
            builder.setResourceOpts(BanyandbCommon.ResourceOpts.newBuilder().setShardNum(this.shardNum()).setBlockInterval(this.blockInterval().serialize()).setSegmentInterval(this.segmentInterval().serialize()).setTtl(this.ttl().serialize()).build());
        }
        return builder.build();
    }

    public static Group fromProtobuf(BanyandbCommon.Group group) {
        Catalog catalog = Catalog.UNSPECIFIED;
        switch (group.getCatalog()) {
            case CATALOG_STREAM: {
                catalog = Catalog.STREAM;
                break;
            }
            case CATALOG_MEASURE: {
                catalog = Catalog.MEASURE;
            }
        }
        BanyandbCommon.ResourceOpts opts = group.getResourceOpts();
        return new AutoValue_Group(null, group.getMetadata().getName(), TimeUtils.parseTimestamp(group.getUpdatedAt()), catalog, opts == null ? 0 : opts.getShardNum(), opts == null ? null : IntervalRule.fromProtobuf(opts.getBlockInterval()), opts == null ? null : IntervalRule.fromProtobuf(opts.getSegmentInterval()), opts == null ? null : IntervalRule.fromProtobuf(opts.getTtl()));
    }
}

