/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AutoValue_AbstractQuery_LogicalExpression;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidReferenceException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public abstract class AbstractQuery<T> {
    protected final String group;
    protected final String name;
    protected final TimestampRange timestampRange;
    protected final List<LogicalExpression> conditions;
    protected final Set<String> tagProjections;
    protected final MetadataCache.EntityMetadata metadata;
    protected AbstractCriteria criteria;

    public AbstractQuery(String group, String name, TimestampRange timestampRange, Set<String> tagProjections) {
        this.group = group;
        this.name = name;
        this.timestampRange = timestampRange;
        this.conditions = new ArrayList<LogicalExpression>(10);
        this.tagProjections = tagProjections;
        this.metadata = MetadataCache.INSTANCE.findMetadata(this.group, this.name);
    }

    public AbstractQuery<T> and(PairQueryCondition<?> condition) {
        this.conditions.add(new AutoValue_AbstractQuery_LogicalExpression(BanyandbModel.LogicalExpression.LogicalOp.LOGICAL_OP_AND, condition));
        return this;
    }

    public AbstractQuery<T> or(PairQueryCondition<?> condition) {
        this.conditions.add(new AutoValue_AbstractQuery_LogicalExpression(BanyandbModel.LogicalExpression.LogicalOp.LOGICAL_OP_OR, condition));
        return this;
    }

    public AbstractQuery<T> criteria(AbstractCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    abstract T build() throws BanyanDBException;

    protected BanyandbCommon.Metadata buildMetadata() {
        return BanyandbCommon.Metadata.newBuilder().setGroup(this.group).setName(this.name).build();
    }

    protected Optional<BanyandbModel.Criteria> buildCriteria() {
        if (this.criteria != null) {
            return Optional.of(this.criteria.build());
        }
        if (this.conditions.isEmpty()) {
            return Optional.empty();
        }
        if (this.conditions.size() == 1) {
            return Optional.of(this.conditions.get(0).cond().build());
        }
        return Optional.of(this.conditions.stream().reduce(null, (criteria, logicalExpression) -> {
            BanyandbModel.LogicalExpression.Builder b = BanyandbModel.LogicalExpression.newBuilder();
            if (criteria != null) {
                b.setRight((BanyandbModel.Criteria)criteria);
            }
            return BanyandbModel.Criteria.newBuilder().setLe(b.setOp(logicalExpression.op()).setLeft(logicalExpression.cond().build())).build();
        }, (first, second) -> second));
    }

    protected BanyandbModel.TagProjection buildTagProjections() throws BanyanDBException {
        return this.buildTagProjections(this.tagProjections);
    }

    protected BanyandbModel.TagProjection buildTagProjections(Iterable<String> tagProjections) throws BanyanDBException {
        ArrayListMultimap projectionMap = ArrayListMultimap.create();
        for (String tagName : tagProjections) {
            Optional<MetadataCache.TagInfo> tagInfo = this.metadata.findTagInfo(tagName);
            if (!tagInfo.isPresent()) {
                throw InvalidReferenceException.fromInvalidTag(tagName);
            }
            projectionMap.put((Object)tagInfo.get().getTagFamilyName(), (Object)tagName);
        }
        BanyandbModel.TagProjection.Builder b = BanyandbModel.TagProjection.newBuilder();
        for (String tagFamilyName : projectionMap.keySet()) {
            b.addTagFamilies(BanyandbModel.TagProjection.TagFamily.newBuilder().setName(tagFamilyName).addAllTags(projectionMap.get((Object)tagFamilyName)).build());
        }
        return b.build();
    }

    MetadataCache.EntityMetadata getMetadata() {
        return this.metadata;
    }

    @AutoValue
    static abstract class LogicalExpression {
        LogicalExpression() {
        }

        abstract BanyandbModel.LogicalExpression.LogicalOp op();

        abstract PairQueryCondition<?> cond();
    }

    public static enum Sort {
        UNSPECIFIED,
        ASC,
        DESC;

    }

    public static class OrderBy {
        private final String indexRuleName;
        private final Sort type;

        BanyandbModel.QueryOrder build() {
            BanyandbModel.QueryOrder.Builder builder = BanyandbModel.QueryOrder.newBuilder();
            builder.setIndexRuleName(this.indexRuleName);
            builder.setSort(Sort.DESC.equals((Object)this.type) ? BanyandbModel.Sort.SORT_DESC : BanyandbModel.Sort.SORT_ASC);
            return builder.build();
        }

        public OrderBy(String indexRuleName, Sort type) {
            this.indexRuleName = indexRuleName;
            this.type = type;
        }
    }
}

