/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.zipkin;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="zipkin_service_traffic", scopeId=51, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
public class ZipkinServiceTraffic
extends Metrics {
    public static final String INDEX_NAME = "zipkin_service_traffic";
    public static final String SERVICE_NAME = "service_name";
    @Column(name="service_name")
    @BanyanDB.SeriesID(index=0)
    private String serviceName = "";

    @Override
    protected StorageID id0() {
        return new StorageID().append(SERVICE_NAME, this.serviceName);
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceName(remoteData.getDataStrings(0));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.serviceName);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinServiceTraffic)) {
            return false;
        }
        ZipkinServiceTraffic other = (ZipkinServiceTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        return !(this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZipkinServiceTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        return result;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    public static class Builder
    implements StorageBuilder<ZipkinServiceTraffic> {
        @Override
        public ZipkinServiceTraffic storage2Entity(Convert2Entity converter) {
            ZipkinServiceTraffic serviceTraffic = new ZipkinServiceTraffic();
            serviceTraffic.setServiceName((String)converter.get(ZipkinServiceTraffic.SERVICE_NAME));
            if (converter.get("time_bucket") != null) {
                serviceTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            }
            return serviceTraffic;
        }

        @Override
        public void entity2Storage(ZipkinServiceTraffic storageData, Convert2Storage converter) {
            converter.accept(ZipkinServiceTraffic.SERVICE_NAME, storageData.getServiceName());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

