/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.lang.reflect.Type;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBExtension;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchExtension;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseExtension;

public class ModelColumn {
    private final ColumnName columnName;
    private final Class<?> type;
    private final Type genericType;
    private final boolean storageOnly;
    private final boolean indexOnly;
    private final int length;
    private final SQLDatabaseExtension sqlDatabaseExtension;
    private final ElasticSearchExtension elasticSearchExtension;
    private final BanyanDBExtension banyanDBExtension;

    public ModelColumn(ColumnName columnName, Class<?> type, Type genericType, boolean storageOnly, boolean indexOnly, boolean isValue, int length, SQLDatabaseExtension sqlDatabaseExtension, ElasticSearchExtension elasticSearchExtension, BanyanDBExtension banyanDBExtension) {
        this.columnName = columnName;
        this.type = type;
        this.genericType = genericType;
        this.length = length;
        this.sqlDatabaseExtension = sqlDatabaseExtension;
        this.elasticSearchExtension = elasticSearchExtension;
        if (type.equals(byte[].class) || type.equals(DataTable.class)) {
            this.storageOnly = true;
        } else {
            if (storageOnly && isValue) {
                throw new IllegalArgumentException("The column " + columnName + " can't be defined as both isValue and storageOnly.");
            }
            this.storageOnly = storageOnly;
        }
        if (storageOnly && indexOnly) {
            throw new IllegalArgumentException("The column " + columnName + " can't be defined as both indexOnly and storageOnly.");
        }
        this.indexOnly = indexOnly;
        this.banyanDBExtension = banyanDBExtension;
    }

    public boolean shouldIndex() {
        return !this.storageOnly;
    }

    @Generated
    public ColumnName getColumnName() {
        return this.columnName;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public Type getGenericType() {
        return this.genericType;
    }

    @Generated
    public boolean isStorageOnly() {
        return this.storageOnly;
    }

    @Generated
    public boolean isIndexOnly() {
        return this.indexOnly;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public SQLDatabaseExtension getSqlDatabaseExtension() {
        return this.sqlDatabaseExtension;
    }

    @Generated
    public ElasticSearchExtension getElasticSearchExtension() {
        return this.elasticSearchExtension;
    }

    @Generated
    public BanyanDBExtension getBanyanDBExtension() {
        return this.banyanDBExtension;
    }

    @Generated
    public String toString() {
        return "ModelColumn(columnName=" + this.getColumnName() + ", type=" + this.getType() + ", genericType=" + this.getGenericType() + ", storageOnly=" + this.isStorageOnly() + ", indexOnly=" + this.isIndexOnly() + ", length=" + this.getLength() + ", sqlDatabaseExtension=" + this.getSqlDatabaseExtension() + ", elasticSearchExtension=" + this.getElasticSearchExtension() + ", banyanDBExtension=" + this.getBanyanDBExtension() + ")";
    }
}

