/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PersistenceTimer {
    INSTANCE;

    @Generated
    private static final Logger log;
    @VisibleForTesting
    boolean isStarted = false;
    private CounterMetrics errorCounter;
    private HistogramMetrics prepareLatency;
    private HistogramMetrics executeLatency;
    private HistogramMetrics allLatency;
    private ExecutorService prepareExecutorService;

    public void start(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        log.info("persistence timer start");
        IBatchDAO batchDAO = (IBatchDAO)moduleManager.find("storage").provider().getService(IBatchDAO.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.errorCounter = metricsCreator.createCounter("persistence_timer_bulk_error_count", "Error execution of the prepare stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.prepareLatency = metricsCreator.createHistogramMetric("persistence_timer_bulk_prepare_latency", "Latency of the prepare stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.executeLatency = metricsCreator.createHistogramMetric("persistence_timer_bulk_execute_latency", "Latency of the execute stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.allLatency = metricsCreator.createHistogramMetric("persistence_timer_bulk_all_latency", "Latency of the all stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.prepareExecutorService = Executors.newFixedThreadPool(moduleConfig.getPrepareThreads());
        if (!this.isStarted) {
            Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(() -> this.extractDataAndSave(batchDAO).join(), t -> log.error("Extract data and save failure.", t)), 5L, moduleConfig.getPersistentPeriod(), TimeUnit.SECONDS);
            this.isStarted = true;
        }
    }

    private CompletableFuture<Void> extractDataAndSave(IBatchDAO batchDAO) {
        if (log.isDebugEnabled()) {
            log.debug("Extract data and save");
        }
        long startTime = System.currentTimeMillis();
        HistogramMetrics.Timer allTimer = this.allLatency.createTimer();
        ArrayList<PersistenceWorker> workers = new ArrayList<PersistenceWorker>();
        workers.addAll(TopNStreamProcessor.getInstance().getPersistentWorkers());
        workers.addAll(MetricsStreamProcessor.getInstance().getPersistentWorkers());
        CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])workers.stream().map(worker -> CompletableFuture.runAsync(() -> {
            List<PrepareRequest> innerPrepareRequests;
            try (HistogramMetrics.Timer ignored = this.prepareLatency.createTimer();){
                if (log.isDebugEnabled()) {
                    log.debug("extract {} worker data and save", (Object)worker.getClass().getName());
                }
                innerPrepareRequests = worker.buildBatchRequests();
                worker.endOfRound();
            }
            if (CollectionUtils.isEmpty(innerPrepareRequests)) {
                return;
            }
            HistogramMetrics.Timer executeLatencyTimer = this.executeLatency.createTimer();
            batchDAO.flush(innerPrepareRequests).whenComplete(($1, $2) -> executeLatencyTimer.close());
        }, this.prepareExecutorService)).toArray(CompletableFuture[]::new));
        future.whenComplete((unused, throwable) -> {
            batchDAO.endOfFlush();
            allTimer.close();
            if (log.isDebugEnabled()) {
                log.debug("Batch persistence duration: {} ms", (Object)(System.currentTimeMillis() - startTime));
            }
            if (throwable != null) {
                this.errorCounter.inc();
                log.error(throwable.getMessage(), throwable);
            }
        });
        return future;
    }

    static {
        log = LoggerFactory.getLogger(PersistenceTimer.class);
    }
}

