/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.status;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.status.BootingStatus;
import org.apache.skywalking.oap.server.core.status.ClusterStatus;
import org.apache.skywalking.oap.server.core.status.ServerStatusWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class ServerStatusService
implements Service {
    private final ModuleManager manager;
    private BootingStatus bootingStatus = new BootingStatus();
    private ClusterStatus clusterStatus = new ClusterStatus();
    private List<ServerStatusWatcher> statusWatchers = new ArrayList<ServerStatusWatcher>();

    public void bootedNow(long uptime) {
        this.bootingStatus.setBooted(true);
        this.bootingStatus.setUptime(uptime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("uptime", "oap server start up time", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)uptime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onServerBooted(this.bootingStatus));
    }

    public void rebalancedCluster(long rebalancedTime) {
        this.clusterStatus.setRebalancedTime(rebalancedTime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("cluster_rebalanced_time", "oap cluster rebalanced time after scale", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)rebalancedTime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onClusterRebalanced(this.clusterStatus));
    }

    public void registerWatcher(ServerStatusWatcher watcher) {
        this.statusWatchers.add(watcher);
    }

    @Generated
    public ServerStatusService(ModuleManager manager) {
        this.manager = manager;
    }

    @Generated
    public BootingStatus getBootingStatus() {
        return this.bootingStatus;
    }

    @Generated
    public ClusterStatus getClusterStatus() {
        return this.clusterStatus;
    }
}

