/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.input;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.MetricsMetadataQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.MetricsType;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class RecordCondition {
    private String name;
    private Entity parentEntity;
    private int topN;
    private Order order;

    public RecordCondition() {
    }

    public RecordCondition(TopNCondition condition) {
        this.name = condition.getName();
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            Entity entity = new Entity();
            entity.setScope(condition.getScope() == null ? Scope.Service : condition.getScope());
            entity.setServiceName(condition.getParentService());
            entity.setNormal(condition.isNormal());
            this.parentEntity = entity;
        }
        this.topN = condition.getTopN();
        this.order = condition.getOrder();
    }

    public boolean senseScope() {
        if (MetricsType.UNKNOWN.equals((Object)MetricsMetadataQueryService.typeOfMetrics(this.name))) {
            return false;
        }
        this.parentEntity.setScope(ValueColumnMetadata.INSTANCE.getScope(this.name));
        return true;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParentEntity(Entity parentEntity) {
        this.parentEntity = parentEntity;
    }

    @Generated
    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Generated
    public void setOrder(Order order) {
        this.order = order;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Entity getParentEntity() {
        return this.parentEntity;
    }

    @Generated
    public int getTopN() {
        return this.topN;
    }

    @Generated
    public Order getOrder() {
        return this.order;
    }
}

