/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.ProcessTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.ServiceInstanceTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.ServiceTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.EndpointNode;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.Node;
import org.apache.skywalking.oap.server.core.query.type.ProcessTopology;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyQueryService.class);
    private final ModuleManager moduleManager;
    private final StorageModels storageModels;
    private ITopologyQueryDAO topologyQueryDAO;
    private IComponentLibraryCatalogService componentLibraryCatalogService;

    public TopologyQueryService(ModuleManager moduleManager, StorageModels storageModels) {
        this.moduleManager = moduleManager;
        this.storageModels = storageModels;
    }

    private ITopologyQueryDAO getTopologyQueryDAO() {
        if (this.topologyQueryDAO == null) {
            this.topologyQueryDAO = (ITopologyQueryDAO)this.moduleManager.find("storage").provider().getService(ITopologyQueryDAO.class);
        }
        return this.topologyQueryDAO;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    public Topology getGlobalTopology(Duration duration) throws IOException {
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSide(duration);
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadServiceRelationDetectedAtClientSide(duration);
        ServiceTopologyBuilder builder = new ServiceTopologyBuilder(this.moduleManager);
        return builder.build(serviceRelationClientCalls, serviceRelationServerCalls);
    }

    public Topology getServiceTopology(Duration duration, List<String> serviceIds) throws IOException {
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadServiceRelationDetectedAtClientSide(duration, serviceIds);
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSide(duration, serviceIds);
        ServiceTopologyBuilder builder = new ServiceTopologyBuilder(this.moduleManager);
        Topology topology = builder.build(serviceRelationClientCalls, serviceRelationServerCalls);
        ArrayList<String> outScopeSourceServiceIds = new ArrayList<String>();
        serviceRelationClientCalls.forEach(call -> {
            if (!serviceIds.contains(call.getSource())) {
                outScopeSourceServiceIds.add(call.getSource());
            }
        });
        if (CollectionUtils.isNotEmpty(outScopeSourceServiceIds)) {
            List<Call.CallDetail> sourceCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSide(duration, outScopeSourceServiceIds);
            topology.getNodes().forEach(node -> {
                if (Strings.isNullOrEmpty((String)node.getType())) {
                    for (Call.CallDetail call : sourceCalls) {
                        if (!node.getId().equals(call.getTarget())) continue;
                        node.setType(this.getComponentLibraryCatalogService().getComponentName(call.getComponentId()));
                        break;
                    }
                }
            });
        }
        return topology;
    }

    public ServiceInstanceTopology getServiceInstanceTopology(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        List<Call.CallDetail> serviceInstanceRelationClientCalls = this.getTopologyQueryDAO().loadInstanceRelationDetectedAtClientSide(clientServiceId, serverServiceId, duration);
        List<Call.CallDetail> serviceInstanceRelationServerCalls = this.getTopologyQueryDAO().loadInstanceRelationDetectedAtServerSide(clientServiceId, serverServiceId, duration);
        ServiceInstanceTopologyBuilder builder = new ServiceInstanceTopologyBuilder(this.moduleManager);
        return builder.build(serviceInstanceRelationClientCalls, serviceInstanceRelationServerCalls);
    }

    @Deprecated
    public Topology getEndpointTopology(Duration duration, String endpointId) throws IOException {
        List<Call.CallDetail> serverSideCalls = this.getTopologyQueryDAO().loadEndpointRelation(duration, endpointId);
        Topology topology = new Topology();
        serverSideCalls.forEach(callDetail -> {
            Call call = new Call();
            call.setId(callDetail.getId());
            call.setSource(callDetail.getSource());
            call.setTarget(callDetail.getTarget());
            call.addDetectPoint(DetectPoint.SERVER);
            topology.getCalls().add(call);
        });
        HashSet nodeIds = new HashSet();
        serverSideCalls.forEach(call -> {
            if (!nodeIds.contains(call.getSource())) {
                topology.getNodes().add(this.buildEndpointNode(call.getSource()));
                nodeIds.add(call.getSource());
            }
            if (!nodeIds.contains(call.getTarget())) {
                topology.getNodes().add(this.buildEndpointNode(call.getTarget()));
                nodeIds.add(call.getTarget());
            }
        });
        return topology;
    }

    public EndpointTopology getEndpointDependencies(Duration duration, String endpointId) throws IOException {
        List<Call.CallDetail> serverSideCalls = this.getTopologyQueryDAO().loadEndpointRelation(duration, endpointId);
        EndpointTopology topology = new EndpointTopology();
        serverSideCalls.forEach(callDetail -> {
            Call call = new Call();
            call.setId(callDetail.getId());
            call.setSource(callDetail.getSource());
            call.setTarget(callDetail.getTarget());
            call.addDetectPoint(DetectPoint.SERVER);
            topology.getCalls().add(call);
        });
        HashSet nodeIds = new HashSet();
        serverSideCalls.forEach(call -> {
            if (!nodeIds.contains(call.getSource())) {
                topology.getNodes().add(this.buildEndpointDependencyNode(call.getSource()));
                nodeIds.add(call.getSource());
            }
            if (!nodeIds.contains(call.getTarget())) {
                topology.getNodes().add(this.buildEndpointDependencyNode(call.getTarget()));
                nodeIds.add(call.getTarget());
            }
        });
        return topology;
    }

    public ProcessTopology getProcessTopology(String instanceId, Duration duration) throws Exception {
        List<Call.CallDetail> clientCalls = this.getTopologyQueryDAO().loadProcessRelationDetectedAtClientSide(instanceId, duration);
        List<Call.CallDetail> serverCalls = this.getTopologyQueryDAO().loadProcessRelationDetectedAtServerSide(instanceId, duration);
        ProcessTopologyBuilder topologyBuilder = new ProcessTopologyBuilder(this.moduleManager, this.storageModels);
        return topologyBuilder.build(clientCalls, serverCalls);
    }

    @Deprecated
    private Node buildEndpointNode(String endpointId) {
        Node node = new Node();
        node.setId(endpointId);
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        node.setName(endpointIDDefinition.getEndpointName());
        node.setType("");
        node.setReal(true);
        return node;
    }

    private EndpointNode buildEndpointDependencyNode(String endpointId) {
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        EndpointNode instanceNode = new EndpointNode();
        instanceNode.setId(endpointId);
        instanceNode.setName(endpointIDDefinition.getEndpointName());
        instanceNode.setServiceId(endpointIDDefinition.getServiceId());
        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
        instanceNode.setServiceName(serviceIDDefinition.getName());
        instanceNode.setReal(serviceIDDefinition.isReal());
        return instanceNode;
    }
}

