/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum DurationUtils {
    INSTANCE;

    private static final int MAX_TIME_RANGE = 500;
    public static final DateTimeFormatter YYYY_MM_DD;
    public static final DateTimeFormatter YYYY_MM_DD_HH;
    public static final DateTimeFormatter YYYY_MM_DD_HHMM;
    public static final DateTimeFormatter YYYY_MM_DD_HHMMSS;
    private static final DateTimeFormatter YYYYMMDD;
    private static final DateTimeFormatter YYYYMMDDHH;
    private static final DateTimeFormatter YYYYMMDDHHMM;
    private static final DateTimeFormatter YYYYMMDDHHMMSS;

    public long convertToTimeBucket(Step step, String dateStr) {
        this.verifyDateTimeString(step, dateStr);
        dateStr = dateStr.replaceAll("-", "");
        dateStr = dateStr.replaceAll(" ", "");
        return Long.parseLong(dateStr);
    }

    public long startTimeDurationToSecondTimeBucket(Step step, String dateStr) {
        long secondTimeBucket = this.convertToTimeBucket(step, dateStr);
        switch (step) {
            case DAY: {
                return secondTimeBucket * 100L * 100L * 100L;
            }
            case HOUR: {
                return secondTimeBucket * 100L * 100L;
            }
            case MINUTE: {
                return secondTimeBucket * 100L;
            }
            case SECOND: {
                return secondTimeBucket;
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public long endTimeDurationToSecondTimeBucket(Step step, String dateStr) {
        long secondTimeBucket = this.convertToTimeBucket(step, dateStr);
        switch (step) {
            case DAY: {
                return ((secondTimeBucket * 100L + 23L) * 100L + 59L) * 100L + 59L;
            }
            case HOUR: {
                return (secondTimeBucket * 100L + 59L) * 100L + 59L;
            }
            case MINUTE: {
                return secondTimeBucket * 100L + 59L;
            }
            case SECOND: {
                return secondTimeBucket;
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public List<PointOfTime> getDurationPoints(Step step, long startTimeBucket, long endTimeBucket) {
        DateTime dateTime = this.parseToDateTime(step, startTimeBucket);
        LinkedList<PointOfTime> durations = new LinkedList<PointOfTime>();
        durations.add(new PointOfTime(startTimeBucket));
        if (startTimeBucket == endTimeBucket) {
            return durations;
        }
        int i = 0;
        do {
            switch (step) {
                case DAY: {
                    dateTime = dateTime.plusDays(1);
                    String timeBucket = YYYYMMDD.print((ReadableInstant)dateTime);
                    durations.add(new PointOfTime(Long.parseLong(timeBucket)));
                    break;
                }
                case HOUR: {
                    dateTime = dateTime.plusHours(1);
                    String timeBucket = YYYYMMDDHH.print((ReadableInstant)dateTime);
                    durations.add(new PointOfTime(Long.parseLong(timeBucket)));
                    break;
                }
                case MINUTE: {
                    dateTime = dateTime.plusMinutes(1);
                    String timeBucket = YYYYMMDDHHMM.print((ReadableInstant)dateTime);
                    durations.add(new PointOfTime(Long.parseLong(timeBucket)));
                    break;
                }
                case SECOND: {
                    dateTime = dateTime.plusSeconds(1);
                    String timeBucket = YYYYMMDDHHMMSS.print((ReadableInstant)dateTime);
                    durations.add(new PointOfTime(Long.parseLong(timeBucket)));
                }
            }
            if (++i <= 500) continue;
            String stepStr = step.name().toLowerCase() + "s";
            String errorMsg = String.format("Duration data error, the range between the start time and the end time can't exceed %d %s", 500, stepStr);
            throw new UnexpectedException(errorMsg);
        } while (endTimeBucket != ((PointOfTime)durations.get(durations.size() - 1)).getPoint());
        return durations;
    }

    public long startTimeToTimestamp(Step step, String dateStr) {
        switch (step) {
            case DAY: {
                return YYYY_MM_DD.parseMillis(dateStr);
            }
            case HOUR: {
                return YYYY_MM_DD_HH.parseMillis(dateStr);
            }
            case MINUTE: {
                return YYYY_MM_DD_HHMM.parseMillis(dateStr);
            }
            case SECOND: {
                return YYYY_MM_DD_HHMMSS.parseMillis(dateStr);
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public long endTimeToTimestamp(Step step, String dateStr) {
        switch (step) {
            case DAY: {
                return YYYY_MM_DD.parseDateTime(dateStr).plusDays(1).getMillis();
            }
            case HOUR: {
                return YYYY_MM_DD_HH.parseDateTime(dateStr).plusHours(1).getMillis();
            }
            case MINUTE: {
                return YYYY_MM_DD_HHMM.parseDateTime(dateStr).plusMinutes(1).getMillis();
            }
            case SECOND: {
                return YYYY_MM_DD_HHMMSS.parseDateTime(dateStr).plusSeconds(1).getMillis();
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    public DateTime parseToDateTime(Step step, long time) {
        switch (step) {
            case DAY: {
                return YYYYMMDD.parseDateTime(String.valueOf(time));
            }
            case HOUR: {
                return YYYYMMDDHH.parseDateTime(String.valueOf(time));
            }
            case MINUTE: {
                return YYYYMMDDHHMM.parseDateTime(String.valueOf(time));
            }
            case SECOND: {
                return YYYYMMDDHHMMSS.parseDateTime(String.valueOf(time));
            }
        }
        throw new UnexpectedException("Unexpected downsampling: " + step.name());
    }

    public void verifyDateTimeString(Step step, String dateStr) {
        switch (step) {
            case DAY: {
                YYYY_MM_DD.parseDateTime(dateStr);
                return;
            }
            case HOUR: {
                YYYY_MM_DD_HH.parseDateTime(dateStr);
                return;
            }
            case MINUTE: {
                YYYY_MM_DD_HHMM.parseDateTime(dateStr);
                return;
            }
            case SECOND: {
                YYYY_MM_DD_HHMMSS.parseDateTime(dateStr);
                return;
            }
        }
        throw new UnexpectedException("Unsupported step " + step.name());
    }

    static {
        YYYY_MM_DD = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        YYYY_MM_DD_HH = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH");
        YYYY_MM_DD_HHMM = DateTimeFormat.forPattern((String)"yyyy-MM-dd HHmm");
        YYYY_MM_DD_HHMMSS = DateTimeFormat.forPattern((String)"yyyy-MM-dd HHmmss");
        YYYYMMDD = DateTimeFormat.forPattern((String)"yyyyMMdd");
        YYYYMMDDHH = DateTimeFormat.forPattern((String)"yyyyMMddHH");
        YYYYMMDDHHMM = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
        YYYYMMDDHHMMSS = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    }
}

