/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group.uri.quickmatch;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.PatternToken;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.StringToken;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.VarToken;
import org.apache.skywalking.oap.server.library.util.StringFormatGroup;

public class PatternTree {
    private final List<PatternToken> roots = new ArrayList<PatternToken>();

    public void addPattern(String pattern) {
        String[] tokens = pattern.split("/");
        PatternToken current = null;
        for (PatternToken patternToken : this.roots) {
            if (!patternToken.isMatch(tokens[0])) continue;
            current = patternToken;
            break;
        }
        if (current == null) {
            current = new StringToken(tokens[0]);
            this.roots.add(current);
        }
        if (tokens.length == 1) {
            current.setExpression(pattern);
            return;
        }
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            PatternToken newToken = "{var}".equals(token) ? new VarToken() : new StringToken(token);
            PatternToken found = current.find(newToken);
            current = found == null ? current.add(newToken) : found;
        }
        current.setExpression(pattern);
    }

    List<String> splitByCharacter(String input, char delimiter) {
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != delimiter) continue;
            parts.add(input.substring(start, i));
            start = i + 1;
        }
        if (start < input.length()) {
            parts.add(input.substring(start));
        }
        return parts;
    }

    public StringFormatGroup.FormatResult match(String uri) {
        List<String> slices = this.splitByCharacter(uri, '/');
        List<PatternToken> current = this.roots;
        PatternToken matchedToken = null;
        for (String slice : slices) {
            boolean matched = false;
            for (PatternToken patternToken : current) {
                if (!patternToken.isMatch(slice)) continue;
                matchedToken = patternToken;
                matched = true;
                break;
            }
            if (!matched) {
                return new StringFormatGroup.FormatResult(false, uri, null);
            }
            current = matchedToken.children();
        }
        if (matchedToken.isLeaf()) {
            return new StringFormatGroup.FormatResult(true, uri, matchedToken.expression());
        }
        return new StringFormatGroup.FormatResult(false, uri, null);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatternTree)) {
            return false;
        }
        PatternTree other = (PatternTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PatternToken> this$roots = this.roots;
        List<PatternToken> other$roots = other.roots;
        return !(this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatternTree;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PatternToken> $roots = this.roots;
        result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PatternTree(roots=" + this.roots + ")";
    }
}

